/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.species;

import com.mojang.blaze3d.vertex.PoseStack;
import fathertoast.specialmobs.client.misc.SMRenderTypes;
import fathertoast.specialmobs.client.renderer.entity.layers.SpecialGhastEyesLayer;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ghast.CorporealShiftGhastEntity;
import fathertoast.specialmobs.common.util.References;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class CorporealShiftGhastRenderer
extends MobRenderer<CorporealShiftGhastEntity, GhastModel<CorporealShiftGhastEntity>> {
    private static final Function<ResourceLocation, RenderType> INCORPOREAL = SMRenderTypes::entityCutoutNoCullBlend;
    private static final ResourceLocation EYES = References.getEntityEyesTexture("ghast", "corporeal_shift");
    private static final ResourceLocation SHOOT_EYES = References.getEntityShootingEyesTexture("ghast", "corporeal_shift");
    private final float baseShadowRadius;

    public CorporealShiftGhastRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GhastModel(context.m_174023_(ModelLayers.f_171150_)), 1.5f);
        this.baseShadowRadius = this.f_114477_;
        this.m_115326_((RenderLayer)new SpecialGhastEyesLayer(this, EYES, SHOOT_EYES));
    }

    public void render(CorporealShiftGhastEntity ghast, float rotation, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ((GhastModel)this.f_115290_).f_103106_ = ghast.isCorporeal() ? RenderType::m_110458_ : INCORPOREAL;
        super.m_7392_((Mob)ghast, rotation, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(CorporealShiftGhastEntity entity) {
        SpecialMobData data = entity.getSpecialData();
        return entity.m_32756_() && data.getTextureAnimation() != null ? data.getTextureAnimation() : data.getTexture();
    }

    protected void scale(CorporealShiftGhastEntity entity, PoseStack poseStack, float partialTick) {
        poseStack.m_85841_(4.5f, 4.5f, 4.5f);
        float scale = entity.getSpecialData().getRenderScale();
        this.f_114477_ = this.baseShadowRadius * scale;
        poseStack.m_85841_(scale, scale, scale);
    }
}

