/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fathertoast.specialmobs.common.entity.projectile.SpecialFishingBobberEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SpecialFishingBobberRenderer
extends EntityRenderer<SpecialFishingBobberEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110452_((ResourceLocation)TEXTURE_LOCATION);

    public SpecialFishingBobberRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpecialFishingBobberEntity entity, float rotation, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        LivingEntity angler = entity.getLivingOwner();
        if (angler == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose lastPose = poseStack.m_85850_();
        SpecialFishingBobberRenderer.drawQuad(buffer.m_6299_(RENDER_TYPE), lastPose.m_252922_(), lastPose.m_252943_(), packedLight);
        poseStack.m_85849_();
        ItemStack heldItem = angler.m_21205_();
        int handedness = heldItem.m_41720_() != Items.f_42523_ && heldItem.m_41720_() != Items.f_42398_ ? 0 : (angler.m_5737_() == HumanoidArm.RIGHT ? 1 : -1);
        double forwardOffset = 0.5;
        double rightwardOffset = (double)handedness * 0.35;
        double upwardOffset = angler.m_20192_() - (angler.m_6047_() ? 0.1875f : 0.0f);
        float yRot = Mth.m_14179_((float)partialTicks, (float)angler.f_20884_, (float)angler.f_20883_) * (float)Math.PI / 180.0f;
        double forwardX = Mth.m_14031_((float)yRot);
        double forwardZ = Mth.m_14089_((float)yRot);
        double xRod = Mth.m_14139_((double)partialTicks, (double)angler.f_19854_, (double)angler.m_20185_()) - forwardX * 0.5 - forwardZ * rightwardOffset;
        double yRod = Mth.m_14139_((double)partialTicks, (double)angler.f_19855_, (double)angler.m_20186_()) + upwardOffset;
        double zRod = Mth.m_14139_((double)partialTicks, (double)angler.f_19856_, (double)angler.m_20189_()) + forwardZ * 0.5 - forwardX * rightwardOffset;
        double xBobber = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
        double yBobber = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_()) + 0.25;
        double zBobber = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
        SpecialFishingBobberRenderer.drawLine(buffer.m_6299_(RenderType.m_173247_()), poseStack.m_85850_(), 16, xBobber, yBobber, zBobber, xRod, yRod, zRod);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, rotation, partialTicks, poseStack, buffer, packedLight);
    }

    private static void drawQuad(VertexConsumer vertexConsumer, Matrix4f pose, Matrix3f normal, int packedLight) {
        SpecialFishingBobberRenderer.quadVertex(vertexConsumer, pose, normal, packedLight, 0.0f, 0.0f, 0, 1);
        SpecialFishingBobberRenderer.quadVertex(vertexConsumer, pose, normal, packedLight, 1.0f, 0.0f, 1, 1);
        SpecialFishingBobberRenderer.quadVertex(vertexConsumer, pose, normal, packedLight, 1.0f, 1.0f, 1, 0);
        SpecialFishingBobberRenderer.quadVertex(vertexConsumer, pose, normal, packedLight, 0.0f, 1.0f, 0, 0);
    }

    private static void quadVertex(VertexConsumer vertexConsumer, Matrix4f pose, Matrix3f normal, int packedLight, float dX, float dY, int u, int v) {
        vertexConsumer.m_252986_(pose, dX - 0.5f, dY - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void drawLine(VertexConsumer vertexConsumer, PoseStack.Pose pose, int resolution, double x1, double y1, double z1, double x2, double y2, double z2) {
        float dX = (float)(x2 - x1);
        float dY = (float)(y2 - y1);
        float dZ = (float)(z2 - z1);
        for (int segment = 0; segment < resolution; ++segment) {
            SpecialFishingBobberRenderer.lineVertex(dX, dY, dZ, vertexConsumer, pose, segment, resolution);
        }
    }

    private static void lineVertex(float x, float y, float z, VertexConsumer vertexConsumer, PoseStack.Pose pose, float segment, float totalSegments) {
        float r = segment / totalSegments;
        float k = segment + 1.0f / totalSegments;
        float vertX = x * r;
        float vertY = y * (r * r + r) * 0.5f + 0.25f;
        float vertZ = z * r;
        float normalX = x * k - vertX;
        float normalY = y * (k * k + k) * 0.5f + 0.25f - vertY;
        float normalZ = z * k - vertZ;
        float squared = Mth.m_14116_((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        vertexConsumer.m_252986_(pose.m_252922_(), vertX, vertY, vertZ).m_6122_(0, 0, 0, 255).m_252939_(pose.m_252943_(), normalX /= squared, normalY /= squared, normalZ /= squared).m_5752_();
    }

    public ResourceLocation getTextureLocation(SpecialFishingBobberEntity entity) {
        return TEXTURE_LOCATION;
    }
}

