/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.model;

import com.google.common.collect.ImmutableList;
import fathertoast.specialmobs.common.entity.misc.MobBoat;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MobRaftModel
extends ListModel<MobBoat> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ImmutableList<ModelPart> parts;

    public MobRaftModel(ModelPart root) {
        this.leftPaddle = root.m_171324_("left_paddle");
        this.rightPaddle = root.m_171324_("right_paddle");
        this.parts = this.createPartsBuilder(root).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart root) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{root.m_171324_("bottom"), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static void createChildren(PartDefinition partDefinition) {
        partDefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-14.0f, -11.0f, -4.0f, 28.0f, 20.0f, 4.0f).m_171514_(0, 0).m_171481_(-14.0f, -9.0f, -8.0f, 28.0f, 16.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("left_paddle", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partDefinition.m_171599_("right_paddle", CubeListBuilder.m_171558_().m_171514_(40, 24).m_171481_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).m_171481_(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        MobRaftModel.createChildren(partDefinition);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(MobBoat boat, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        MobRaftModel.animatePaddle(boat, 0, this.leftPaddle, limbSwing);
        MobRaftModel.animatePaddle(boat, 1, this.rightPaddle, limbSwing);
    }

    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    private static void animatePaddle(MobBoat boat, int paddleIndex, ModelPart paddle, float limbSwing) {
        float rowingTime = boat.getRowingTime(paddleIndex, limbSwing);
        paddle.f_104203_ = Mth.m_144920_((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.m_14031_((float)(-rowingTime)) + 1.0f) / 2.0f));
        paddle.f_104204_ = Mth.m_144920_((float)-0.7853982f, (float)0.7853982f, (float)((Mth.m_14031_((float)(-rowingTime + 1.0f)) + 1.0f) / 2.0f));
        if (paddleIndex == 1) {
            paddle.f_104204_ = (float)Math.PI - paddle.f_104204_;
        }
    }
}

