/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.misc;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import fathertoast.specialmobs.client.renderer.entity.layers.SMModelLayers;
import fathertoast.specialmobs.client.renderer.entity.model.MobBoatModel;
import fathertoast.specialmobs.client.renderer.entity.model.MobRaftModel;
import fathertoast.specialmobs.common.entity.misc.MobBoat;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class MobBoatRenderer
extends EntityRenderer<MobBoat> {
    private final Map<Boat.Type, Pair<ResourceLocation, ListModel<MobBoat>>> boatResources;

    public MobBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, t -> Pair.of((Object)new ResourceLocation(MobBoatRenderer.getTextureLocation(t)), this.createBoatModel(context, (Boat.Type)t))));
    }

    private ListModel<MobBoat> createBoatModel(EntityRendererProvider.Context context, Boat.Type type) {
        ModelLayerLocation layerLocation = SMModelLayers.createBoatModelName(type);
        ModelPart modelPart = context.m_174023_(layerLocation);
        if (type == Boat.Type.BAMBOO) {
            return new MobRaftModel(modelPart);
        }
        return new MobBoatModel(modelPart);
    }

    private static String getTextureLocation(Boat.Type type) {
        return "textures/entity/boat/" + type.m_38429_() + ".png";
    }

    public void render(MobBoat mobBoat, float rotation, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float bubbleAngle;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotation));
        float hurtTime = (float)mobBoat.getHurtTime() - partialTicks;
        float boatDamage = mobBoat.getDamage() - partialTicks;
        if (boatDamage < 0.0f) {
            boatDamage = 0.0f;
        }
        if (hurtTime > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)hurtTime) * hurtTime * boatDamage / 10.0f * (float)mobBoat.getHurtDir()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = mobBoat.getBubbleAngle(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(mobBoat.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<MobBoat>> pair = this.getModelWithLocation(mobBoat);
        ResourceLocation textureLoc = (ResourceLocation)pair.getFirst();
        ListModel boatModel = (ListModel)pair.getSecond();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        boatModel.m_6973_((Entity)mobBoat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer buffer = bufferSource.m_6299_(boatModel.m_103119_(textureLoc));
        boatModel.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!mobBoat.m_5842_()) {
            VertexConsumer waterMask = bufferSource.m_6299_(RenderType.m_110478_());
            if (boatModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchModel = (WaterPatchModel)boatModel;
                waterPatchModel.m_102282_().m_104301_(poseStack, waterMask, packedLight, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)mobBoat, rotation, partialTicks, poseStack, bufferSource, packedLight);
    }

    @Deprecated
    public ResourceLocation getTextureLocation(MobBoat mobBoat) {
        return (ResourceLocation)this.getModelWithLocation(mobBoat).getFirst();
    }

    public Pair<ResourceLocation, ListModel<MobBoat>> getModelWithLocation(MobBoat boat) {
        return this.boatResources.get(boat.getVariant());
    }
}

