/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.References;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EnergySwirlLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;

public class SpecialCreeperChargeLayer<T extends HierarchicalModel<Creeper>>
extends EnergySwirlLayer<Creeper, T> {
    private static final ResourceLocation[] CHARGED = new ResourceLocation[]{References.getEntityTexture("creeper", "creeper_armor"), References.getEntityTexture("creeper", "super_charged")};
    private final CreeperModel<Creeper> model;

    public SpecialCreeperChargeLayer(RenderLayerParent<Creeper, T> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.model = new CreeperModel(modelSet.m_171103_(ModelLayers.f_171129_));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Creeper creeper, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (creeper.m_7090_() || ((_SpecialCreeperEntity)creeper).isSupercharged()) {
            float tickAndPartial = (float)creeper.f_19797_ + partialTicks;
            float textureOffset = tickAndPartial * 0.01f;
            this.model.m_6839_((Entity)creeper, limbSwing, limbSwingAmount, partialTicks);
            ((HierarchicalModel)this.m_117386_()).m_102624_(this.model);
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110436_((ResourceLocation)this.getTextureLocation(creeper), (float)textureOffset, (float)textureOffset));
            this.model.m_6973_((Entity)creeper, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    protected ResourceLocation getTextureLocation(Creeper creeper) {
        return ((_SpecialCreeperEntity)creeper).isSupercharged() ? CHARGED[1] : CHARGED[0];
    }

    protected float m_7631_(float f) {
        return f * 0.01f;
    }

    protected ResourceLocation m_7029_() {
        return CHARGED[0];
    }

    protected EntityModel<Creeper> m_7193_() {
        return this.model;
    }
}

