/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.layers;

import fathertoast.specialmobs.common.core.SpecialMobs;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.Boat;

public class SMModelLayers {
    public static final ModelLayerLocation SCOPE_CREEPER = SMModelLayers.create("scope_creeper");
    public static final ModelLayerLocation SLAB_GHAST = SMModelLayers.create("slab_ghast");
    public static final ModelLayerLocation CREEPER_OUTER_LAYER = SMModelLayers.create("creeper", "outer");
    public static final ModelLayerLocation BLAZE_OUTER_LAYER = SMModelLayers.create("blaze", "outer");
    public static final ModelLayerLocation BLAZE_OUTER_ARMOR_LAYER = SMModelLayers.create("blaze", "outer_armor");
    public static final ModelLayerLocation ENDERMAN_OUTER_LAYER = SMModelLayers.create("enderman", "outer");
    public static final ModelLayerLocation GHAST_OUTER_LAYER = SMModelLayers.create("ghast", "outer");
    public static final ModelLayerLocation MAGMA_CUBE_OUTER_LAYER = SMModelLayers.create("magma_cube", "outer");
    public static final ModelLayerLocation SILVERFISH_OUTER_LAYER = SMModelLayers.create("silverfish", "outer");
    public static final ModelLayerLocation SLIME_OUTER_LAYER = SMModelLayers.create("slime", "outer");
    public static final ModelLayerLocation SPIDER_OUTER_LAYER = SMModelLayers.create("spider", "outer");
    public static final ModelLayerLocation PIGLIN = SMModelLayers.create("piglin");
    public static final ModelLayerLocation PIGLIN_OUTER_LAYER = SMModelLayers.create("piglin", "outer");
    public static final ModelLayerLocation PIGLIN_INNER_ARMOR = SMModelLayers.create("piglin", "inner_armor");
    public static final ModelLayerLocation PIGLIN_OUTER_ARMOR = SMModelLayers.create("piglin", "outer_armor");
    public static final ModelLayerLocation ZOMBIFIED_PIGLIN = SMModelLayers.create("zombified_piglin");
    public static final ModelLayerLocation ZOMBIFIED_PIGLIN_OUTER_LAYER = SMModelLayers.create("zombified_piglin", "outer");
    public static final ModelLayerLocation ZOMBIFIED_PIGLIN_INNER_ARMOR = SMModelLayers.create("zombified_piglin", "inner_armor");
    public static final ModelLayerLocation ZOMBIFIED_PIGLIN_OUTER_ARMOR = SMModelLayers.create("zombified_piglin", "outer_armor");

    private static ModelLayerLocation create(String path) {
        return SMModelLayers.create(path, "main");
    }

    private static ModelLayerLocation create(String path, String layerName) {
        return new ModelLayerLocation(SpecialMobs.resourceLoc(path), layerName);
    }

    public static LayerDefinition blazeBodyLayer(CubeDeformation cubeDeformation) {
        float z;
        float y;
        float x;
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.f_171404_);
        float f = 0.0f;
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        for (int i = 0; i < 4; ++i) {
            x = Mth.m_14089_((float)f) * 9.0f;
            y = -2.0f + Mth.m_14089_((float)((float)(i * 2) * 0.25f));
            z = Mth.m_14031_((float)f) * 9.0f;
            partDefinition.m_171599_("part" + i, cubelistbuilder, PartPose.m_171419_((float)x, (float)y, (float)z));
            f += 1.0f;
        }
        f = 0.7853982f;
        for (int j = 4; j < 8; ++j) {
            x = Mth.m_14089_((float)f) * 7.0f;
            y = 2.0f + Mth.m_14089_((float)((float)(j * 2) * 0.25f));
            z = Mth.m_14031_((float)f) * 7.0f;
            partDefinition.m_171599_("part" + j, cubelistbuilder, PartPose.m_171419_((float)x, (float)y, (float)z));
            f += 1.0f;
        }
        f = 0.47123894f;
        for (int k = 8; k < 12; ++k) {
            x = Mth.m_14089_((float)f) * 5.0f;
            y = 11.0f + Mth.m_14089_((float)((float)k * 1.5f * 0.5f));
            z = Mth.m_14031_((float)f) * 5.0f;
            partDefinition.m_171599_("part" + k, cubelistbuilder, PartPose.m_171419_((float)x, (float)y, (float)z));
            f += 1.0f;
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition endermanBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)cubeDeformation, (float)-14.0f);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartPose partpose = PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f);
        partDefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), partpose);
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), partpose);
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.0f));
        partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)-5.0f, (float)-12.0f, (float)0.0f));
        partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)5.0f, (float)-12.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)-2.0f, (float)-5.0f, (float)0.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f, cubeDeformation), PartPose.m_171419_((float)2.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition ghastBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)17.6f, (float)0.0f));
        RandomSource random = RandomSource.m_216335_((long)1660L);
        for (int i = 0; i < 9; ++i) {
            float xOffset = (((float)(i % 3) - (float)(i / 3 % 2) * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float zOffset = ((float)(i / 3) / 2.0f * 2.0f - 1.0f) * 5.0f;
            int tentacleLength = random.m_188503_(7) + 8;
            partDefinition.m_171599_("tentacle" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, (float)tentacleLength, 2.0f, cubeDeformation), PartPose.m_171419_((float)xOffset, (float)24.6f, (float)zOffset));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition magmaCubeBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        for (int i = 0; i < 8; ++i) {
            int j = 0;
            int k = i;
            if (i == 2) {
                j = 24;
                k = 10;
            } else if (i == 3) {
                j = 24;
                k = 19;
            }
            partDefinition.m_171599_("cube" + i, CubeListBuilder.m_171558_().m_171514_(j, k).m_171488_(-4.0f, (float)(16 + i), -4.0f, 8.0f, 1.0f, 8.0f, cubeDeformation), PartPose.f_171404_);
        }
        partDefinition.m_171599_("inside_cube", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 18.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDeformation), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition silverfishBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        int[][] BODY_SIZES = new int[][]{{3, 2, 2}, {4, 3, 2}, {6, 4, 3}, {3, 3, 3}, {2, 2, 3}, {2, 1, 2}, {1, 1, 2}};
        int[][] BODY_TEXS = new int[][]{{0, 0}, {0, 4}, {0, 9}, {0, 16}, {0, 22}, {11, 0}, {13, 4}};
        float[] zOffsets = new float[7];
        float f = -3.5f;
        for (int i = 0; i < 7; ++i) {
            partDefinition.m_171599_("segment" + i, CubeListBuilder.m_171558_().m_171514_(BODY_TEXS[i][0], BODY_TEXS[i][1]).m_171488_((float)BODY_SIZES[i][0] * -0.5f, 0.0f, (float)BODY_SIZES[i][2] * -0.5f, (float)BODY_SIZES[i][0], (float)BODY_SIZES[i][1], (float)BODY_SIZES[i][2], cubeDeformation), PartPose.m_171419_((float)0.0f, (float)(24 - BODY_SIZES[i][1]), (float)f));
            zOffsets[i] = f;
            if (i >= 6) continue;
            f += (float)(BODY_SIZES[i][2] + BODY_SIZES[i + 1][2]) * 0.5f;
        }
        partDefinition.m_171599_("layer0", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-5.0f, 0.0f, (float)BODY_SIZES[2][2] * -0.5f, 10.0f, 8.0f, (float)BODY_SIZES[2][2], cubeDeformation), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)zOffsets[2]));
        partDefinition.m_171599_("layer1", CubeListBuilder.m_171558_().m_171514_(20, 11).m_171488_(-3.0f, 0.0f, (float)BODY_SIZES[4][2] * -0.5f, 6.0f, 4.0f, (float)BODY_SIZES[4][2], cubeDeformation), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)zOffsets[4]));
        partDefinition.m_171599_("layer2", CubeListBuilder.m_171558_().m_171514_(20, 18).m_171488_(-3.0f, 0.0f, (float)BODY_SIZES[4][2] * -0.5f, 6.0f, 5.0f, (float)BODY_SIZES[1][2], cubeDeformation), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)zOffsets[1]));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition slimeOuterBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, 16.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition spiderBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 4).m_171488_(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-3.0f));
        partDefinition.m_171599_("body0", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        partDefinition.m_171599_("body1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-5.0f, -4.0f, -6.0f, 10.0f, 8.0f, 12.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)9.0f));
        CubeListBuilder rightPartsBuilder = CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, cubeDeformation);
        CubeListBuilder leftPartsBuilder = CubeListBuilder.m_171558_().m_171514_(18, 0).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, cubeDeformation);
        partDefinition.m_171599_("right_hind_leg", rightPartsBuilder, PartPose.m_171419_((float)-4.0f, (float)15.0f, (float)2.0f));
        partDefinition.m_171599_("left_hind_leg", leftPartsBuilder, PartPose.m_171419_((float)4.0f, (float)15.0f, (float)2.0f));
        partDefinition.m_171599_("right_middle_hind_leg", rightPartsBuilder, PartPose.m_171419_((float)-4.0f, (float)15.0f, (float)1.0f));
        partDefinition.m_171599_("left_middle_hind_leg", leftPartsBuilder, PartPose.m_171419_((float)4.0f, (float)15.0f, (float)1.0f));
        partDefinition.m_171599_("right_middle_front_leg", rightPartsBuilder, PartPose.m_171419_((float)-4.0f, (float)15.0f, (float)0.0f));
        partDefinition.m_171599_("left_middle_front_leg", leftPartsBuilder, PartPose.m_171419_((float)4.0f, (float)15.0f, (float)0.0f));
        partDefinition.m_171599_("right_front_leg", rightPartsBuilder, PartPose.m_171419_((float)-4.0f, (float)15.0f, (float)-1.0f));
        partDefinition.m_171599_("left_front_leg", leftPartsBuilder, PartPose.m_171419_((float)4.0f, (float)15.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static ModelLayerLocation createRaftModelName(Boat.Type type) {
        return SMModelLayers.createModLocation("raft/" + type.m_38429_(), "main");
    }

    public static ModelLayerLocation createChestRaftModelName(Boat.Type type) {
        return SMModelLayers.createModLocation("chest_raft/" + type.m_38429_(), "main");
    }

    public static ModelLayerLocation createBoatModelName(Boat.Type type) {
        return SMModelLayers.createModLocation("boat/" + type.m_38429_(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(Boat.Type type) {
        return SMModelLayers.createModLocation("chest_boat/" + type.m_38429_(), "main");
    }

    private static ModelLayerLocation createModLocation(String location, String name) {
        return new ModelLayerLocation(SpecialMobs.resourceLoc(location), name);
    }
}

