/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.family;

import com.mojang.blaze3d.vertex.PoseStack;
import fathertoast.specialmobs.client.renderer.entity.layers.SMModelLayers;
import fathertoast.specialmobs.client.renderer.entity.layers.SpecialMobEyesLayer;
import fathertoast.specialmobs.client.renderer.entity.layers.SpecialMobOverlayLayer;
import fathertoast.specialmobs.client.renderer.entity.model.SpecialPiglinModel;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;

public class SpecialPiglinRenderer
extends HumanoidMobRenderer<Mob, SpecialPiglinModel<Mob>> {
    private final float baseShadowRadius;

    public static SpecialPiglinRenderer newBothEars(EntityRendererProvider.Context context) {
        return new SpecialPiglinRenderer(context, false, false);
    }

    public static SpecialPiglinRenderer newMissingRightEar(EntityRendererProvider.Context context) {
        return new SpecialPiglinRenderer(context, true, true);
    }

    public SpecialPiglinRenderer(EntityRendererProvider.Context context, boolean missingRightEar, boolean isZombie) {
        super(context, SpecialPiglinRenderer.createModel(context, isZombie ? SMModelLayers.ZOMBIFIED_PIGLIN : SMModelLayers.PIGLIN, missingRightEar), 0.5f, 1.0019531f, 1.0f, 1.0019531f);
        this.baseShadowRadius = this.f_114477_;
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(isZombie ? SMModelLayers.ZOMBIFIED_PIGLIN_INNER_ARMOR : SMModelLayers.PIGLIN_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(isZombie ? SMModelLayers.ZOMBIFIED_PIGLIN_OUTER_ARMOR : SMModelLayers.PIGLIN_OUTER_ARMOR)), context.m_266367_()));
        this.m_115326_((RenderLayer)new SpecialMobEyesLayer(this));
        SpecialPiglinModel overlayModel = new SpecialPiglinModel(context.m_174023_(isZombie ? SMModelLayers.ZOMBIFIED_PIGLIN_OUTER_LAYER : SMModelLayers.PIGLIN_OUTER_LAYER));
        if (missingRightEar) {
            overlayModel.rightEar.f_104207_ = false;
        }
        this.m_115326_(new SpecialMobOverlayLayer(this, overlayModel));
    }

    public ResourceLocation getTextureLocation(Mob entity) {
        return ((ISpecialMob)entity).getSpecialData().getTexture();
    }

    protected void scale(Mob entity, PoseStack poseStack, float partialTick) {
        super.m_7546_((LivingEntity)entity, poseStack, partialTick);
        float scale = ((ISpecialMob)entity).getSpecialData().getRenderScale();
        this.f_114477_ = this.baseShadowRadius * scale;
        poseStack.m_85841_(scale, scale, scale);
    }

    private static SpecialPiglinModel<Mob> createModel(EntityRendererProvider.Context context, ModelLayerLocation layerLocation, boolean missingRightEar) {
        SpecialPiglinModel<Mob> model = new SpecialPiglinModel<Mob>(context.m_174023_(layerLocation));
        if (missingRightEar) {
            model.rightEar.f_104207_ = false;
        }
        return model;
    }

    protected boolean isShaking(Mob mob) {
        return super.m_5936_((LivingEntity)mob) || mob instanceof AbstractPiglin && ((AbstractPiglin)mob).m_34666_();
    }
}

