/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client;

import fathertoast.crust.api.config.client.ClientConfigUtil;
import fathertoast.specialmobs.client.FishingRodItemPropertyGetter;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialBlazeRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialCreeperRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialDrownedRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialEndermanRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialGhastRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialMagmaCubeRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialPiglinRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSilverfishRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSkeletonRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSlimeRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSpiderRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialWitchRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialZombieRenderer;
import fathertoast.specialmobs.client.renderer.entity.layers.SMModelLayers;
import fathertoast.specialmobs.client.renderer.entity.misc.MobBoatRenderer;
import fathertoast.specialmobs.client.renderer.entity.model.MobBoatModel;
import fathertoast.specialmobs.client.renderer.entity.model.MobRaftModel;
import fathertoast.specialmobs.client.renderer.entity.model.ScopeCreeperModel;
import fathertoast.specialmobs.client.renderer.entity.model.SlabGhastModel;
import fathertoast.specialmobs.client.renderer.entity.projectile.BoneShrapnelRenderer;
import fathertoast.specialmobs.client.renderer.entity.projectile.BugSpitRenderer;
import fathertoast.specialmobs.client.renderer.entity.projectile.SpecialFishingBobberRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.ArmoredBlazeRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.CorporealShiftGhastRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.EnderCreeperRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.NinjaSkeletonRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.PotionSlimeRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.RunicEndermanRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.ScopeCreeperRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.ShortSilverfishRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.SlabGhastRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.SpecialZombieVillagerRenderer;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.blaze.ArmoredBlazeEntity;
import fathertoast.specialmobs.common.entity.creeper.EnderCreeperEntity;
import fathertoast.specialmobs.common.entity.creeper.ScopeCreeperEntity;
import fathertoast.specialmobs.common.entity.enderman.RunicEndermanEntity;
import fathertoast.specialmobs.common.entity.ghast.CorporealShiftGhastEntity;
import fathertoast.specialmobs.common.entity.ghast.SlabGhastEntity;
import fathertoast.specialmobs.common.entity.silverfish.PufferSilverfishEntity;
import fathertoast.specialmobs.common.entity.skeleton.NinjaSkeletonEntity;
import fathertoast.specialmobs.common.entity.slime.PotionSlimeEntity;
import fathertoast.specialmobs.common.entity.witherskeleton.NinjaWitherSkeletonEntity;
import fathertoast.specialmobs.common.entity.zombie.MadScientistZombieEntity;
import fathertoast.specialmobs.common.entity.zombifiedpiglin.VampireZombifiedPiglinEntity;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="specialmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegister {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        if (Config.MAIN.GENERAL.fancyFishingMobs.get()) {
            event.enqueueWork(() -> ItemProperties.register((Item)Items.f_42523_, (ResourceLocation)new ResourceLocation("cast"), (ItemPropertyFunction)new FishingRodItemPropertyGetter()));
        }
        ClientConfigUtil.registerConfigButtonAsEditScreen();
    }

    @SubscribeEvent
    public static void registerLayerDefs(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SMModelLayers.SCOPE_CREEPER, ScopeCreeperModel::createBodyLayer);
        event.registerLayerDefinition(SMModelLayers.SLAB_GHAST, SlabGhastModel::createBodyLayer);
        event.registerLayerDefinition(SMModelLayers.CREEPER_OUTER_LAYER, () -> CreeperModel.m_170525_((CubeDeformation)new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.BLAZE_OUTER_LAYER, () -> SMModelLayers.blazeBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.BLAZE_OUTER_ARMOR_LAYER, () -> SMModelLayers.blazeBodyLayer(new CubeDeformation(1.0f)));
        event.registerLayerDefinition(SMModelLayers.ENDERMAN_OUTER_LAYER, () -> SMModelLayers.endermanBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.GHAST_OUTER_LAYER, () -> SMModelLayers.ghastBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.MAGMA_CUBE_OUTER_LAYER, () -> SMModelLayers.magmaCubeBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.SILVERFISH_OUTER_LAYER, () -> SMModelLayers.silverfishBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.SLIME_OUTER_LAYER, () -> SMModelLayers.slimeOuterBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.SPIDER_OUTER_LAYER, () -> SMModelLayers.spiderBodyLayer(new CubeDeformation(0.25f)));
        event.registerLayerDefinition(SMModelLayers.PIGLIN, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinModel.m_170811_((CubeDeformation)CubeDeformation.f_171458_), (int)64, (int)64));
        event.registerLayerDefinition(SMModelLayers.PIGLIN_OUTER_LAYER, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinModel.m_170811_((CubeDeformation)new CubeDeformation(0.25f)), (int)64, (int)64));
        event.registerLayerDefinition(SMModelLayers.PIGLIN_INNER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(0.5f)), (int)64, (int)32));
        event.registerLayerDefinition(SMModelLayers.PIGLIN_OUTER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(1.02f)), (int)64, (int)32));
        event.registerLayerDefinition(SMModelLayers.ZOMBIFIED_PIGLIN, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinModel.m_170811_((CubeDeformation)CubeDeformation.f_171458_), (int)64, (int)64));
        event.registerLayerDefinition(SMModelLayers.ZOMBIFIED_PIGLIN_OUTER_LAYER, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinModel.m_170811_((CubeDeformation)new CubeDeformation(0.25f)), (int)64, (int)64));
        event.registerLayerDefinition(SMModelLayers.ZOMBIFIED_PIGLIN_INNER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(0.5f)), (int)64, (int)32));
        event.registerLayerDefinition(SMModelLayers.ZOMBIFIED_PIGLIN_OUTER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidArmorModel.m_269566_((CubeDeformation)new CubeDeformation(1.02f)), (int)64, (int)32));
        for (Boat.Type type : Boat.Type.values()) {
            if (type == Boat.Type.BAMBOO) {
                event.registerLayerDefinition(SMModelLayers.createBoatModelName(type), MobRaftModel::createBodyModel);
                continue;
            }
            event.registerLayerDefinition(SMModelLayers.createBoatModelName(type), MobBoatModel::createBodyModel);
        }
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientRegister.registerFamilyRenderers(event, MobFamily.CREEPER, SpecialCreeperRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.ZOMBIE, SpecialZombieRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.DROWNED, SpecialDrownedRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.ZOMBIFIED_PIGLIN, SpecialPiglinRenderer::newMissingRightEar);
        ClientRegister.registerFamilyRenderers(event, MobFamily.SKELETON, context -> new SpecialSkeletonRenderer(context, ModelLayers.f_171238_));
        ClientRegister.registerFamilyRenderers(event, MobFamily.WITHER_SKELETON, context -> new SpecialSkeletonRenderer(context, ModelLayers.f_171217_));
        ClientRegister.registerFamilyRenderers(event, MobFamily.SLIME, SpecialSlimeRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.MAGMA_CUBE, SpecialMagmaCubeRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.SPIDER, SpecialSpiderRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.CAVE_SPIDER, SpecialSpiderRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.SILVERFISH, SpecialSilverfishRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.ENDERMAN, SpecialEndermanRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.WITCH, SpecialWitchRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.GHAST, SpecialGhastRenderer::new);
        ClientRegister.registerFamilyRenderers(event, MobFamily.BLAZE, SpecialBlazeRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, ArmoredBlazeEntity.SPECIES, ArmoredBlazeRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, EnderCreeperEntity.SPECIES, EnderCreeperRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, ScopeCreeperEntity.SPECIES, ScopeCreeperRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, MadScientistZombieEntity.SPECIES, SpecialZombieVillagerRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, VampireZombifiedPiglinEntity.SPECIES, SpecialPiglinRenderer::newBothEars);
        ClientRegister.registerSpeciesRenderer(event, NinjaSkeletonEntity.SPECIES, context -> new NinjaSkeletonRenderer(context, ModelLayers.f_171238_));
        ClientRegister.registerSpeciesRenderer(event, NinjaWitherSkeletonEntity.SPECIES, context -> new NinjaSkeletonRenderer(context, ModelLayers.f_171217_));
        ClientRegister.registerSpeciesRenderer(event, PotionSlimeEntity.SPECIES, PotionSlimeRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, PufferSilverfishEntity.SPECIES, ShortSilverfishRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, CorporealShiftGhastEntity.SPECIES, CorporealShiftGhastRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, SlabGhastEntity.SPECIES, SlabGhastRenderer::new);
        ClientRegister.registerSpeciesRenderer(event, RunicEndermanEntity.SPECIES, RunicEndermanRenderer::new);
        ClientRegister.registerRenderer(event, SMEntities.BONE_SHRAPNEL, BoneShrapnelRenderer::new);
        ClientRegister.registerRenderer(event, SMEntities.BUG_SPIT, BugSpitRenderer::new);
        ClientRegister.registerSpriteRenderer(event, SMEntities.INCORPOREAL_FIREBALL, 3.0f, true);
        ClientRegister.registerSpriteRenderer(event, SMEntities.SLAB_FIREBALL, 3.0f, true);
        ClientRegister.registerRenderer(event, SMEntities.FISHING_BOBBER, SpecialFishingBobberRenderer::new);
        ClientRegister.registerRenderer(event, SMEntities.MOB_BOAT, MobBoatRenderer::new);
    }

    private static <T extends Mob, E extends LivingEntity> void registerFamilyRenderers(EntityRenderersEvent.RegisterRenderers event, MobFamily<T, ?> family, EntityRendererProvider<E> renderFactory) {
        event.registerEntityRenderer((EntityType)family.vanillaReplacement.entityType.get(), renderFactory);
        for (MobFamily.Species species : family.variants) {
            ClientRegister.registerSpeciesRenderer(event, species, renderFactory);
        }
    }

    private static <T extends Mob, E extends LivingEntity> void registerSpeciesRenderer(EntityRenderersEvent.RegisterRenderers event, MobFamily.Species<T> species, EntityRendererProvider<E> renderFactory) {
        ClientRegister.registerRenderer(event, species.entityType, renderFactory);
    }

    private static <T extends Entity> void registerRenderer(EntityRenderersEvent.RegisterRenderers event, RegistryObject<EntityType<T>> entityType, EntityRendererProvider<T> renderFactory) {
        event.registerEntityRenderer((EntityType)entityType.get(), renderFactory);
    }

    private static <T extends Entity> void registerSpriteRenderer(EntityRenderersEvent.RegisterRenderers event, RegistryObject<EntityType<T>> entityType, float scale, boolean fullBright) {
        event.registerEntityRenderer((EntityType)entityType.get(), context -> new ThrownItemRenderer(context, scale, fullBright));
    }
}

