/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.init;

import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import maxhyper.dtphc2.DynamicTreesPHC2;
import maxhyper.dtphc2.blocks.DragonFruitLeavesProperties;
import maxhyper.dtphc2.fruits.CobwebFruit;
import maxhyper.dtphc2.fruits.FallingFruit;
import maxhyper.dtphc2.fruits.FallingPalmPod;
import maxhyper.dtphc2.fruits.OffsetFruit;
import maxhyper.dtphc2.fruits.PalmPod;
import maxhyper.dtphc2.genfeatures.DTPHC2GenFeatures;
import maxhyper.dtphc2.init.DTPHC2Items;
import maxhyper.dtphc2.trees.FruitLogSpecies;
import maxhyper.dtphc2.trees.GenOnExtraSoilSpecies;
import maxhyper.dtphc2.trees.PaperbarkFamily;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTPHC2Registries {
    public static final TagKey<Block> CAN_BE_SPILED = BlockTags.create((ResourceLocation)DynamicTreesPHC2.location("can_be_spiled"));
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"dtphc2");
    public static final RegistryObject<SoundEvent> FRUIT_BONK = DTPHC2Registries.registerSound("falling_fruit.bonk");
    public static final VoxelShape DRAGON_FRUIT_CACTUS_SAPLING_SHAPE = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.5, (double)0.625);
    public static final VoxelShape BANANA_SAPLING_SHAPE = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.9375, (double)0.625);

    public static void setup() {
        CommonVoxelShapes.SHAPES.put(DynamicTreesPHC2.location("dragon_fruit_cactus").toString(), DRAGON_FRUIT_CACTUS_SAPLING_SHAPE);
        CommonVoxelShapes.SHAPES.put(DynamicTreesPHC2.location("banana_sapling").toString(), BANANA_SAPLING_SHAPE);
    }

    public static RegistryObject<SoundEvent> registerSound(String name) {
        return SOUNDS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)DynamicTreesPHC2.location(name)));
    }

    @SubscribeEvent
    public static void registerFruitType(TypeRegistryEvent<Fruit> event) {
        event.registerType(DynamicTreesPHC2.location("offset_down"), OffsetFruit.TYPE);
        event.registerType(DynamicTreesPHC2.location("falling_fruit"), FallingFruit.TYPE);
        event.registerType(DynamicTreesPHC2.location("cobweb"), CobwebFruit.TYPE);
    }

    @SubscribeEvent
    public static void registerPodType(TypeRegistryEvent<Pod> event) {
        event.registerType(DynamicTreesPHC2.location("palm"), PalmPod.TYPE);
        event.registerType(DynamicTreesPHC2.location("falling_palm"), FallingPalmPod.TYPE);
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesType(TypeRegistryEvent<LeavesProperties> event) {
        event.registerType(DynamicTreesPHC2.location("dragon_fruit"), DragonFruitLeavesProperties.TYPE);
    }

    @SubscribeEvent
    public static void registerFamilyType(TypeRegistryEvent<Family> event) {
        event.registerType(DynamicTreesPHC2.location("paperbark"), PaperbarkFamily.TYPE);
    }

    @SubscribeEvent
    public static void registerSpeciesType(TypeRegistryEvent<Species> event) {
        event.registerType(DynamicTreesPHC2.location("fruit_log"), FruitLogSpecies.TYPE);
        event.registerType(DynamicTreesPHC2.location("generates_on_extra_soil"), GenOnExtraSoilSpecies.TYPE);
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        DTPHC2GenFeatures.register((Registry<GenFeature>)event.getRegistry());
    }

    @SubscribeEvent
    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == DTRegistries.DT_CREATIVE_TAB.getKey()) {
            DTPHC2Items.acceptToDynamicTreesTab(event);
        }
    }
}

