/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import java.awt.Color;
import javax.annotation.Nonnull;
import maxhyper.dtphc2.genfeatures.DripSyrupNode;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SyrupGenFeature
extends GenFeature {
    private static final ConfigurationProperty<Float> BASE_SYRUP_CHANCE = ConfigurationProperty.floatProperty((String)"base_syrup_chance");
    private static final ConfigurationProperty<Float> OUT_OF_SEASON_SYRUP_CHANCE = ConfigurationProperty.floatProperty((String)"out_of_season_syrup_chance");
    private static final ConfigurationProperty<Float> SEASONAL_OFFSET = ConfigurationProperty.floatProperty((String)"seasonal_offset");
    private static final ConfigurationProperty<Float> SEASONAL_RANGE = ConfigurationProperty.floatProperty((String)"seasonal_range");
    private static final ConfigurationProperty<Item> SYRUP_ITEM = ConfigurationProperty.item((String)"syrup_item");
    private static final ConfigurationProperty<String> TINT = ConfigurationProperty.string((String)"tint");

    public SyrupGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BASE_SYRUP_CHANCE, OUT_OF_SEASON_SYRUP_CHANCE, SYRUP_ITEM, SEASONAL_OFFSET, SEASONAL_RANGE, TINT});
    }

    @Nonnull
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BASE_SYRUP_CHANCE, (Object)Float.valueOf(0.05f))).with(OUT_OF_SEASON_SYRUP_CHANCE, (Object)Float.valueOf(0.001f))).with(SYRUP_ITEM, (Object)Items.f_41852_)).with(SEASONAL_OFFSET, (Object)Float.valueOf(3.5f))).with(SEASONAL_RANGE, (Object)Float.valueOf(1.0f))).with(TINT, (Object)"#FF00FF");
    }

    public Item getSyrupItem(GenFeatureConfiguration config) {
        return (Item)config.get(SYRUP_ITEM);
    }

    public int getTint(GenFeatureConfiguration config) {
        return Color.decode((String)config.get(TINT)).getRGB();
    }

    public boolean postGrow(@Nonnull GenFeatureConfiguration configuration, @Nonnull PostGrowContext context) {
        LevelContext levelContext = context.levelContext();
        Level level = context.levelContext().level();
        boolean natural = context.natural();
        BlockPos rootPos = context.pos();
        if (natural && TreeHelper.getRadius((BlockGetter)level, (BlockPos)context.treePos()) >= 7 && (double)level.m_213780_().m_188501_() <= this.getSyrupChance(levelContext, rootPos, configuration)) {
            this.dripSyrup((LevelAccessor)level, rootPos);
        }
        return true;
    }

    public double getSyrupChance(LevelContext world, BlockPos pos, GenFeatureConfiguration config) {
        Float season = SeasonHelper.getSeasonValue((LevelContext)world, (BlockPos)pos);
        float offset = ((Float)config.get(SEASONAL_OFFSET)).floatValue();
        float range = ((Float)config.get(SEASONAL_RANGE)).floatValue();
        ConfigurationProperty<Float> chanceProp = season == null || SeasonHelper.isSeasonBetween((Float)season, (float)offset, (float)(offset + range)) ? BASE_SYRUP_CHANCE : OUT_OF_SEASON_SYRUP_CHANCE;
        float chance = ((Float)config.get(chanceProp)).floatValue();
        return Mth.m_14036_((float)chance, (float)0.0f, (float)1.0f);
    }

    private void dripSyrup(LevelAccessor world, BlockPos rootPos) {
        TreeHelper.startAnalysisFromRoot((LevelAccessor)world, (BlockPos)rootPos, (MapSignal)new MapSignal(new NodeInspector[]{new DripSyrupNode()}));
    }
}

