/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dtphc2.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class FruitVineBlock
extends VineBlock {
    public static final int maxAge = 4;
    private static final float baseFruitingChance = 0.002f;
    private static float fruitGrowChance = 0.2f;
    private static float fruitOverripenChance = 0.005f;
    private static final float vineSpreadUpChance = 0.005f;
    private static final float attemptSpread = 0.01f;
    public static final IntegerProperty ageProperty = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    private ItemStack fruitStack;
    private ItemStack overripeFruitStack;
    private int matureAge = 4;
    @Nullable
    private Float seasonOffset = Float.valueOf(0.0f);
    private float flowerHoldPeriodLength = 0.5f;
    private float minProductionFactor = 0.3f;
    private int maxFruitsAround = 2;

    public FruitVineBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60910_().m_60977_().m_60978_(0.2f).m_60918_(SoundType.f_56760_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(0)));
    }

    public void setAge(Level world, BlockPos pos, BlockState state, int age, boolean destroy) {
        state = (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(age));
        if (destroy) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        world.m_7731_(pos, state, 2);
    }

    public FruitVineBlock setMatureAge(int age) {
        if (age <= 4 && age > 0) {
            this.matureAge = age;
        }
        return this;
    }

    public FruitVineBlock setFruitGrowChance(float chance) {
        if (chance <= 1.0f && chance >= 0.0f) {
            fruitGrowChance = chance;
        }
        return this;
    }

    public void setMaxFruitsAround(int maxFruitsAround) {
        this.maxFruitsAround = maxFruitsAround;
    }

    public void setFlowerHoldPeriodLength(float flowerHoldPeriodLength) {
        this.flowerHoldPeriodLength = flowerHoldPeriodLength;
    }

    public void setMinProductionFactor(float minProductionFactor) {
        this.minProductionFactor = minProductionFactor;
    }

    public FruitVineBlock setFruitOverripenChance(float chance) {
        if (chance <= 1.0f && chance >= 0.0f) {
            fruitOverripenChance = chance;
        }
        return this;
    }

    public FruitVineBlock setFruitStack(ItemStack stack) {
        this.fruitStack = stack;
        return this;
    }

    public FruitVineBlock setOverripeFruitStack(ItemStack stack) {
        this.overripeFruitStack = stack;
        return this;
    }

    public FruitVineBlock setSeasonOffset(Float seasonOffset) {
        this.seasonOffset = seasonOffset;
        return this;
    }

    public Float getSeasonOffset() {
        return this.seasonOffset;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ageProperty});
    }

    public void doTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        Integer age = this.getAge(state);
        if (age == null) {
            return;
        }
        Float season = SeasonHelper.getSeasonValue((LevelContext)LevelContext.create((LevelAccessor)world), (BlockPos)pos);
        if (season != null) {
            if (this.isOutOfSeason(world, pos)) {
                this.outOfSeason(world, pos, state);
                return;
            }
            if (age == 1 && this.isInFlowerHoldPeriod(world, pos, season)) {
                return;
            }
        }
        if (age < 4) {
            this.tryGrow(state, world, pos, random, age, season);
        }
    }

    private void tryGrow(BlockState state, Level world, BlockPos pos, RandomSource random, int age, @Nullable Float season) {
        float chance = age == 0 ? this.getFruitingChance(world, pos) : (this.matureAge != 4 && age >= this.matureAge ? fruitOverripenChance : fruitGrowChance);
        boolean doGrow = random.m_188501_() < chance;
        boolean eventGrow = ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)doGrow);
        if (season != null ? doGrow || eventGrow : eventGrow) {
            int fruitFoundAround = 0;
            for (Direction dir : Direction.values()) {
                Integer sideAge = this.getAge(world.m_8055_(pos.m_121955_(dir.m_122436_())));
                if (sideAge == null || sideAge <= 0) continue;
                ++fruitFoundAround;
            }
            if (fruitFoundAround >= this.maxFruitsAround) {
                return;
            }
            this.setAge(world, pos, state, age + 1, false);
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public float seasonalFruitProductionFactor(LevelContext LevelContext2, BlockPos pos) {
        return this.seasonOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor((LevelContext)LevelContext2, (BlockPos)pos, (float)(-this.seasonOffset.floatValue()), (boolean)false) : 1.0f;
    }

    private boolean isOutOfSeason(Level world, BlockPos pos) {
        return this.seasonalFruitProductionFactor(LevelContext.create((LevelAccessor)world), pos) < this.minProductionFactor;
    }

    private void outOfSeason(Level world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(0)), 2);
    }

    public final boolean isInFlowerHoldPeriod(Level world, BlockPos rootPos, Float seasonValue) {
        if (this.seasonOffset == null) {
            return false;
        }
        Float peakSeasonValue = SeasonHelper.getSeasonManager().getPeakFruitProductionSeasonValue(LevelContext.create((LevelAccessor)world).level(), rootPos, this.seasonOffset.floatValue());
        if (peakSeasonValue == null || this.flowerHoldPeriodLength == 0.0f) {
            return false;
        }
        float min = peakSeasonValue.floatValue() - 1.5f;
        float max = min + this.flowerHoldPeriodLength;
        return SeasonHelper.isSeasonBetween((Float)seasonValue, (float)min, (float)max);
    }

    private float getFruitingChance(Level world, BlockPos pos) {
        if (this.seasonOffset == null) {
            return 0.002f;
        }
        float fruitFactor = SeasonHelper.globalSeasonalFruitProductionFactor((LevelContext)LevelContext.create((LevelAccessor)world), (BlockPos)pos, (float)this.seasonOffset.floatValue(), (boolean)true);
        return 0.002f * Math.max(fruitFactor + 0.25f, 1.0f);
    }

    public Integer getAge(BlockState state) {
        if (!state.m_61138_((Property)ageProperty)) {
            return null;
        }
        return (Integer)state.m_61143_((Property)ageProperty);
    }

    public int getMatureAge() {
        return this.matureAge;
    }

    @Nonnull
    private BlockState getStateFromAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(age));
    }

    @Nullable
    private ItemStack getFruit() {
        if (this.fruitStack == null) {
            return null;
        }
        return this.fruitStack.m_41777_();
    }

    @Nullable
    private ItemStack getOverripeFruit() {
        if (this.overripeFruitStack == null) {
            return null;
        }
        return this.overripeFruitStack.m_41777_();
    }

    private boolean spawnItemFruitIfRipe(Level world, BlockPos pos, BlockState state) {
        Integer age = this.getAge(state);
        if (!world.m_5776_() && age != null && age >= this.matureAge) {
            ItemStack fruit;
            ItemStack itemStack = fruit = age == this.matureAge ? this.getFruit() : this.getOverripeFruit();
            if (fruit == null) {
                return false;
            }
            world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), fruit));
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Integer age = this.getAge(state);
        if (age == null) {
            return InteractionResult.PASS;
        }
        if (age >= this.matureAge && this.spawnItemFruitIfRipe(world, pos, state)) {
            this.setAge(world, pos, state, 0, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_57887_(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = pPos.m_121945_(pDirection);
        if (FruitVineBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = (BooleanProperty)f_57838_.get(pDirection);
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pLevel, Direction pNeighborPos) {
        BlockState blockstate = pBlockReader.m_8055_(pLevel);
        return Block.m_49918_((VoxelShape)blockstate.m_60812_(pBlockReader, pLevel), (Direction)pNeighborPos.m_122424_()) || blockstate.m_204336_(BlockTags.f_13035_) || TreeHelper.isBranch((BlockState)blockstate);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.doTick(state, (Level)world, pos, random);
        if (world.f_46441_.m_188501_() < 0.01f && world.isAreaLoaded(pos, 4)) {
            Direction randDir = Direction.m_235672_((RandomSource)random);
            BlockPos upPos = pos.m_7494_();
            if (randDir.m_122434_().m_122479_() && !((Boolean)state.m_61143_((Property)FruitVineBlock.m_57883_((Direction)randDir))).booleanValue()) {
                if (this.m_57850_((BlockGetter)world, pos)) {
                    BlockPos offsetPos = pos.m_121945_(randDir);
                    BlockState offsetState = world.m_8055_(offsetPos);
                    if (offsetState.m_60795_()) {
                        Direction rightDir = randDir.m_122427_();
                        Direction leftDir = randDir.m_122428_();
                        boolean hasFaceRight = (Boolean)state.m_61143_((Property)FruitVineBlock.m_57883_((Direction)rightDir));
                        boolean hasFaceLeft = (Boolean)state.m_61143_((Property)FruitVineBlock.m_57883_((Direction)leftDir));
                        BlockPos rightPos = offsetPos.m_121945_(rightDir);
                        BlockPos leftPos = offsetPos.m_121945_(leftDir);
                        if (hasFaceRight && FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, rightPos, rightDir)) {
                            world.m_7731_(offsetPos, (BlockState)this.m_49966_().m_61124_((Property)FruitVineBlock.m_57883_((Direction)rightDir), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (hasFaceLeft && FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, leftPos, leftDir)) {
                            world.m_7731_(offsetPos, (BlockState)this.m_49966_().m_61124_((Property)FruitVineBlock.m_57883_((Direction)leftDir), (Comparable)Boolean.valueOf(true)), 2);
                        } else {
                            Direction oppositeDir = randDir.m_122424_();
                            if (hasFaceRight && world.m_46859_(rightPos) && FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, pos.m_121945_(rightDir), oppositeDir)) {
                                world.m_7731_(rightPos, (BlockState)this.m_49966_().m_61124_((Property)FruitVineBlock.m_57883_((Direction)oppositeDir), (Comparable)Boolean.valueOf(true)), 2);
                            } else if (hasFaceLeft && world.m_46859_(leftPos) && FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, pos.m_121945_(leftDir), oppositeDir)) {
                                world.m_7731_(leftPos, (BlockState)this.m_49966_().m_61124_((Property)FruitVineBlock.m_57883_((Direction)oppositeDir), (Comparable)Boolean.valueOf(true)), 2);
                            } else if (world.f_46441_.m_188501_() < 0.005f && FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, offsetPos.m_7494_(), Direction.UP)) {
                                world.m_7731_(offsetPos, (BlockState)this.m_49966_().m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    } else if (FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, offsetPos, randDir)) {
                        world.m_7731_(pos, (BlockState)state.m_61124_((Property)FruitVineBlock.m_57883_((Direction)randDir), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else {
                BlockState blockstate2;
                BlockState blockstate1;
                BlockPos blockpos1;
                BlockState blockstate;
                boolean isAir;
                if (randDir == Direction.UP && pos.m_123342_() < 255) {
                    if (this.m_57887_((BlockGetter)world, pos, randDir)) {
                        world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                    if (world.m_46859_(upPos)) {
                        if (!this.m_57850_((BlockGetter)world, pos)) {
                            return;
                        }
                        BlockState blockstate3 = state;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!random.m_188499_() && FruitVineBlock.isAcceptableNeighbour((BlockGetter)world, upPos.m_121945_(direction2), Direction.UP)) continue;
                            blockstate3 = (BlockState)blockstate3.m_61124_((Property)FruitVineBlock.m_57883_((Direction)direction2), (Comparable)Boolean.valueOf(false));
                        }
                        if (this.m_57911_(blockstate3)) {
                            world.m_7731_(upPos, blockstate3, 2);
                        }
                        return;
                    }
                }
                if (pos.m_123342_() > 0 && ((isAir = (blockstate = world.m_8055_(blockpos1 = pos.m_7495_())).m_60795_()) || blockstate.m_60713_((Block)this)) && (blockstate1 = isAir ? this.m_49966_() : blockstate) != (blockstate2 = this.copyRandomFaces(state, blockstate1, random)) && this.m_57911_(blockstate2)) {
                    world.m_7731_(blockpos1, blockstate2, 2);
                }
            }
        }
    }

    private BlockState copyRandomFaces(BlockState from, BlockState to, RandomSource random) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!random.m_188499_() || !((Boolean)from.m_61143_((Property)(booleanproperty = FruitVineBlock.m_57883_((Direction)direction)))).booleanValue()) continue;
            to = (BlockState)to.m_61124_((Property)booleanproperty, (Comparable)Boolean.TRUE);
        }
        return to;
    }
}

