/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanStatic;

public class TerminalCraftingPlanFlatStatic<I>
implements ITerminalCraftingPlanFlat<I> {
    private final I id;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private final List<Entry> entries;
    private TerminalCraftingJobStatus status;
    private TerminalCraftingPlanStatic.Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanFlatStatic(I id, List<Entry> entries, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, TerminalCraftingPlanStatic.Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.entries = entries;
        this.outputs = outputs;
        this.status = status;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    public TerminalCraftingPlanStatic.Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.getUnlocalizedLabelOverride() == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    public static <I> CompoundTag serialize(TerminalCraftingPlanFlatStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("id", handler.serializeCraftingJobId(plan.getId()));
        ListTag entries = new ListTag();
        for (Entry entry : plan.getEntries()) {
            entries.add((Object)Entry.serialize(entry));
        }
        tag.m_128365_("entries", (Tag)entries);
        ListTag outputs = new ListTag();
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            outputs.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)output)));
        }
        tag.m_128365_("outputs", (Tag)outputs);
        tag.m_128405_("status", plan.getStatus().ordinal());
        tag.m_128405_("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            tag.m_128359_("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        tag.m_128356_("tickDuration", plan.getTickDuration());
        tag.m_128405_("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.m_128359_("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanFlatStatic<I> deserialize(CompoundTag tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.m_128441_("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.m_128425_("entries", 9)) {
            throw new IllegalArgumentException("Could not find a entries entry in the given tag");
        }
        if (!tag.m_128425_("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.m_128425_("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.m_128425_("label", 3)) {
            throw new IllegalArgumentException("Could not find a label entry in the given tag");
        }
        if (!tag.m_128425_("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.m_128425_("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.m_128423_("id"));
        ListTag entriesTag = tag.m_128437_("entries", 10);
        ArrayList entries = Lists.newArrayListWithExpectedSize((int)entriesTag.size());
        for (Tag nbtBase : entriesTag) {
            entries.add(Entry.deserialize((CompoundTag)nbtBase));
        }
        ListTag outputsTag = tag.m_128437_("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.size());
        for (Tag nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.m_128451_("status")];
        TerminalCraftingPlanStatic.Label label = TerminalCraftingPlanStatic.Label.values()[tag.m_128451_("label")];
        String unlocalizedLabelOverride = null;
        if (tag.m_128441_("unlocalizedLabelOverride")) {
            unlocalizedLabelOverride = tag.m_128461_("unlocalizedLabelOverride");
        }
        long tickDuration = tag.m_128454_("tickDuration");
        int channel = tag.m_128451_("channel");
        String initiatorName = null;
        if (tag.m_128425_("initiatorName", 8)) {
            initiatorName = tag.m_128461_("initiatorName");
        }
        TerminalCraftingPlanFlatStatic<I> plan = new TerminalCraftingPlanFlatStatic<I>(id, entries, outputs, status, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static class Entry
    implements ITerminalCraftingPlanFlat.IEntry {
        private final IPrototypedIngredient<?, ?> instance;
        private long quantityToCraft;
        private long quantityCrafting;
        private long quantityInStorage;
        private long quantityMissing;

        public Entry(IPrototypedIngredient<?, ?> instance, long quantityToCraft, long quantityCrafting, long quantityInStorage, long quantityMissing) {
            this.instance = instance;
            this.quantityToCraft = quantityToCraft;
            this.quantityCrafting = quantityCrafting;
            this.quantityInStorage = quantityInStorage;
            this.quantityMissing = quantityMissing;
        }

        public Entry(IPrototypedIngredient<?, ?> instance) {
            this(instance, 0L, 0L, 0L, 0L);
        }

        @Override
        public IPrototypedIngredient<?, ?> getInstance() {
            return this.instance;
        }

        @Override
        public long getQuantityToCraft() {
            return this.quantityToCraft;
        }

        public void setQuantityToCraft(long quantityToCraft) {
            this.quantityToCraft = quantityToCraft;
        }

        @Override
        public long getQuantityCrafting() {
            return this.quantityCrafting;
        }

        public void setQuantityCrafting(long quantityCrafting) {
            this.quantityCrafting = quantityCrafting;
        }

        @Override
        public long getQuantityInStorage() {
            return this.quantityInStorage;
        }

        public void setQuantityInStorage(long quantityInStorage) {
            this.quantityInStorage = quantityInStorage;
        }

        @Override
        public long getQuantityMissing() {
            return this.quantityMissing;
        }

        public void setQuantityMissing(long quantityMissing) {
            this.quantityMissing = quantityMissing;
        }

        public static CompoundTag serialize(Entry entry) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("instance", (Tag)IPrototypedIngredient.serialize(entry.getInstance()));
            tag.m_128356_("quantityToCraft", entry.getQuantityToCraft());
            tag.m_128356_("quantityCrafting", entry.getQuantityCrafting());
            tag.m_128356_("quantityInStorage", entry.getQuantityInStorage());
            tag.m_128356_("quantityMissing", entry.getQuantityMissing());
            return tag;
        }

        public static Entry deserialize(CompoundTag tag) {
            if (!tag.m_128425_("instance", 10)) {
                throw new IllegalArgumentException("Could not find a instance entry in the given tag");
            }
            if (!tag.m_128425_("quantityToCraft", 4)) {
                throw new IllegalArgumentException("Could not find a quantityToCraft entry in the given tag");
            }
            if (!tag.m_128425_("quantityCrafting", 4)) {
                throw new IllegalArgumentException("Could not find a quantityCrafting entry in the given tag");
            }
            if (!tag.m_128425_("quantityInStorage", 4)) {
                throw new IllegalArgumentException("Could not find a quantityInStorage entry in the given tag");
            }
            if (!tag.m_128425_("quantityMissing", 4)) {
                throw new IllegalArgumentException("Could not find a quantityMissing entry in the given tag");
            }
            PrototypedIngredient instance = IPrototypedIngredient.deserialize((CompoundTag)tag.m_128469_("instance"));
            long quantityToCraft = tag.m_128454_("quantityToCraft");
            long quantityCrafting = tag.m_128454_("quantityCrafting");
            long quantityInStorage = tag.m_128454_("quantityInStorage");
            long quantityMissing = tag.m_128454_("quantityMissing");
            return new Entry((IPrototypedIngredient<?, ?>)instance, quantityToCraft, quantityCrafting, quantityInStorage, quantityMissing);
        }
    }
}

