/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.entity.ai.goal.AttemptToGoHomeGoal;
import twilightforest.world.registration.TFGenerationSettings;

public interface EnforcedHomePoint {
    default public <T extends PathfinderMob> void addRestrictionGoals(T entity, GoalSelector selector) {
        selector.m_25352_(5, new AttemptToGoHomeGoal<T>(entity, 1.25));
    }

    default public void saveHomePointToNbt(CompoundTag tag) {
        if (this.getRestrictionPoint() != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getRestrictionPoint()).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).ifPresent(tag1 -> tag.m_128365_("HomePos", tag1));
        }
    }

    default public void loadHomePointFromNbt(CompoundTag tag) {
        if (tag.m_128425_("Home", 9)) {
            ListTag nbttaglist = tag.m_128437_("Home", 6);
            double hx = nbttaglist.m_128772_(0);
            double hy = nbttaglist.m_128772_(1);
            double hz = nbttaglist.m_128772_(2);
            this.setRestrictionPoint(GlobalPos.m_122643_(TFGenerationSettings.DIMENSION_KEY, (BlockPos)BlockPos.m_274561_((double)hx, (double)hy, (double)hz)));
        } else if (tag.m_128441_("HomePos")) {
            this.setRestrictionPoint(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("HomePos")).resultOrPartial(arg_0 -> ((Logger)TwilightForestMod.LOGGER).error(arg_0)).orElse(null));
        }
    }

    default public boolean isMobWithinHomeArea(Entity entity) {
        if (!this.isRestrictionPointValid((ResourceKey<Level>)entity.m_9236_().m_46472_())) {
            return true;
        }
        return this.getRestrictionPoint().m_122646_().m_123331_((Vec3i)entity.m_20183_()) < (double)(this.getHomeRadius() * this.getHomeRadius());
    }

    default public boolean isRestrictionPointValid(ResourceKey<Level> currentMobLevel) {
        return this.getRestrictionPoint() != null && this.getRestrictionPoint().m_122640_().equals(currentMobLevel);
    }

    @Nullable
    public GlobalPos getRestrictionPoint();

    public void setRestrictionPoint(@Nullable GlobalPos var1);

    public int getHomeRadius();
}

