/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.button.SwitchButton;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.device.TileFluxDevice;
import sonar.fluxnetworks.register.ClientMessages;

public class GuiFluxDeviceHome
extends GuiTabCore {
    public FluxEditBox mCustomName;
    public FluxEditBox mPriority;
    public FluxEditBox mLimit;
    public SwitchButton mSurgeMode;
    public SwitchButton mDisableLimit;
    public SwitchButton mChunkLoading;

    public GuiFluxDeviceHome(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    @Override
    public EnumNavigationTab getNavigationTab() {
        return EnumNavigationTab.TAB_HOME;
    }

    public TileFluxDevice getDevice() {
        return (TileFluxDevice)((FluxMenu)this.f_97732_).mProvider;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int color = this.getNetwork().getNetworkColor() | 0xFF000000;
        this.mCustomName = FluxEditBox.create(FluxTranslate.NAME.get() + ": ", this.f_96547_, this.f_97735_ + 16, this.f_97736_ + 28, 144, 12).setOutlineColor(color);
        this.mCustomName.m_94199_(24);
        this.mCustomName.m_94144_(this.getDevice().getCustomName());
        this.mCustomName.m_94151_(string -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("customName", this.mCustomName.m_94155_());
            ClientMessages.editTile(this.getToken(), this.getDevice(), tag);
        });
        this.m_142416_((GuiEventListener)this.mCustomName);
        this.mPriority = FluxEditBox.create(FluxTranslate.PRIORITY.get() + ": ", this.f_96547_, this.f_97735_ + 16, this.f_97736_ + 45, 144, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.mPriority.m_94199_(5);
        this.mPriority.m_94144_(String.valueOf(this.getDevice().getRawPriority()));
        this.mPriority.m_94151_(string -> {
            int priority = Mth.m_14045_((int)this.mPriority.getValidInt(), (int)-9999, (int)9999);
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("priority", priority);
            ClientMessages.editTile(this.getToken(), this.getDevice(), tag);
        });
        this.m_142416_((GuiEventListener)this.mPriority);
        this.mLimit = FluxEditBox.create(FluxTranslate.TRANSFER_LIMIT.get() + ": ", this.f_96547_, this.f_97735_ + 16, this.f_97736_ + 62, 144, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
        this.mLimit.m_94199_(15);
        this.mLimit.m_94144_(String.valueOf(this.getDevice().getRawLimit()));
        this.mLimit.m_94151_(string -> {
            long limit = this.mLimit.getValidLong();
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("limit", limit);
            ClientMessages.editTile(this.getToken(), this.getDevice(), tag);
        });
        this.m_142416_((GuiEventListener)this.mLimit);
        this.mSurgeMode = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 120, this.getDevice().getSurgeMode(), color);
        this.mDisableLimit = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 132, this.getDevice().getDisableLimit(), color);
        this.mButtons.add(this.mSurgeMode);
        this.mButtons.add(this.mDisableLimit);
        if (!this.getDevice().getDeviceType().isStorage()) {
            this.mChunkLoading = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 144, this.getDevice().isForcedLoading(), color);
            this.mChunkLoading.setClickable(FluxConfig.enableChunkLoading);
            this.mButtons.add(this.mChunkLoading);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        int color = this.getNetwork().getNetworkColor();
        this.renderNetwork(gr, this.getNetwork().getNetworkName(), color, this.f_97736_ + 8);
        this.renderTransfer(gr, this.getDevice(), this.f_97735_ + 30, this.f_97736_ + 90);
        if (this.mCustomName.m_94155_().isEmpty()) {
            int y = this.mCustomName.m_252907_() + (this.mCustomName.m_93694_() - 8) / 2;
            gr.m_280488_(this.f_96547_, Language.m_128107_().m_6834_(this.getDevice().m_58900_().m_60734_().m_7705_()), this.mCustomName.m_252754_() + 4, y, 0xB2B2B2);
        }
        gr.m_280488_(this.f_96547_, FluxTranslate.SURGE_MODE.get(), 20 + this.f_97735_, 120 + this.f_97736_, color);
        gr.m_280488_(this.f_96547_, FluxTranslate.DISABLE_LIMIT.get(), 20 + this.f_97735_, 132 + this.f_97736_, color);
        if (this.mChunkLoading != null) {
            gr.m_280488_(this.f_96547_, FluxTranslate.CHUNK_LOADING.get(), 20 + this.f_97735_, 144 + this.f_97736_, color);
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, float mouseX, float mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && button instanceof SwitchButton) {
            SwitchButton switchButton = (SwitchButton)button;
            if (switchButton == this.mSurgeMode) {
                switchButton.toggle();
                CompoundTag tag = new CompoundTag();
                tag.m_128379_("surgeMode", this.mSurgeMode.isChecked());
                ClientMessages.editTile(this.getToken(), this.getDevice(), tag);
            } else if (switchButton == this.mDisableLimit) {
                switchButton.toggle();
                CompoundTag tag = new CompoundTag();
                tag.m_128379_("disableLimit", this.mDisableLimit.isChecked());
                ClientMessages.editTile(this.getToken(), this.getDevice(), tag);
            } else if (switchButton == this.mChunkLoading) {
                CompoundTag tag = new CompoundTag();
                tag.m_128379_("forcedLoading", !this.mChunkLoading.isChecked());
                ClientMessages.editTile(this.getToken(), this.getDevice(), tag);
            }
        }
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.mCustomName != null) {
            int color = this.getNetwork().getNetworkColor() | 0xFF000000;
            this.mCustomName.setOutlineColor(color);
            this.mPriority.setOutlineColor(color);
            this.mLimit.setOutlineColor(color);
            this.mSurgeMode.setColor(color);
            this.mDisableLimit.setColor(color);
            if (this.mChunkLoading != null) {
                this.mChunkLoading.setColor(color);
                this.mChunkLoading.setChecked(this.getDevice().isForcedLoading());
            }
        }
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && mouseX >= (double)(this.f_97735_ + 20) && mouseX < (double)(this.f_97735_ + 155) && mouseY >= (double)(this.f_97736_ + 8) && mouseY < (double)(this.f_97736_ + 20)) {
            this.switchTab(EnumNavigationTab.TAB_SELECTION, false);
            return true;
        }
        return false;
    }
}

