/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.VoxelBresenhamIterator;

public class UndergroundRootsGenFeature
extends GenFeature {
    public UndergroundRootsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(FRUITING_RADIUS, (Object)6);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{FRUITING_RADIUS});
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return super.shouldApply(species, configuration);
    }

    protected boolean postGenerate(@Nonnull GenFeatureConfiguration configuration, PostGenerationContext context) {
        this.placeRootsFeature(context.level(), context.pos().m_7495_());
        return true;
    }

    protected boolean postGrow(@Nonnull GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0 || TreeHelper.getRadius((BlockGetter)context.level(), (BlockPos)context.treePos()) < (Integer)configuration.get(FRUITING_RADIUS)) {
            return false;
        }
        this.placeRootsFeature(context.level(), context.pos().m_7495_());
        return true;
    }

    public boolean placeRootsFeature(LevelAccessor world, BlockPos pos) {
        if (world.m_5776_()) {
            return false;
        }
        RandomSource rand = world.m_213780_();
        float length = rand.m_188501_() * 6.0f + rand.m_188501_() * 6.0f + 4.0f;
        if (length > (float)pos.m_123342_()) {
            length = pos.m_123342_();
        }
        float tilt = 0.6f + rand.m_188501_() * 0.3f;
        return this.drawRoot(world, rand, pos, pos, length, rand.m_188501_(), tilt, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TFBlocks.ROOT_BLOCK.get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TFBlocks.LIVEROOT_BLOCK.get())));
    }

    private boolean drawRoot(LevelAccessor world, RandomSource rand, BlockPos oPos, BlockPos pos, float length, float angle, float tilt, BlockStateProvider rootBlock, BlockStateProvider oreBlock) {
        BlockPos ballSrc;
        BlockPos dest = FeatureLogic.translate((BlockPos)pos, (double)length, (double)angle, (double)tilt);
        int limit = 6;
        if (oPos.m_123341_() + limit < dest.m_123341_()) {
            dest = new BlockPos(oPos.m_123341_() + limit, dest.m_123342_(), dest.m_123343_());
        }
        if (oPos.m_123341_() - limit > dest.m_123341_()) {
            dest = new BlockPos(oPos.m_123341_() - limit, dest.m_123342_(), dest.m_123343_());
        }
        if (oPos.m_123343_() + limit < dest.m_123343_()) {
            dest = new BlockPos(dest.m_123341_(), dest.m_123342_(), oPos.m_123343_() + limit);
        }
        if (oPos.m_123343_() - limit > dest.m_123343_()) {
            dest = new BlockPos(dest.m_123341_(), dest.m_123342_(), oPos.m_123343_() - limit);
        }
        if (world.m_8055_(dest).m_60734_() != Blocks.f_50069_) {
            return false;
        }
        FeaturePlacers.traceRoot((LevelSimulatedReader)world, (checkedPos, rootPlacement) -> world.m_7731_(checkedPos, rootPlacement, 3), (RandomSource)rand, (BlockStateProvider)rootBlock, (Iterable)new VoxelBresenhamIterator(pos, dest));
        if (length > 8.0f && rand.m_188503_(3) > 0) {
            ballSrc = FeatureLogic.translate((BlockPos)pos, (double)(length / 2.0f), (double)angle, (double)tilt);
            float nextAngle = (angle + 0.25f + rand.m_188501_() * 0.5f) % 1.0f;
            float nextTilt = 0.6f + rand.m_188501_() * 0.3f;
            this.drawRoot(world, rand, oPos, ballSrc, length / 2.0f, nextAngle, nextTilt, rootBlock, oreBlock);
        }
        if (length > 6.0f && rand.m_188503_(4) == 0) {
            ballSrc = FeatureLogic.translate((BlockPos)pos, (double)(length / 2.0f), (double)angle, (double)tilt);
            BlockPos ballDest = FeatureLogic.translate((BlockPos)ballSrc, (double)1.5, (double)((angle + 0.5f) % 1.0f), (double)0.75);
            this.placeRootBlock(world, ballSrc, oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballSrc.m_123342_(), ballDest.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballDest.m_123341_(), ballSrc.m_123342_(), ballSrc.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballSrc.m_123342_(), ballDest.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballDest.m_123342_(), ballSrc.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballSrc.m_123341_(), ballDest.m_123342_(), ballDest.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, new BlockPos(ballDest.m_123341_(), ballDest.m_123342_(), ballSrc.m_123343_()), oreBlock, rand);
            this.placeRootBlock(world, ballDest, oreBlock, rand);
        }
        return true;
    }

    protected boolean placeRootBlock(LevelAccessor world, BlockPos pos, BlockStateProvider state, RandomSource random) {
        return FeatureLogic.canRootGrowIn((LevelSimulatedReader)world, (BlockPos)pos) && world.m_7731_(pos, state.m_213972_(random, pos), 3);
    }
}

