/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import maxhyper.dttwilightforest.trees.MagicFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class MagicCoreGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer((String)"min_radius");
    public static final ConfigurationProperty<Integer> HEIGHT = ConfigurationProperty.integer((String)"height");

    public MagicCoreGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MIN_RADIUS, HEIGHT});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_RADIUS, (Object)6)).with(HEIGHT, (Object)2);
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        Family family;
        if (context.fertility() > 0 && (family = context.species().getFamily()) instanceof MagicFamily) {
            MagicFamily magicFamily = (MagicFamily)family;
            this.flareBottom(configuration, context.level(), context.pos(), magicFamily);
            return true;
        }
        return false;
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        Family family = context.species().getFamily();
        if (family instanceof MagicFamily) {
            MagicFamily magicFamily = (MagicFamily)family;
            this.flareBottom(configuration, context.level(), context.pos(), magicFamily);
            return true;
        }
        return false;
    }

    public void flareBottom(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos rootPos, MagicFamily family) {
        int height = (Integer)configuration.get(HEIGHT);
        int radius2 = TreeHelper.getRadius((BlockGetter)level, (BlockPos)rootPos.m_6630_(height));
        if (radius2 > (Integer)configuration.get(MIN_RADIUS)) {
            family.getCoreBranch().ifPresent(branch -> {
                BlockPos placePos = rootPos.m_6630_(height);
                if (!level.m_8055_(placePos).m_60713_((Block)branch)) {
                    branch.setRadius(level, placePos, radius2, Direction.UP);
                }
            });
        }
    }
}

