/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttwilightforest.cellkits;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.cell.NormalCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import maxhyper.dttwilightforest.DynamicTreesTheTwilightForest;
import maxhyper.dttwilightforest.cellkits.DTTFLeafClusters;
import maxhyper.dttwilightforest.cellkits.DarkwoodLeafCell;

public class DTTFCellKits {
    public static final CellKit DARKWOOD = new CellKit(DynamicTreesTheTwilightForest.location("darkwood")){
        private final Cell branchCell = new NormalCell(8);
        private final Cell[] darkOakLeafCells = new Cell[]{CellNull.NULL_CELL, new DarkwoodLeafCell(1), new DarkwoodLeafCell(2), new DarkwoodLeafCell(3), new DarkwoodLeafCell(4), new DarkwoodLeafCell(5), new DarkwoodLeafCell(6), new DarkwoodLeafCell(7)};
        private final CellKits.BasicSolver darkOakSolver = new CellKits.BasicSolver(new short[]{2071, 1830, 1813, 1557, 1300, 1043, 802, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.darkOakLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.branchCell : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTTFLeafClusters.DARKWOOD;
        }

        public CellSolver getCellSolver() {
            return this.darkOakSolver;
        }

        public int getDefaultHydration() {
            return 7;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{DARKWOOD});
    }
}

