/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwquark;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.windows.Windows;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcwquark")
public class McwQuark {
    public static final String MODID = "mcwquark";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<String> stone = List.of("soul_sandstone_bricks", "limestone_bricks", "jasper_bricks", "shale_bricks", "permafrost_bricks", "red_sandstone_bricks", "sandstone_bricks", "cobblestone_bricks", "mossy_cobblestone_bricks", "blackstone_bricks", "diorite_bricks", "granite_bricks", "andesite_bricks", "calcite_bricks", "dripstone_bricks", "tuff_bricks", "raw_iron_bricks", "raw_gold_bricks", "raw_copper_bricks");
    private static final List<String> leaves = List.of("blue_blossom", "lavender_blossom", "orange_blossom", "red_blossom", "yellow_blossom", "ancient");
    private static final List<String> wood = List.of("blossom", "azalea", "ancient");
    private static final DeferredRegister<Block> BLOCKS = Registration.blocks((String)"mcwquark");
    private static final DeferredRegister<Item> ITEMS = Registration.items((String)"mcwquark");
    private static final DeferredRegister<CreativeModeTab> CT = Registration.creativeModeTab((String)"mcwquark");
    public static final RegistryObject<CreativeModeTab> MCWQUARK_TAB = CT.register("tab", () -> CreativeModeTab.builder().m_257737_(McwQuark::getIcon).m_257941_((Component)Component.m_237115_((String)"mcwquark.tab")).m_257652_());

    public McwQuark() {
        List<String> rockClassic = List.of("soul_sandstone_bricks", "limestone_bricks", "jasper_bricks", "shale_bricks", "permafrost_bricks", "red_sandstone_bricks", "sandstone_bricks", "cobblestone_bricks", "mossy_cobblestone_bricks", "blackstone_bricks", "diorite_bricks", "granite_bricks", "andesite_bricks", "raw_iron_bricks", "raw_gold_bricks", "raw_copper_bricks");
        BlockBehaviour.Properties propDrip = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_).m_60918_(SoundType.f_154661_);
        BlockBehaviour.Properties propCalcite = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_).m_60918_(SoundType.f_154660_);
        BlockBehaviour.Properties propTuff = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_).m_60918_(SoundType.f_154659_);
        LOGGER.info("Macaw's Quark Loading...");
        Registration.init(BLOCKS, ITEMS, CT);
        Bridges.setRegistrationWood(wood, BLOCKS, ITEMS);
        Bridges.setRegistrationRock(rockClassic, BLOCKS, ITEMS);
        Bridges.setRegistrationRockModLoaded(List.of("calcite_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propCalcite);
        Bridges.setRegistrationRockModLoaded(List.of("dripstone_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propDrip);
        Bridges.setRegistrationRockModLoaded(List.of("tuff_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propTuff);
        Roofs.setRegistrationWood(wood, BLOCKS, ITEMS);
        Roofs.setRegistrationRock(rockClassic, BLOCKS, ITEMS);
        Roofs.setRegistrationRockModLoaded(List.of("calcite_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propCalcite);
        Roofs.setRegistrationRockModLoaded(List.of("dripstone_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propDrip);
        Roofs.setRegistrationRockModLoaded(List.of("tuff_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propTuff);
        Fences.setRegistrationWood(wood, BLOCKS, ITEMS);
        Fences.setRegistrationRock(rockClassic, BLOCKS, ITEMS);
        Fences.setRegistrationRockModLoaded(List.of("calcite_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propCalcite);
        Fences.setRegistrationRockModLoaded(List.of("dripstone_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propDrip);
        Fences.setRegistrationRockModLoaded(List.of("tuff_bricks"), BLOCKS, ITEMS, (BlockBehaviour.Properties)propTuff);
        Fences.setRegistrationHedges(leaves, BLOCKS, ITEMS);
        Furnitures.setRegistrationWood(wood, BLOCKS, ITEMS);
        Stairs.setRegistrationWood(wood, BLOCKS, ITEMS);
        Doors.setRegistrationWood(wood, BLOCKS, ITEMS);
        Trapdoors.setRegistrationWood(wood, BLOCKS, ITEMS);
        Paths.setRegistrationWood(wood, BLOCKS, ITEMS);
        Windows.setRegistrationWood(wood, BLOCKS, ITEMS);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addTotab);
        LOGGER.info("Macaw's Quark Is Charged !");
    }

    private void addTotab(BuildCreativeModeTabContentsEvent event) {
        if (MCWQUARK_TAB != null) {
            Bridges.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Bridges.addToTabStone((BuildCreativeModeTabContentsEvent)event, (String)MODID, stone, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Roofs.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Roofs.addToTabStone((BuildCreativeModeTabContentsEvent)event, (String)MODID, stone, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Fences.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Fences.addToTabStone((BuildCreativeModeTabContentsEvent)event, (String)MODID, stone, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Fences.addToTabHedge((BuildCreativeModeTabContentsEvent)event, (String)MODID, leaves, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Furnitures.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Stairs.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Doors.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Trapdoors.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Paths.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
            Windows.addToTab((BuildCreativeModeTabContentsEvent)event, (String)MODID, wood, (CreativeModeTab)((CreativeModeTab)MCWQUARK_TAB.get()));
        }
    }

    @Nonnull
    private static ItemStack getIcon() {
        NewIconRandom.NewProperties propIcon = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"limestone_bricks_roof"), Finder.findBlock((String)MODID, (String)"orange_blossom_hedge"), Finder.findBlock((String)MODID, (String)"blossom_bookshelf"), Finder.findBlock((String)MODID, (String)"marble_bricks_bridge"), Finder.findBlock((String)MODID, (String)"azalea_shutter"), Finder.findBlock((String)MODID, (String)"blossom_beach_door"), Finder.findBlock((String)MODID, (String)"azalea_paper_trapdoor"), Finder.findBlock((String)MODID, (String)"blossom_planks_path"), Finder.findBlock((String)MODID, (String)"ancient_balcony"));
        propIcon.addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.WINDOWS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS).addType(NewIconRandom.BlockType.PATHS);
        Block icon = propIcon.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.STAIRS, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS, NewIconRandom.BlockType.PATHS});
        return new ItemStack((ItemLike)icon);
    }
}

