/*
 * Decompiled with CFR 0.152.
 */
package com.dimas_studio.tfbr.utils;

import com.dimas_studio.tfbr.TFBR;
import com.dimas_studio.tfbr.utils.ReplaseBlock;
import com.dimas_studio.tfbr.utils.Sound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import twilightforest.block.TFChestBlock;

public class WorldBlockManagment {
    public static void setBlock(int x, int y, int z, Level world, Block block) {
        WorldBlockManagment.setBlock(BlockPos.m_274561_((double)x, (double)y, (double)z), world, block);
    }

    public static void setBlock(BlockPos blockPos, Level world, Block block) {
        world.m_7731_(blockPos, block.m_49966_(), 3);
    }

    public static boolean checkBlock(int x, int y, int z, Level world, Block block) {
        return WorldBlockManagment.getBlock(BlockPos.m_274561_((double)x, (double)y, (double)z), world).equals(block);
    }

    public static Block getBlock(int x, int y, int z, Level world) {
        return WorldBlockManagment.getBlock(BlockPos.m_274561_((double)x, (double)y, (double)z), world);
    }

    public static Block getBlock(BlockPos blockPos, Level world) {
        return world.m_8055_(blockPos).m_60734_();
    }

    public static void setBlockAroundFiled(int x, int y, int z, int radius, Level world, Block block) {
        for (int x_block = x - radius; x_block <= x + radius; ++x_block) {
            for (int z_block = z - radius; z_block <= z + radius; ++z_block) {
                if (Math.abs(x_block - x) + Math.abs(z_block - z) > radius) continue;
                WorldBlockManagment.setBlock(x_block, y, z_block, world, block);
            }
        }
    }

    public static void setBlockAround(int x, int y, int z, Level world, Block block, ReplaseBlock.ReplaseEffects replaseEffects) {
        WorldBlockManagment.setBlock(x + 3, y, z, world, block);
        WorldBlockManagment.setBlock(x - 3, y, z, world, block);
        WorldBlockManagment.setBlock(x, y, z + 3, world, block);
        WorldBlockManagment.setBlock(x, y, z - 3, world, block);
        WorldBlockManagment.setBlock(x + 2, y, z + 2, world, block);
        WorldBlockManagment.setBlock(x - 2, y, z + 2, world, block);
        WorldBlockManagment.setBlock(x + 2, y, z - 2, world, block);
        WorldBlockManagment.setBlock(x - 2, y, z - 2, world, block);
    }

    public static void replaceBlocks(Level world, ReplaseBlock.BlockToReplase[] blocksToReplase) {
        WorldBlockManagment.replaceBlocks(world, blocksToReplase, 0);
    }

    private static void replaceBlocks(Level world, ReplaseBlock.BlockToReplase[] blocksToReplase, int i) {
        if (i >= 0) {
            do {
                int x = blocksToReplase[i].x;
                int y = blocksToReplase[i].y;
                int z = blocksToReplase[i].z;
                Block block = blocksToReplase[i].block;
                WorldBlockManagment.setBlock(x, y, z, world, block);
                if (blocksToReplase[i].summonLightning) {
                    WorldBlockManagment.summonLighting(x, y, z, world);
                }
                if (blocksToReplase[i].sound != null) {
                    Sound sound = blocksToReplase[i].sound;
                    world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), sound.soundEvent, sound.soundSource, (float)sound.level, (float)sound.pitch);
                }
                if (++i != blocksToReplase.length) continue;
                return;
            } while (blocksToReplase[i].tick == 0);
        }
        int finalI = i;
        TFBR.queueServerWork(blocksToReplase[i].tick, () -> WorldBlockManagment.replaceBlocks(world, blocksToReplase, finalI));
    }

    private static void summonLighting(int x, int y, int z, Level world) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(world);
        lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)x, (double)y, (double)z)));
        world.m_7967_((Entity)lightningBolt);
    }

    public static void summonBlock(Level world, BlockPos blockPos, Block block, int extraY) {
        if (world.m_8055_(blockPos).m_60734_() instanceof TFChestBlock) {
            WorldBlockManagment.setBlock(BlockPos.m_274561_((double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + extraY), (double)blockPos.m_123343_()), world, block);
            return;
        }
        TFBR.queueServerWork(40, () -> WorldBlockManagment.summonBlock(world, blockPos, block, extraY));
    }
}

