/*
 * Decompiled with CFR 0.152.
 */
package com.dimas_studio.tfbr.block;

import com.dimas_studio.tfbr.TFBR;
import com.dimas_studio.tfbr.utils.WorldBlockManagment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RespawnBlock
extends Block {
    public RespawnBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_.m_60955_());
    }

    protected void incorrectAltar(int x, int y, int z, Level world, Entity entity, Block thophy, Block material, String tanslationkey, ParticleOptions centralParticle, ParticleOptions roundParticle) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String message = String.format(Component.m_237115_((String)tanslationkey).getString(), material.m_49954_().getString(), thophy.m_49954_().getString());
            player.m_213846_((Component)Component.m_237113_((String)message));
            if (world instanceof ServerLevel) {
                this.summonAllParticle(x, y, z, world, 50, centralParticle, roundParticle, player);
            }
        }
    }

    private void summonAllParticle(int x, int y, int z, Level world, int times, ParticleOptions centralParticle, ParticleOptions roundParticle, Player player) {
        this.summonParticle(x + 3, y, z, world, roundParticle, player);
        this.summonParticle(x - 3, y, z, world, roundParticle, player);
        this.summonParticle(x, y, z + 3, world, roundParticle, player);
        this.summonParticle(x, y, z - 3, world, roundParticle, player);
        this.summonParticle(x + 2, y, z + 2, world, roundParticle, player);
        this.summonParticle(x + 2, y, z - 2, world, roundParticle, player);
        this.summonParticle(x - 2, y, z + 2, world, roundParticle, player);
        this.summonParticle(x - 2, y, z - 2, world, roundParticle, player);
        this.summonParticle(x, y + 1, z, world, centralParticle, player);
        if (times > 0) {
            TFBR.queueServerWork(5, () -> this.summonAllParticle(x, y, z, world, times - 1, centralParticle, roundParticle, player));
        }
    }

    private void summonParticle(int X, int Y, int Z, Level world, ParticleOptions particleOptions, Player player) {
        RandomSource random = world.f_46441_;
        double x = (double)X + 0.5;
        double y = (double)Y + 0.5;
        double z = (double)Z + 0.5;
        for (int i = 0; i < 1 + random.m_188503_(5); ++i) {
            double particleX = x - 0.2 + random.m_188500_() * 0.4;
            double particleY = y - 0.2 + random.m_188500_() * 0.4;
            double particleZ = z - 0.2 + random.m_188500_() * 0.4;
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.m_284548_();
            serverLevel.m_8767_(particleOptions, particleX, particleY, particleZ, 5, 0.0, 0.0, 0.0, 0.01);
        }
    }

    protected boolean checkRespawnConditions(int x, int y, int z, Level world, Block trophyBlock, Block materialBlock) {
        if (!WorldBlockManagment.checkBlock(x, y + 1, z, world, trophyBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x + 3, y, z, world, materialBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x - 3, y, z, world, materialBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x, y, z + 3, world, materialBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x, y, z - 3, world, materialBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x + 2, y, z + 2, world, materialBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x + 2, y, z - 2, world, materialBlock)) {
            return false;
        }
        if (!WorldBlockManagment.checkBlock(x - 2, y, z + 2, world, materialBlock)) {
            return false;
        }
        return WorldBlockManagment.checkBlock(x - 2, y, z - 2, world, materialBlock);
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player entity, InteractionHand interactionHand, BlockHitResult hit) {
        if (!world.f_46443_) {
            this.use(world, pos, entity);
        }
        return InteractionResult.SUCCESS;
    }

    protected void use(Level world, BlockPos pos, Player entity) {
    }
}

