/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.StringHelpers;

public class DisplayErrorsComponent {
    public void drawForeground(PoseStack matrixStack, @Nullable List<MutableComponent> errors, int errorX, int errorY, int mouseX, int mouseY, ContainerScreenExtended<?> gui, int guiLeft, int guiTop) {
        if (errors != null && !errors.isEmpty() && gui.m_6774_(errorX, errorY, Images.ERROR.getSheetWidth(), Images.ERROR.getSheetHeight(), (double)mouseX, (double)mouseY)) {
            LinkedList lines = Lists.newLinkedList();
            for (Component component : errors) {
                lines.addAll(StringHelpers.splitLines((String)component.getString(), (int)25, (String)ChatFormatting.RED.toString()).stream().map(Component::m_237113_).collect(Collectors.toList()));
            }
            gui.drawTooltip((List)lines, matrixStack, mouseX - guiLeft, mouseY - guiTop);
        }
    }

    public void drawBackground(GuiGraphics guiGraphics, @Nullable List<MutableComponent> errors, int errorX, int errorY, int okX, int okY, ContainerScreenExtended<?> gui, int guiLeft, int guiTop, boolean okCondition) {
        if (errors != null && !errors.isEmpty()) {
            Images.ERROR.draw(guiGraphics, guiLeft + errorX, guiTop + errorY);
        } else if (okCondition) {
            Images.OK.draw(guiGraphics, guiLeft + okX, guiTop + okY);
        }
    }
}

