/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.vec.uv;

import codechicken.lib.util.Copyable;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import java.util.ArrayList;
import net.covers1624.quack.collection.StreamableIterable;

public class UVTransformationList
extends UVTransformation {
    private ArrayList<UVTransformation> transformations = new ArrayList();

    public UVTransformationList(UVTransformation ... transforms) {
        for (UVTransformation t : transforms) {
            if (t instanceof UVTransformationList) {
                this.transformations.addAll(((UVTransformationList)t).transformations);
                continue;
            }
            this.transformations.add(t);
        }
        this.compact();
    }

    public UVTransformationList(UVTransformationList other) {
        this.transformations = StreamableIterable.of(other.transformations).map(Copyable::copy).toList();
        this.compact();
    }

    @Override
    public void apply(UV uv) {
        for (UVTransformation transformation : this.transformations) {
            transformation.apply(uv);
        }
    }

    @Override
    public UVTransformationList with(UVTransformation t) {
        if (t.isRedundant()) {
            return this;
        }
        if (t instanceof UVTransformationList) {
            this.transformations.addAll(((UVTransformationList)t).transformations);
        } else {
            this.transformations.add(t);
        }
        this.compact();
        return this;
    }

    public UVTransformationList prepend(UVTransformation t) {
        if (t.isRedundant()) {
            return this;
        }
        if (t instanceof UVTransformationList) {
            this.transformations.addAll(0, ((UVTransformationList)t).transformations);
        } else {
            this.transformations.add(0, t);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<UVTransformation> newList = new ArrayList<UVTransformation>(this.transformations.size());
        UVTransformation prev = null;
        for (UVTransformation t : this.transformations) {
            if (t.isRedundant()) continue;
            if (prev != null) {
                UVTransformation m = prev.merge(t);
                if (m == null) {
                    newList.add(prev);
                } else {
                    t = m.isRedundant() ? null : m;
                }
            }
            prev = t;
        }
        if (prev != null) {
            newList.add(prev);
        }
        if (newList.size() < this.transformations.size()) {
            this.transformations = newList;
        }
    }

    @Override
    public boolean isRedundant() {
        return this.transformations.size() == 0;
    }

    @Override
    public UVTransformation inverse() {
        UVTransformationList rev = new UVTransformationList(new UVTransformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with((UVTransformation)this.transformations.get(i).inverse());
        }
        return rev;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (UVTransformation t : this.transformations) {
            s.append("\n").append(t.toString());
        }
        return s.toString().trim();
    }

    @Override
    public UVTransformation copy() {
        return new UVTransformationList(this);
    }
}

