/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceUtils {
    public static HitResult getEntityLookedObject(LivingEntity entity, double maxDistance) {
        Pair<Vec3, Vec3> vecs = RayTraceUtils.getStartAndEndLookVec(entity, maxDistance);
        ClipContext ctx = new ClipContext((Vec3)vecs.getLeft(), (Vec3)vecs.getRight(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.m_9236_().m_45547_(ctx);
    }

    public static Pair<Vec3, Vec3> getStartAndEndLookVec(LivingEntity entity, double maxDistance) {
        Vec3 entityVec = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 maxDistVec = entityVec.m_82549_(entity.m_20252_(1.0f).m_82490_(maxDistance));
        return new ImmutablePair((Object)entity.m_20299_(1.0f), (Object)maxDistVec);
    }

    public static HitResult getMouseOverServer(LivingEntity lookingEntity, double range) {
        HitResult result = RayTraceUtils.raytraceEntityBlocks(lookingEntity, range);
        double rangeSq = range * range;
        Pair<Vec3, Vec3> startAndEnd = RayTraceUtils.getStartAndEndLookVec(lookingEntity, (float)range);
        Vec3 eyePos = (Vec3)startAndEnd.getLeft();
        if (result.m_6662_() != HitResult.Type.MISS) {
            rangeSq = result.m_82450_().m_82557_(eyePos);
        }
        double rangeSq2 = rangeSq;
        Vec3 hitVec = null;
        Entity focusedEntity = null;
        Vec3 lookVec = lookingEntity.m_20154_().m_82490_(range + 1.0);
        AABB box = lookingEntity.m_20191_().m_82377_(lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_);
        for (Entity entity : lookingEntity.m_9236_().m_6249_((Entity)lookingEntity, box, Entity::m_6087_)) {
            double rangeSq3;
            AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional vec = aabb.m_82371_(eyePos, (Vec3)startAndEnd.getRight());
            if (aabb.m_82390_(eyePos)) {
                if (!(rangeSq2 >= 0.0)) continue;
                focusedEntity = entity;
                hitVec = vec.orElse(eyePos);
                rangeSq2 = 0.0;
                continue;
            }
            if (!vec.isPresent() || !((rangeSq3 = eyePos.m_82557_((Vec3)vec.get())) < rangeSq2) && rangeSq2 != 0.0) continue;
            if (entity == entity.m_20202_() && !entity.canRiderInteract()) {
                if (rangeSq2 != 0.0) continue;
                focusedEntity = entity;
                hitVec = (Vec3)vec.get();
                continue;
            }
            focusedEntity = entity;
            hitVec = (Vec3)vec.get();
            rangeSq2 = rangeSq3;
        }
        return focusedEntity != null && rangeSq2 < rangeSq ? new EntityHitResult(focusedEntity, hitVec) : result;
    }

    private static HitResult raytraceEntityBlocks(LivingEntity entity, double range) {
        Pair<Vec3, Vec3> startAndEnd = RayTraceUtils.getStartAndEndLookVec(entity, (float)range);
        ClipContext ctx = new ClipContext((Vec3)startAndEnd.getLeft(), (Vec3)startAndEnd.getRight(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.m_9236_().m_45547_(ctx);
    }
}

