/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.inventory.slot.IPhantomSlot;
import me.desht.pneumaticcraft.common.inventory.slot.PlayerEquipmentSlot;
import me.desht.pneumaticcraft.common.inventory.slot.UpgradeSlot;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class AbstractPneumaticCraftMenu<T extends AbstractPneumaticCraftBlockEntity>
extends AbstractContainerMenu
implements IGUIButtonSensitive {
    public final T te;
    private final List<SyncedField<?>> syncedFields = new ArrayList();
    private boolean firstTick = true;
    int playerSlotsStart;

    public AbstractPneumaticCraftMenu(MenuType type, int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(type, windowId, invPlayer, AbstractPneumaticCraftMenu.getTilePos(extraData));
    }

    public AbstractPneumaticCraftMenu(MenuType type, int windowId, Inventory invPlayer) {
        this(type, windowId, invPlayer, (BlockPos)null);
    }

    public AbstractPneumaticCraftMenu(MenuType type, int windowId, Inventory invPlayer, BlockPos tilePos) {
        super(type, windowId);
        if (tilePos != null) {
            BlockEntity te0 = invPlayer.f_35978_.m_9236_().m_7702_(tilePos);
            if (te0 instanceof AbstractPneumaticCraftBlockEntity) {
                this.te = (AbstractPneumaticCraftBlockEntity)te0;
                this.addSyncedFields(this.te);
            } else {
                this.te = null;
            }
        } else {
            this.te = null;
        }
    }

    public static void putHand(FriendlyByteBuf buf, InteractionHand hand) {
        buf.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    static InteractionHand getHand(FriendlyByteBuf buf) {
        return buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    static BlockPos getTilePos(FriendlyByteBuf buf) {
        return buf.m_130135_();
    }

    void addSyncedField(SyncedField<?> field) {
        this.syncedFields.add(field);
        field.setLazy(false);
    }

    void addSyncedFields(Object annotatedObject) {
        NetworkUtils.getSyncedFields(annotatedObject, GuiSynced.class).forEach(this::addSyncedField);
    }

    public void updateField(int index, Object value) {
        this.syncedFields.get(index).setValue(value);
        if (this.te != null) {
            ((AbstractPneumaticCraftBlockEntity)this.te).onGuiUpdate();
        }
    }

    public boolean m_6875_(Player player) {
        return ((AbstractPneumaticCraftBlockEntity)this.te).isGuiUseableByPlayer(player);
    }

    public void m_38946_() {
        super.m_38946_();
        IntArrayList toUpdate = new IntArrayList();
        for (int i = 0; i < this.syncedFields.size(); ++i) {
            if (!this.syncedFields.get(i).update() && !this.firstTick) continue;
            toUpdate.add(i);
        }
        if (!toUpdate.isEmpty()) {
            AbstractPneumaticCraftMenu self = this;
            List<ServerPlayer> players = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().stream().filter(p -> p.f_36096_ == self).toList();
            if (!players.isEmpty()) {
                toUpdate.forEach(idx -> players.forEach(player -> NetworkHandler.sendToPlayer(new PacketUpdateGui(idx, this.syncedFields.get(idx)), player)));
            }
        }
        this.firstTick = false;
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int yOffset) {
        this.addPlayerSlots(inventoryPlayer, 8, yOffset);
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int xOffset, int yOffset) {
        this.playerSlotsStart = this.f_38839_.size();
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.m_38897_(new Slot((Container)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, xOffset + inventoryColumnIndex * 18, yOffset + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.m_38897_(new Slot((Container)inventoryPlayer, actionBarSlotIndex, xOffset + actionBarSlotIndex * 18, yOffset + 58));
        }
    }

    protected void addUpgradeSlots(int xBase, int yBase) {
        for (int i = 0; i < ((AbstractPneumaticCraftBlockEntity)this.te).getUpgradeHandler().getSlots(); ++i) {
            this.m_38897_((Slot)new UpgradeSlot((AbstractPneumaticCraftBlockEntity)this.te, i, xBase + i % 2 * 18, yBase + i / 2 * 18));
        }
    }

    void addArmorSlots(Inventory inventoryPlayer, int xBase, int yBase) {
        for (int i = 0; i < 4; ++i) {
            this.m_38897_(new PlayerEquipmentSlot(inventoryPlayer, ArmorUpgradeRegistry.ARMOR_SLOTS[i], xBase, yBase + i * 18));
        }
    }

    void addOffhandSlot(Inventory inventory, int x, int y) {
        this.m_38897_(new PlayerEquipmentSlot(inventory, EquipmentSlot.OFFHAND, x, y));
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        Slot srcSlot = (Slot)this.f_38839_.get(slot);
        if (srcSlot == null || !srcSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack srcStack = srcSlot.m_7993_().m_41777_();
        ItemStack copyOfSrcStack = srcStack.m_41777_();
        if (slot < this.playerSlotsStart ? !this.moveItemStackToHotbarOrInventory(srcStack, this.playerSlotsStart) : !this.m_38903_(srcStack, 0, this.playerSlotsStart, false)) {
            return ItemStack.f_41583_;
        }
        srcSlot.m_5852_(srcStack);
        srcSlot.m_40234_(srcStack, copyOfSrcStack);
        srcSlot.m_142406_(player, srcStack);
        return copyOfSrcStack;
    }

    boolean moveItemStackToHotbarOrInventory(ItemStack stack, int startIndex) {
        return this.m_38903_(stack, startIndex + 27, startIndex + 36, false) || this.m_38903_(stack, startIndex, startIndex + 27, false);
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_5866_(itemstack), Math.min(slot.m_6641_(), stack.m_41741_())))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    int limit = Math.min(slot1.m_6641_(), slot1.m_5866_(stack));
                    if (stack.m_41613_() > limit) {
                        slot1.m_5852_(stack.m_41620_(limit));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.f_38839_.get(slotId);
        if (slot instanceof IPhantomSlot) {
            this.slotClickPhantom(slot, dragType, clickType, player);
        } else {
            super.m_150399_(slotId, dragType, clickType, player);
        }
    }

    @Nonnull
    private ItemStack slotClickPhantom(Slot slot, int dragType, ClickType clickType, Player player) {
        ItemStack stack = ItemStack.f_41583_;
        if (clickType == ClickType.CLONE && dragType == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
        } else if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            slot.m_6654_();
            ItemStack stackSlot = slot.m_7993_();
            ItemStack stackHeld = this.m_142621_();
            stack = stackSlot.m_41777_();
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, dragType);
                }
            } else if (stackHeld.m_41619_()) {
                this.adjustPhantomSlot(slot, clickType, dragType);
                slot.m_142406_(player, this.m_142621_());
            } else if (slot.m_5857_(stackHeld)) {
                if (this.canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, clickType, dragType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, dragType);
                }
            }
        }
        return stack;
    }

    private boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && !stack2.m_41619_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    private void adjustPhantomSlot(Slot slot, ClickType clickType, int dragType) {
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.m_7993_().m_41777_();
        if (dragType == 1) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.m_41764_(Math.min(stackSlot.m_41613_() * 2, slot.m_6641_()));
            } else {
                stackSlot.m_41764_(Math.min(stackSlot.m_41613_() + 1, slot.m_6641_()));
            }
        } else if (dragType == 0) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.m_41764_(stackSlot.m_41613_() / 2);
            } else {
                stackSlot.m_41774_(1);
            }
        }
        slot.m_5852_(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, int dragType) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = dragType == 0 ? stackHeld.m_41613_() : 1;
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        ItemStack phantomStack = stackHeld.m_41777_();
        phantomStack.m_41764_(stackSize);
        slot.m_5852_(phantomStack);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.te != null) {
            ((AbstractPneumaticCraftBlockEntity)this.te).handleGUIButtonPress(tag, shiftHeld, player);
        }
    }
}

