/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.LiquidHopperBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.LiquidHopperMenu;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class LiquidHopperScreen
extends AbstractPneumaticCraftContainerScreen<LiquidHopperMenu, LiquidHopperBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[2];

    public LiquidHopperScreen(LiquidHopperMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new WidgetTank(this.f_97735_ + 116, this.f_97736_ + 15, ((LiquidHopperBlockEntity)this.te).getTank()));
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.hopperStatus", new Object[0]), new ItemStack((ItemLike)ModBlocks.LIQUID_HOPPER.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode", new Object[0]), new ItemStack((ItemLike)Blocks.f_50164_), -13312, false);
        optionStat.setMinimumExpandedDimensions(50, 43);
        WidgetButtonExtended button = new WidgetButtonExtended(20, 20, 20, 20, (Component)Component.m_237119_()).withTag("empty");
        button.setRenderStacks(new ItemStack((ItemLike)Items.f_42446_));
        button.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidHopper.mode.empty", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(45, 20, 20, 20, (Component)Component.m_237119_()).withTag("leave");
        button.setRenderStacks(new ItemStack((ItemLike)Items.f_42447_));
        button.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidHopper.mode.leaveLiquid", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[1] = button;
    }

    @Override
    protected boolean isUpgradeAvailable(PNCUpgrade upgrade) {
        return upgrade != ModUpgrades.DISPENSER.get() || (Boolean)ConfigHelper.common().machines.liquidHopperDispenser.get() != false;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.statusStat.setText(this.getStatus());
        this.modeButtons[0].f_93623_ = ((LiquidHopperBlockEntity)this.te).doesLeaveMaterial();
        this.modeButtons[1].f_93623_ = !((LiquidHopperBlockEntity)this.te).doesLeaveMaterial();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_HOPPER;
    }

    private List<Component> getStatus() {
        ArrayList<Component> textList = new ArrayList<Component>();
        int itemsPer = ((LiquidHopperBlockEntity)this.te).getMaxItems();
        if (itemsPer > 1) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.liquidTransferPerTick", itemsPer * 100));
        } else {
            int transferInterval = ((LiquidHopperBlockEntity)this.te).getItemTransferInterval();
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.liquidTransferPerSecond", transferInterval == 0 ? "2000" : PneumaticCraftUtils.roundNumberTo(2000.0f / (float)transferInterval, 1)));
        }
        return textList;
    }
}

