/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.game;

import mod.lucky.common.GameAPIKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.DropEvaluatorKt;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.java.DropSerializerKt;
import mod.lucky.java.game.DelayedDropData;
import mod.lucky.java.game.GameUtilsKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u001a\"\u0010\t\u001a\u00020\u0001*\u00020\u00022\n\u0010\n\u001a\u00060\u0004j\u0002`\u000b2\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u001a\u0016\u0010\f\u001a\u00020\r*\u00020\u00012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u0001\u001a\u0016\u0010\u000f\u001a\u00020\r*\u00020\u00012\n\u0010\n\u001a\u00060\u0004j\u0002`\u000b\u00a8\u0006\u0010"}, d2={"createDefault", "Lmod/lucky/java/game/DelayedDropData;", "Lmod/lucky/java/game/DelayedDropData$Companion;", "world", "", "Lmod/lucky/common/World;", "fromAttr", "attr", "Lmod/lucky/common/attribute/DictAttr;", "readFromTag", "tag", "Lmod/lucky/java/NBTTag;", "tick", "", "toAttr", "writeToTag", "common"})
public final class DelayedDropUtilsKt {
    public static final void tick(@NotNull DelayedDropData $this$tick, @NotNull Object world) {
        Intrinsics.checkNotNullParameter($this$tick, "<this>");
        Intrinsics.checkNotNullParameter(world, "world");
        try {
            if ($this$tick.getTicksRemaining() > 0) {
                int n = $this$tick.getTicksRemaining();
                $this$tick.setTicksRemaining(n + -1);
                if ($this$tick.getTicksRemaining() == 0) {
                    DropEvaluatorKt.runDropAfterDelay($this$tick.getSingleDrop(), DropContext.copy$default($this$tick.getContext(), world, null, null, null, 0.0, null, 62, null));
                }
            }
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Error running delayed drop: " + $this$tick.getSingleDrop(), e);
        }
    }

    @NotNull
    public static final DictAttr toAttr(@NotNull DelayedDropData $this$toAttr) {
        Intrinsics.checkNotNullParameter($this$toAttr, "<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to("drop", DropSerializerKt.toAttr($this$toAttr.getSingleDrop())), TuplesKt.to("context", DropSerializerKt.toAttr($this$toAttr.getContext())), TuplesKt.to("ticksRemaining", AttributeKt.intAttrOf($this$toAttr.getTicksRemaining()))};
        return AttributeKt.dictAttrOf(pairArray);
    }

    @NotNull
    public static final DelayedDropData fromAttr(@NotNull DelayedDropData.Companion $this$fromAttr, @NotNull DictAttr attr, @NotNull Object world) {
        DelayedDropData delayedDropData;
        Intrinsics.checkNotNullParameter($this$fromAttr, "<this>");
        Intrinsics.checkNotNullParameter(attr, "attr");
        Intrinsics.checkNotNullParameter(world, "world");
        try {
            delayedDropData = new DelayedDropData(DropSerializerKt.fromAttr(SingleDrop.Companion, attr.getDict("drop")), DropSerializerKt.fromAttr(DropContext.Companion, attr.getDict("context"), world), ((Number)attr.getValue("ticksRemaining")).intValue());
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Error loading delayed drop", e);
            delayedDropData = DelayedDropUtilsKt.createDefault($this$fromAttr, world);
        }
        return delayedDropData;
    }

    @NotNull
    public static final DelayedDropData createDefault(@NotNull DelayedDropData.Companion $this$createDefault, @NotNull Object world) {
        Intrinsics.checkNotNullParameter($this$createDefault, "<this>");
        Intrinsics.checkNotNullParameter(world, "world");
        return new DelayedDropData(SingleDrop.Companion.getNothingDrop(), new DropContext(world, new Vec3<Number>(0.0, 0.0, 0.0), null, null, 0.0, "lucky:lucky_block", 28, null), 0);
    }

    public static final void writeToTag(@NotNull DelayedDropData $this$writeToTag, @NotNull Object tag) {
        Intrinsics.checkNotNullParameter($this$writeToTag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        GameUtilsKt.writeNBTKeys(tag, DelayedDropUtilsKt.toAttr($this$writeToTag));
    }

    @NotNull
    public static final DelayedDropData readFromTag(@NotNull DelayedDropData.Companion $this$readFromTag, @NotNull Object tag, @NotNull Object world) {
        Intrinsics.checkNotNullParameter($this$readFromTag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(world, "world");
        return DelayedDropUtilsKt.fromAttr(DelayedDropData.Companion, GameUtilsKt.readNBTKeys(tag, $this$readFromTag.getAttrKeys()), world);
    }
}

