/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.forge;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mod.lucky.common.Enchantment;
import mod.lucky.common.GameAPI;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.Logger;
import mod.lucky.common.StatusEffect;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.action.DropActionsKt;
import mod.lucky.forge.ForgeGameAPIKt;
import mod.lucky.forge.ForgeLuckyRegistry;
import mod.lucky.forge.game.DelayedDrop;
import mod.lucky.java.JavaGameAPI;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.JavaLuckyRegistry;
import mod.lucky.java.game.DelayedDropData;
import mod.lucky.java.game.GameUtilsKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.ArraysKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.text.StringsKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J6\u0010\u0017\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JX\u0010 \u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0006\u0010!\u001a\u00020\u00072\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00150\u001bj\u0002`\"2\u0010\u0010#\u001a\f\u0012\u0004\u0012\u00020\u00150\u001bj\u0002`\"2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u001fH\u0016JB\u0010'\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u001e\u0010-\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\n\u0010.\u001a\u00060\u000fj\u0002`\u0010H\u0016JB\u0010/\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00100\u00042\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u00100\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0010\u00101\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001cH\u0016J.\u00102\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`32\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001cH\u0016J\u0014\u00104\u001a\u00020\u00132\n\u00105\u001a\u00060\u000fj\u0002`3H\u0016J\u0014\u00106\u001a\u00020\u00132\n\u00105\u001a\u00060\u000fj\u0002`3H\u0016J\u0014\u00107\u001a\u00020\u00072\n\u00105\u001a\u00060\u000fj\u0002`3H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004H\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0016J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0\u0004H\u0016J\u0014\u0010<\u001a\u00020=2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0019H\u0016J\u0006\u0010>\u001a\u00020\fJ&\u0010?\u001a\u00020\u001f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00150\u001bj\u0002`\"H\u0016J\"\u0010@\u001a\u00020\f2\b\u0010A\u001a\u0004\u0018\u00010\u00072\u000e\u0010B\u001a\n\u0018\u00010Cj\u0004\u0018\u0001`DH\u0016J\u0010\u0010E\u001a\u00020\f2\u0006\u0010A\u001a\u00020\u0007H\u0016J6\u0010F\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u00020\u0015H\u0016J>\u0010I\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u0013H\u0016J?\u0010L\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\b\u0010M\u001a\u0004\u0018\u00010\u00072\b\u0010N\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010OJ>\u0010P\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u001fH\u0016J \u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0013H\u0016J\u001c\u0010Z\u001a\u00020\f2\n\u00105\u001a\u00060\u000fj\u0002`32\u0006\u0010[\u001a\u00020\u0007H\u0016JR\u0010\\\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00150\u001bj\u0002`\"2\u0006\u0010(\u001a\u00020\u00072\b\u0010]\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u001fH\u0016J.\u0010^\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00150\u001bj\u0002`\"2\u0006\u0010)\u001a\u00020*H\u0016J\u001c\u0010_\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0006\u0010`\u001a\u00020\u0007H\u0016J&\u0010a\u001a\u00020\f2\n\u0010.\u001a\u00060\u000fj\u0002`\u00102\u0010\u0010b\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001cH\u0016J\u001c\u0010c\u001a\u00020\f2\n\u0010.\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u001c\u0010d\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0006\u0010e\u001a\u00020=H\u0016Jh\u0010f\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0006\u0010(\u001a\u00020\u00072\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010*2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010g\u001a\u00020\u001f2\u000e\u00105\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`32\u0006\u0010h\u001a\u00020\u0007H\u0016JV\u0010i\u001a\u00020\f2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00192\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010(\u001a\u00020\u00072\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0010\u0010k\u001a\f\u0012\u0004\u0012\u00020\u00130\u001bj\u0002`\u001c2\u0006\u0010l\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lmod/lucky/forge/ForgeGameAPI;", "Lmod/lucky/common/GameAPI;", "()V", "enchantments", "", "Lmod/lucky/common/Enchantment;", "spawnEggIds", "", "usefulPotionIds", "usefulStatusEffects", "Lmod/lucky/common/StatusEffect;", "applyStatusEffect", "", "target", "targetEntity", "", "Lmod/lucky/common/Entity;", "effectId", "durationSeconds", "", "amplifier", "", "convertStatusEffectId", "createExplosion", "world", "Lmod/lucky/common/World;", "pos", "Lmod/lucky/common/Vec3;", "Lmod/lucky/common/Vec3d;", "damage", "fire", "", "createStructure", "structureId", "Lmod/lucky/common/Vec3i;", "centerOffset", "rotation", "mode", "notify", "dropItem", "id", "nbt", "Lmod/lucky/common/attribute/DictAttr;", "components", "getEnchantments", "getEntityPos", "entity", "getLivingEntitiesInBox", "boxMin", "boxMax", "getNearestPlayer", "Lmod/lucky/common/PlayerEntity;", "getPlayerHeadPitchDeg", "player", "getPlayerHeadYawDeg", "getPlayerName", "getRGBPalette", "getSpawnEggIds", "getUsefulPotionIds", "getUsefulStatusEffects", "getWorldTime", "", "init", "isAirBlock", "logError", "msg", "error", "Ljava/lang/Exception;", "Lmod/lucky/kotlin/Exception;", "logInfo", "playParticleEvent", "eventId", "data", "playSound", "volume", "pitch", "playSplashPotionEvent", "potionName", "potionColor", "(Ljava/lang/Object;Lmod/lucky/common/Vec3;Ljava/lang/String;Ljava/lang/Integer;)V", "runCommand", "command", "senderName", "showOutput", "scheduleDrop", "drop", "Lmod/lucky/common/drop/SingleDrop;", "context", "Lmod/lucky/common/drop/DropContext;", "seconds", "sendMessage", "message", "setBlock", "state", "setBlockEntity", "setDifficulty", "difficulty", "setEntityMotion", "motion", "setEntityOnFire", "setTime", "time", "spawnEntity", "randomizeMob", "sourceId", "spawnParticle", "args", "boxSize", "amount", "lucky-block"})
public final class ForgeGameAPI
implements GameAPI {
    @NotNull
    public static final ForgeGameAPI INSTANCE = new ForgeGameAPI();
    @NotNull
    private static List<String> usefulPotionIds = CollectionsKt.emptyList();
    @NotNull
    private static List<String> spawnEggIds = CollectionsKt.emptyList();
    @NotNull
    private static List<Enchantment> enchantments = CollectionsKt.emptyList();
    @NotNull
    private static List<StatusEffect> usefulStatusEffects = CollectionsKt.emptyList();

    private ForgeGameAPI() {
    }

    /*
     * Unable to fully structure code
     */
    public final void init() {
        v0 = ForgeRegistries.POTIONS.getKeys();
        Intrinsics.checkNotNullExpressionValue(v0, "POTIONS.keys");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceLocation)element$iv$iv;
            $i$a$-filter-ForgeGameAPI$init$1 = false;
            if (!(Intrinsics.areEqual(it.m_135827_(), "minecraft") != false && GameUtilsKt.getUselessPostionNames().contains(it.m_135815_()) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceLocation)item$iv$iv;
            var12_10 = destination$iv$iv;
            $i$a$-map-ForgeGameAPI$init$2 = false;
            var12_10.add(it.toString());
        }
        ForgeGameAPI.usefulPotionIds = CollectionsKt.toList((List)destination$iv$iv);
        v1 = ForgeRegistries.ITEMS.getKeys();
        Intrinsics.checkNotNullExpressionValue(v1, "ITEMS.keys");
        $this$filter$iv = v1;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceLocation)element$iv$iv;
            $i$a$-filter-ForgeGameAPI$init$3 = false;
            if (!Intrinsics.areEqual(it.m_135827_(), "minecraft")) ** GOTO lbl-1000
            v2 = it.m_135815_();
            Intrinsics.checkNotNullExpressionValue(v2, "it.path");
            if (StringsKt.endsWith$default(v2, "_spawn_egg", false, 2, null)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceLocation)item$iv$iv;
            var12_10 = destination$iv$iv;
            $i$a$-map-ForgeGameAPI$init$4 = false;
            var12_10.add(it.toString());
        }
        ForgeGameAPI.spawnEggIds = CollectionsKt.toList((List)destination$iv$iv);
        $this$map$iv = GameUtilsKt.getUsefulStatusEffectIds();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            var12_10 = destination$iv$iv;
            $i$a$-map-ForgeGameAPI$init$5 = false;
            mcId = new ResourceLocation((String)it);
            v4 = ForgeRegistries.MOB_EFFECTS.getValue(mcId);
            Intrinsics.checkNotNull(v4);
            mcStatusEffect = (MobEffect)v4;
            v5 = mcId.toString();
            Intrinsics.checkNotNullExpressionValue(v5, "mcId.toString()");
            var12_10.add(new StatusEffect(v5, MobEffect.m_19459_((MobEffect)mcStatusEffect), mcStatusEffect.m_19483_() == MobEffectCategory.HARMFUL, mcStatusEffect.m_8093_()));
        }
        ForgeGameAPI.usefulStatusEffects = (List)destination$iv$iv;
        v6 = ForgeRegistries.ENCHANTMENTS.getEntries();
        Intrinsics.checkNotNullExpressionValue(v6, "ENCHANTMENTS.entries");
        $this$map$iv = v6;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            var12_10 = destination$iv$iv;
            $i$a$-map-ForgeGameAPI$init$6 = false;
            v7 = ((ResourceKey)it.getKey()).m_135782_().toString();
            Intrinsics.checkNotNullExpressionValue(v7, "it.key.location().toString()");
            v8 = ((net.minecraft.world.item.enchantment.Enchantment)it.getValue()).f_44672_;
            Intrinsics.checkNotNullExpressionValue(v8, "it.value.category");
            var12_10.add(new Enchantment(v7, ForgeGameAPIKt.access$toEnchantmentType(v8), ((net.minecraft.world.item.enchantment.Enchantment)it.getValue()).m_6586_(), ((net.minecraft.world.item.enchantment.Enchantment)it.getValue()).m_6589_(), 0, 16, null));
        }
        ForgeGameAPI.enchantments = (List)destination$iv$iv;
    }

    @Override
    public void logError(@Nullable String msg, @Nullable Exception error) {
        if (msg != null && error != null) {
            ForgeLuckyRegistry.INSTANCE.getLOGGER().error(msg, (Throwable)error);
        } else if (msg != null) {
            ForgeLuckyRegistry.INSTANCE.getLOGGER().error(msg);
        } else {
            ForgeLuckyRegistry.INSTANCE.getLOGGER().error((Object)error);
        }
    }

    @Override
    public void logInfo(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        ForgeLuckyRegistry.INSTANCE.getLOGGER().info(msg);
    }

    @Override
    @NotNull
    public List<String> getUsefulPotionIds() {
        return usefulPotionIds;
    }

    @Override
    @NotNull
    public List<String> getSpawnEggIds() {
        return spawnEggIds;
    }

    @Override
    @NotNull
    public List<Enchantment> getEnchantments() {
        return enchantments;
    }

    @Override
    @NotNull
    public List<StatusEffect> getUsefulStatusEffects() {
        return usefulStatusEffects;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> getRGBPalette() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ArraysKt.toList(DyeColor.values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DyeColor dyeColor = (DyeColor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            float[] c = it.m_41068_();
            collection.add(new Color(c[0], c[1], c[2]).getRGB());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public mod.lucky.common.Vec3<Double> getEntityPos(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        return new mod.lucky.common.Vec3<Number>(((Entity)entity).m_20185_(), ((Entity)entity).m_20186_(), ((Entity)entity).m_20189_());
    }

    @Override
    @NotNull
    public String getPlayerName(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = ((Player)player).m_7755_().getString();
        Intrinsics.checkNotNullExpressionValue(string, "player as MCPlayerEntity).name.string");
        return string;
    }

    @Override
    public void applyStatusEffect(@Nullable String target, @Nullable Object targetEntity, @NotNull String effectId, double durationSeconds, int amplifier) {
        int duration;
        Intrinsics.checkNotNullParameter(effectId, "effectId");
        MobEffect statusEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId));
        if (statusEffect == null) {
            Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Unknown status effect: " + effectId, null, 2, null);
            return;
        }
        int n = duration = statusEffect.m_8093_() ? 1 : (int)(durationSeconds * 20.0);
        if (targetEntity instanceof LivingEntity) {
            ((LivingEntity)targetEntity).m_7292_(new MobEffectInstance(statusEffect, duration, amplifier));
        }
    }

    @Override
    @Nullable
    public String convertStatusEffectId(int effectId) {
        String string;
        MobEffect effect;
        MobEffect mobEffect = effect = MobEffect.m_19453_((int)effectId);
        if (mobEffect != null) {
            MobEffect it = mobEffect;
            boolean bl = false;
            string = String.valueOf(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public List<Object> getLivingEntitiesInBox(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> boxMin, @NotNull mod.lucky.common.Vec3<Double> boxMax) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(boxMin, "boxMin");
        Intrinsics.checkNotNullParameter(boxMax, "boxMax");
        AABB box = new AABB(ForgeGameAPIKt.toMCVec3d(boxMin), ForgeGameAPIKt.toMCVec3d(boxMax));
        List list = ForgeGameAPIKt.toServerWorld(world).m_45976_(LivingEntity.class, box);
        Intrinsics.checkNotNullExpressionValue(list, "toServerWorld(world).get\u2026gEntity::class.java, box)");
        return list;
    }

    @Override
    public void setEntityOnFire(@NotNull Object entity, int durationSeconds) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        ((Entity)entity).m_20254_(durationSeconds);
    }

    @Override
    public void setEntityMotion(@NotNull Object entity, @NotNull mod.lucky.common.Vec3<Double> motion) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Intrinsics.checkNotNullParameter(motion, "motion");
        ((Entity)entity).m_20256_(ForgeGameAPIKt.toMCVec3d(motion));
        ((Entity)entity).f_19864_ = true;
        ((Entity)entity).f_19812_ = true;
    }

    @Override
    public long getWorldTime(@NotNull Object world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return ForgeGameAPIKt.toServerWorld(world).m_46468_();
    }

    @Override
    public double getPlayerHeadYawDeg(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((Player)player).f_20885_;
    }

    @Override
    public double getPlayerHeadPitchDeg(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((Player)player).m_146909_();
    }

    @Override
    public boolean isAirBlock(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Integer> pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        return ((LevelAccessor)world).m_46859_(ForgeGameAPIKt.toMCBlockPos(pos));
    }

    @Override
    public void spawnEntity(@NotNull Object world, @NotNull String id, @NotNull mod.lucky.common.Vec3<Double> pos, @NotNull DictAttr nbt, @Nullable DictAttr components, double rotation, boolean randomizeMob, @Nullable Object player, @NotNull String sourceId) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        DictAttr entityNBT = Intrinsics.areEqual(id, "lucky:lucky_projectile") && !nbt.contains("sourceId") ? nbt.with(MapsKt.mapOf(TuplesKt.to("sourceId", AttributeKt.stringAttrOf(sourceId)))) : nbt;
        Object object = JavaGameAPIKt.getJAVA_GAME_API().attrToNBT(nbt.with(MapsKt.mapOf(TuplesKt.to("id", AttributeKt.stringAttrOf(id)))));
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.nbt.CompoundTag{ mod.lucky.forge.ForgeGameAPIKt.CompoundTag }");
        CompoundTag mcEntityNBT = (CompoundTag)object;
        ServerLevel serverWorld = ForgeGameAPIKt.toServerWorld(world);
        Entity entity = EntityType.m_20645_((CompoundTag)mcEntityNBT, (Level)((Level)serverWorld), arg_0 -> ForgeGameAPI.spawnEntity$lambda$8(rotation, pos, serverWorld, arg_0));
        if (entity == null) {
            return;
        }
        Entity entity2 = entity;
        if (entity2 instanceof FallingBlockEntity && !entityNBT.contains("Time")) {
            ((FallingBlockEntity)entity2).f_31942_ = 1;
        }
        if (player != null && entity2 instanceof Arrow) {
            ((Arrow)entity2).m_5602_((Entity)player);
        }
        if (entity2 instanceof Mob && randomizeMob && !entityNBT.contains("Passengers")) {
            ((Mob)entity2).m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(ForgeGameAPIKt.toMCBlockPos(pos.floor())), MobSpawnType.EVENT, null, null);
            ((Mob)entity2).m_7378_(mcEntityNBT);
        }
    }

    @Override
    @Nullable
    public Object getNearestPlayer(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        CommandSourceStack commandSource = ForgeGameAPIKt.createCommandSource$default((ServerLevel)world, pos, null, false, 4, null);
        return new EntitySelectorParser(new StringReader("@p")).m_121377_().m_121163_(commandSource);
    }

    @Override
    public void scheduleDrop(@NotNull SingleDrop drop, @NotNull DropContext context, double seconds) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        ServerLevel world = ForgeGameAPIKt.toServerWorld(context.getWorld());
        DelayedDrop delayedDrop = new DelayedDrop(null, (Level)world, new DelayedDropData(drop, context, (int)(seconds * (double)20)), 1, null);
        delayedDrop.m_6034_(context.getPos().getX(), context.getPos().getY(), context.getPos().getZ());
        world.m_7967_((Entity)delayedDrop);
    }

    @Override
    public void setBlock(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Integer> pos, @NotNull String id, @Nullable DictAttr state, @Nullable DictAttr components, int rotation, boolean notify) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(id, "id");
        Pair[] pairArray = new Pair[]{TuplesKt.to("Name", AttributeKt.stringAttrOf(id)), TuplesKt.to("Properties", state)};
        Object object = JavaGameAPIKt.getJAVA_GAME_API().attrToNBT(AttributeKt.dictAttrOf(pairArray));
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.nbt.CompoundTag{ mod.lucky.forge.ForgeGameAPIKt.CompoundTag }");
        CompoundTag blockStateNBT = (CompoundTag)object;
        BlockState mcBlockState = NbtUtils.m_247651_((HolderGetter)((HolderGetter)((LevelAccessor)world).m_246945_(Registries.f_256747_)), (CompoundTag)blockStateNBT).rotate((LevelAccessor)world, ForgeGameAPIKt.toMCBlockPos(pos), Rotation.values()[rotation]);
        ((LevelAccessor)world).m_7731_(ForgeGameAPIKt.toMCBlockPos(pos), mcBlockState, notify ? 3 : 2);
    }

    @Override
    public void setBlockEntity(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Integer> pos, @NotNull DictAttr nbt) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        BlockPos mcPos = ForgeGameAPIKt.toMCBlockPos(pos);
        BlockEntity blockEntity = ((ServerLevelAccessor)world).m_7702_(mcPos);
        if (blockEntity != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("x", AttributeKt.intAttrOf(pos.getX())), TuplesKt.to("y", AttributeKt.intAttrOf(pos.getY())), TuplesKt.to("z", AttributeKt.intAttrOf(pos.getZ()))};
            DictAttr fullNBT = nbt.with(MapsKt.mapOf(pairArray));
            Object object = JavaGameAPIKt.getJAVA_GAME_API().attrToNBT(fullNBT);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.nbt.CompoundTag{ mod.lucky.forge.ForgeGameAPIKt.CompoundTag }");
            blockEntity.m_142466_((CompoundTag)object);
            blockEntity.m_6596_();
        }
    }

    @Override
    public void dropItem(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, @NotNull String id, @Nullable DictAttr nbt, @Nullable DictAttr components) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(id, "id");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
        if (item == null) {
            Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Invalid item ID: '" + id + "'", null, 2, null);
            return;
        }
        ItemStack itemStack = new ItemStack((ItemLike)item, 1);
        if (nbt != null) {
            Object object = JavaGameAPIKt.getJAVA_GAME_API().attrToNBT(nbt);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.minecraft.nbt.CompoundTag{ mod.lucky.forge.ForgeGameAPIKt.CompoundTag }");
            itemStack.m_41751_((CompoundTag)object);
        }
        Block.m_49840_((Level)((Level)ForgeGameAPIKt.toServerWorld(world)), (BlockPos)ForgeGameAPIKt.toMCBlockPos(pos.floor()), (ItemStack)itemStack);
    }

    @Override
    public void runCommand(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, @NotNull String command, @NotNull String senderName, boolean showOutput) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(senderName, "senderName");
        try {
            CommandSourceStack commandSource = ForgeGameAPIKt.access$createCommandSource(ForgeGameAPIKt.toServerWorld(world), pos, senderName, showOutput);
            String string = command.substring(1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            String commandWithoutPrefix = string;
            ParseResults parsedCommand = commandSource.m_81377_().m_129892_().m_82094_().parse(commandWithoutPrefix, (Object)commandSource);
            commandSource.m_81377_().m_129892_().m_242674_(parsedCommand, commandWithoutPrefix);
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Invalid command: " + command, e);
        }
    }

    @Override
    public void sendMessage(@NotNull Object player, @NotNull String message) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(message, "message");
        ((Player)player).m_5661_((Component)Component.m_237113_((String)message), false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setDifficulty(@NotNull Object world, @NotNull String difficulty) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(world, "world");
                Intrinsics.checkNotNullParameter(difficulty, "difficulty");
                var4_3 = difficulty;
                switch (var4_3.hashCode()) {
                    case -1039745817: {
                        if (!var4_3.equals("normal")) {
                            ** break;
                        }
                        break block6;
                    }
                    case 3105794: {
                        if (var4_3.equals("easy")) break;
                        ** break;
                    }
                    case -58612657: {
                        if (!var4_3.equals("peaceful")) ** break;
                        v0 = Difficulty.PEACEFUL;
                        break block7;
                    }
                }
                v0 = Difficulty.EASY;
                break block7;
            }
            v0 = Difficulty.NORMAL;
            break block7;
lbl21:
            // 4 sources

            v0 = Difficulty.HARD;
        }
        difficultyEnum = v0;
        ForgeGameAPIKt.toServerWorld(world).m_7654_().m_129827_(difficultyEnum, false);
    }

    @Override
    public void setTime(@NotNull Object world, long time) {
        Intrinsics.checkNotNullParameter(world, "world");
        ForgeGameAPIKt.toServerWorld(world).m_8615_(time);
    }

    @Override
    public void playSound(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, @NotNull String id, double volume, double pitch) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(id, "id");
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(id));
        if (soundEvent == null) {
            Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Invalid sound event: " + id, null, 2, null);
            return;
        }
        ForgeGameAPIKt.toServerWorld(world).m_6263_(null, ((Number)pos.getX()).doubleValue(), ((Number)pos.getY()).doubleValue(), ((Number)pos.getZ()).doubleValue(), soundEvent, SoundSource.BLOCKS, (float)volume, (float)pitch);
    }

    @Override
    public void spawnParticle(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, @NotNull String id, @NotNull List<String> args2, @NotNull mod.lucky.common.Vec3<Double> boxSize, int amount) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(boxSize, "boxSize");
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(id));
        if (particleType == null) {
            Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Invalid partical: " + id, null, 2, null);
            return;
        }
        try {
            ParticleOptions particleOptions;
            try {
                particleOptions = particleType.m_123743_().m_5739_(particleType, new StringReader(" " + CollectionsKt.joinToString$default(args2, " ", null, null, 0, null, null, 62, null)));
            }
            catch (CommandSyntaxException e) {
                GameAPIKt.getGAME_API().logError("Error processing partice '" + id + "' with arguments '" + args2 + "'", (Exception)((Object)e));
                return;
            }
            ParticleOptions particleData = particleOptions;
            ForgeGameAPIKt.toServerWorld(world).m_8767_(particleData, ((Number)pos.getX()).doubleValue(), ((Number)pos.getY()).doubleValue(), ((Number)pos.getZ()).doubleValue(), amount, ((Number)boxSize.getX()).doubleValue(), ((Number)boxSize.getY()).doubleValue(), ((Number)boxSize.getZ()).doubleValue(), 0.0);
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Invalid partical arguments: " + args2, e);
            return;
        }
    }

    @Override
    public void playParticleEvent(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, int eventId, int data) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        ForgeGameAPIKt.toServerWorld(world).m_46796_(eventId, ForgeGameAPIKt.toMCBlockPos(pos.floor()), data);
    }

    @Override
    public void playSplashPotionEvent(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, @Nullable String potionName, @Nullable Integer potionColor) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        if (potionName != null) {
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
            if (potion == null) {
                Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Invalid splash potion name: " + potionName, null, 2, null);
                return;
            }
            int color = PotionUtils.m_43564_((Collection)potion.m_43488_());
            this.playParticleEvent(world, pos, potion.m_43491_() ? 2007 : 2002, color);
        } else if (potionColor != null) {
            this.playParticleEvent(world, pos, 2002, potionColor);
        }
    }

    @Override
    public void createExplosion(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Double> pos, double damage, boolean fire) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        ForgeGameAPIKt.toServerWorld(world).m_255391_(null, ((Number)pos.getX()).doubleValue(), ((Number)pos.getY()).doubleValue(), ((Number)pos.getZ()).doubleValue(), (float)damage, fire, Level.ExplosionInteraction.BLOCK);
    }

    @Override
    public void createStructure(@NotNull Object world, @NotNull String structureId, @NotNull mod.lucky.common.Vec3<Integer> pos, @NotNull mod.lucky.common.Vec3<Integer> centerOffset, int rotation, @NotNull String mode, boolean notify) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(structureId, "structureId");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(centerOffset, "centerOffset");
        Intrinsics.checkNotNullParameter(mode, "mode");
        Object nbtStructure = JavaLuckyRegistry.INSTANCE.getNbtStructures().get(structureId);
        if (nbtStructure == null) {
            Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Missing structure '" + structureId + "'", null, 2, null);
            return;
        }
        StructureProcessor processor2 = new StructureProcessor(mode){
            final /* synthetic */ String $mode;
            {
                this.$mode = $mode;
            }

            @NotNull
            public StructureTemplate.StructureBlockInfo process(@NotNull LevelReader world, @NotNull BlockPos oldPos, @NotNull BlockPos newPos, @NotNull StructureTemplate.StructureBlockInfo oldBlockInfo, @NotNull StructureTemplate.StructureBlockInfo newBlockInfo, @NotNull StructurePlaceSettings settings, @Nullable StructureTemplate template) {
                BlockState blockState;
                Intrinsics.checkNotNullParameter(world, "world");
                Intrinsics.checkNotNullParameter(oldPos, "oldPos");
                Intrinsics.checkNotNullParameter(newPos, "newPos");
                Intrinsics.checkNotNullParameter(oldBlockInfo, "oldBlockInfo");
                Intrinsics.checkNotNullParameter(newBlockInfo, "newBlockInfo");
                Intrinsics.checkNotNullParameter(settings, "settings");
                JavaGameAPI javaGameAPI = JavaGameAPIKt.getJAVA_GAME_API();
                Block block = newBlockInfo.f_74676_().m_60734_();
                Intrinsics.checkNotNullExpressionValue(block, "newBlockInfo.state.block");
                String string = javaGameAPI.getBlockId(block);
                if (string == null) {
                    return newBlockInfo;
                }
                String blockId = string;
                String blockIdWithMode = DropActionsKt.withBlockMode(this.$mode, blockId);
                if (Intrinsics.areEqual(blockIdWithMode, blockId)) {
                    return newBlockInfo;
                }
                if (blockIdWithMode == null) {
                    blockState = world.m_8055_(newBlockInfo.f_74675_());
                } else {
                    Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockIdWithMode));
                    Object object = block2 != null ? block2.m_49966_() : null;
                    blockState = object;
                    Intrinsics.checkNotNull(object);
                }
                BlockState newState = blockState;
                return Intrinsics.areEqual(newState, newBlockInfo.f_74676_()) ? newBlockInfo : new StructureTemplate.StructureBlockInfo(newBlockInfo.f_74675_(), newState, newBlockInfo.f_74677_());
            }

            @NotNull
            protected StructureProcessorType<?> m_6953_() {
                StructureProcessorType structureProcessorType = StructureProcessorType.f_74456_;
                Intrinsics.checkNotNullExpressionValue(structureProcessorType, "BLOCK_IGNORE");
                return structureProcessorType;
            }
        };
        Rotation mcRotation = Rotation.values()[rotation];
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().m_74379_(mcRotation).m_74385_(ForgeGameAPIKt.toMCBlockPos(centerOffset)).m_74392_(false).m_74383_(processor2);
        Intrinsics.checkNotNullExpressionValue(structurePlaceSettings, "StructurePlaceSettings()\u2026 .addProcessor(processor)");
        StructurePlaceSettings placementSettings = structurePlaceSettings;
        BlockPos mcCornerPos = ForgeGameAPIKt.toMCBlockPos(pos.minus(centerOffset));
        ((StructureTemplate)nbtStructure).m_230328_((ServerLevelAccessor)world, mcCornerPos, mcCornerPos, placementSettings, RandomSource.m_216327_(), notify ? 3 : 2);
    }

    private static final Entity spawnEntity$lambda$8(double $rotation, mod.lucky.common.Vec3 $pos, ServerLevel $serverWorld, Entity entity) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter($pos, "$pos");
        Intrinsics.checkNotNullParameter($serverWorld, "$serverWorld");
        double entityRotation = UtilsKt.positiveMod($rotation + 2.0, 4.0);
        double rotationDeg = entityRotation * 90.0;
        double yaw = UtilsKt.positiveMod((double)entity.m_146908_() + entityRotation, 360.0);
        if (entityRotation == 0.0) {
            vec3 = entity.m_20184_();
        } else {
            Vec3 vec32 = entity.m_20184_();
            Intrinsics.checkNotNullExpressionValue(vec32, "entity.deltaMovement");
            vec3 = ForgeGameAPIKt.toMCVec3d(UtilsKt.rotateVec3d(ForgeGameAPIKt.toVec3d(vec32), UtilsKt.degToRad(rotationDeg)));
        }
        Vec3 velocity = vec3;
        entity.m_19890_(((Number)$pos.getX()).doubleValue(), ((Number)$pos.getY()).doubleValue(), ((Number)$pos.getZ()).doubleValue(), (float)yaw, entity.m_146909_());
        entity.m_5616_((float)yaw);
        entity.m_20256_(velocity);
        return $serverWorld.m_7967_(entity) ? entity : null;
    }
}

