/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.common.drop.action;

import java.util.List;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.action.DropActionsKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\u0006\u0010\r\u001a\u00020\t\u001a.\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"applyEffect", "", "drop", "Lmod/lucky/common/drop/SingleDrop;", "dropPos", "Lmod/lucky/common/Vec3;", "", "Lmod/lucky/common/Vec3d;", "target", "", "targetEntity", "", "Lmod/lucky/common/Entity;", "effectId", "applyKnockbackEffect", "doEffectDrop", "context", "Lmod/lucky/common/drop/DropContext;", "common"})
public final class EffectDropKt {
    private static final void applyKnockbackEffect(SingleDrop drop, Vec3<Double> dropPos, Object targetEntity) {
        Vec3<Double> entityPos = GameAPIKt.getGAME_API().getEntityPos(targetEntity);
        boolean isClose = UtilsKt.distanceBetween(dropPos, GameAPIKt.getGAME_API().getEntityPos(targetEntity)) < 0.01;
        double yawRad = drop.contains("directionYaw") ? UtilsKt.degToRad(((Number)SingleDrop.get$default(drop, "directionYaw", null, 2, null)).doubleValue()) : Math.atan2((entityPos.getX() - dropPos.getX()) * (double)-1, entityPos.getZ() - dropPos.getZ());
        double pitchRad = UtilsKt.degToRad(!drop.contains("target") && isClose ? -90.0 : ((Number)SingleDrop.get$default(drop, "directionPitch", null, 2, null)).doubleValue());
        double power = !drop.contains("target") && isClose ? ((Number)SingleDrop.get$default(drop, "power", null, 2, null)).doubleValue() * 0.5 : ((Number)SingleDrop.get$default(drop, "power", null, 2, null)).doubleValue();
        Vec3<Double> motion = UtilsKt.directionToVelocity(yawRad, pitchRad, power);
        GameAPIKt.getGAME_API().setEntityMotion(targetEntity, motion);
    }

    public static final void applyEffect(@NotNull SingleDrop drop, @NotNull Vec3<Double> dropPos, @Nullable String target, @Nullable Object targetEntity, @NotNull String effectId) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(dropPos, "dropPos");
        Intrinsics.checkNotNullParameter(effectId, "effectId");
        String string = effectId;
        if (Intrinsics.areEqual(string, "special_fire")) {
            if (targetEntity == null) {
                throw new Exception("Entity required");
            }
            GameAPIKt.getGAME_API().setEntityOnFire(targetEntity, ((Number)SingleDrop.get$default(drop, "duration", null, 2, null)).intValue());
        } else if (Intrinsics.areEqual(string, "special_knockback")) {
            if (targetEntity == null) {
                throw new Exception("Entity required");
            }
            EffectDropKt.applyKnockbackEffect(drop, dropPos, targetEntity);
        } else {
            GameAPIKt.getGAME_API().applyStatusEffect(target, targetEntity, effectId, ((Number)SingleDrop.get$default(drop, "duration", null, 2, null)).doubleValue(), ((Number)SingleDrop.get$default(drop, "amplifier", null, 2, null)).intValue());
        }
    }

    public static final void doEffectDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        String effectId;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3 pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null);
        Pair<String, Object> pair = drop.contains("target") && !drop.contains("range") ? (Intrinsics.areEqual(string2 = (String)SingleDrop.get$default(drop, "target", null, 2, null), "player") ? new Pair<String, Object>("player", context.getPlayer()) : (Intrinsics.areEqual(string2, "hitEntity") ? new Pair<String, Object>("hitEntity", context.getHitEntity()) : new Pair<String, Object>("player", null))) : (!drop.contains("target") && !drop.contains("range") ? new Pair<String, Object>("player", context.getPlayer()) : new Pair<String, Object>(null, null));
        String target = (String)pair.component1();
        Object targetEntity = pair.component2();
        if (Intrinsics.areEqual(target, "hitEntity") && targetEntity == null) {
            return;
        }
        String dropId = (String)SingleDrop.get$default(drop, "id", null, 2, null);
        if (Intrinsics.areEqual(dropId, "special_fire")) {
            string = dropId;
        } else if (Intrinsics.areEqual(dropId, "special_knockback")) {
            string = dropId;
        } else {
            String string3;
            try {
                int intId = Integer.parseInt(dropId);
                String string4 = GameAPIKt.getGAME_API().convertStatusEffectId(intId);
                if (string4 == null) {
                    string4 = dropId;
                }
                string3 = string4;
            }
            catch (NumberFormatException e) {
                string3 = dropId;
            }
            string = effectId = string3;
        }
        if (target != null || targetEntity != null) {
            EffectDropKt.applyEffect(drop, pos, target, targetEntity, effectId);
        } else {
            double range = ((Number)SingleDrop.get$default(drop, "range", null, 2, null)).doubleValue();
            Vec3<Number> effectBoxMin = pos.minus(new Vec3<Number>(range, range, range));
            Vec3<Number> effectBoxMax = pos.plus(new Vec3<Number>(range, range, range));
            List<Object> entities = GameAPIKt.getGAME_API().getLivingEntitiesInBox(context.getWorld(), effectBoxMin, effectBoxMax);
            for (Object entity : entities) {
                double distance;
                if (((Boolean)SingleDrop.get$default(drop, "excludePlayer", null, 2, null)).booleanValue() && Intrinsics.areEqual(entity, context.getPlayer()) || !((distance = UtilsKt.distanceBetween(pos, GameAPIKt.getGAME_API().getEntityPos(entity))) <= range)) continue;
                EffectDropKt.applyEffect(drop, pos, target, entity, effectId);
            }
        }
    }
}

