/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.LinkedHashMap;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

@NothingNullByDefault
public abstract class EnchantmentBasedModule<MODULE extends EnchantmentBasedModule<MODULE>>
implements ICustomModule<MODULE> {
    public abstract Enchantment getEnchantment();

    @Override
    public void onAdded(IModule<MODULE> module, boolean first) {
        if (module.isEnabled()) {
            if (first) {
                this.enchant(module, this.getEnchantment());
            } else {
                Map<Enchantment, Integer> enchantments = this.getEnchantments(module);
                enchantments.put(this.getEnchantment(), module.getInstalledCount());
                this.setEnchantments(module, enchantments);
            }
        }
    }

    @Override
    public void onRemoved(IModule<MODULE> module, boolean last) {
        if (module.isEnabled()) {
            Map<Enchantment, Integer> enchantments = this.getEnchantments(module);
            if (last) {
                enchantments.remove(this.getEnchantment());
            } else {
                enchantments.put(this.getEnchantment(), module.getInstalledCount());
            }
            this.setEnchantments(module, enchantments);
        }
    }

    @Override
    public void onEnabledStateChange(IModule<MODULE> module) {
        if (module.isEnabled()) {
            this.enchant(module, this.getEnchantment());
        } else {
            Map<Enchantment, Integer> enchantments = this.getEnchantments(module);
            enchantments.remove(this.getEnchantment());
            this.setEnchantments(module, enchantments);
        }
    }

    private void enchant(IModule<MODULE> module, Enchantment enchantment) {
        ListTag enchantments;
        CompoundTag dataMap = this.getOrCreateDataTag(module);
        if (dataMap.m_128425_("Enchantments", 9)) {
            enchantments = dataMap.m_128437_("Enchantments", 10);
        } else {
            enchantments = new ListTag();
            dataMap.m_128365_("Enchantments", (Tag)enchantments);
        }
        enchantments.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)EnchantmentHelper.m_182432_((Enchantment)enchantment), (int)((byte)module.getInstalledCount())));
    }

    private Map<Enchantment, Integer> getEnchantments(IModule<MODULE> module) {
        CompoundTag tag = module.getContainer().m_41783_();
        if (tag != null && tag.m_128425_("mekData", 10)) {
            CompoundTag mekData = tag.m_128469_("mekData");
            ListTag enchantmentTag = mekData.m_128437_("Enchantments", 10);
            return EnchantmentHelper.m_44882_((ListTag)enchantmentTag);
        }
        return new LinkedHashMap<Enchantment, Integer>();
    }

    private CompoundTag getOrCreateDataTag(IModule<MODULE> module) {
        CompoundTag tag = module.getContainer().m_41784_();
        if (tag.m_128425_("mekData", 10)) {
            return tag.m_128469_("mekData");
        }
        CompoundTag dataMap = new CompoundTag();
        tag.m_128365_("mekData", (Tag)dataMap);
        return dataMap;
    }

    private void setEnchantments(IModule<MODULE> module, Map<Enchantment, Integer> enchantments) {
        ListTag enchantmentTag = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            enchantmentTag.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)EnchantmentHelper.m_182432_((Enchantment)enchantment), (int)entry.getValue()));
        }
        CompoundTag dataMap = this.getOrCreateDataTag(module);
        if (enchantments.isEmpty()) {
            dataMap.m_128473_("Enchantments");
            if (dataMap.m_128456_()) {
                module.getContainer().m_41749_("mekData");
            }
        } else {
            dataMap.m_128365_("Enchantments", (Tag)enchantmentTag);
        }
    }
}

