/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FacadeBlockWorld
extends DummyWorld {
    public final BlockPos pos;
    public final BlockState state;
    public final BlockEntity tile;

    public FacadeBlockWorld(Level world, BlockPos pos, BlockState state, BlockEntity tile) {
        super(world);
        this.pos = pos;
        this.state = state;
        this.tile = tile;
    }

    @Override
    @Nullable
    public BlockEntity m_7702_(@Nonnull BlockPos pPos) {
        return pPos.equals((Object)this.pos) ? this.tile : this.getLevel().m_7702_(pPos);
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nonnull
    public BlockState m_8055_(BlockPos pPos) {
        return pPos.equals((Object)this.pos) ? this.state : this.getLevel().m_8055_(pPos);
    }

    @Override
    @Nonnull
    public LevelLightEngine m_5518_() {
        return this.getLevel().m_5518_();
    }

    @Override
    public int m_45517_(@Nonnull LightLayer lightType, @Nonnull BlockPos pos) {
        return this.getLevel().m_45517_(lightType, pos);
    }

    public int m_6171_(@Nonnull BlockPos blockPos, @Nonnull ColorResolver colorResolver) {
        return this.getLevel().m_6171_(blockPos, colorResolver);
    }

    @Override
    public boolean m_45527_(@Nonnull BlockPos pos) {
        return this.getLevel().m_45527_(pos);
    }

    @Nonnull
    public DimensionType m_6042_() {
        return this.getLevel().m_6042_();
    }

    public boolean m_46859_(@Nonnull BlockPos pPos) {
        return !pPos.equals((Object)this.pos) && this.getLevel().m_46859_(pPos);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Holder<Biome> m_204166_(@Nonnull BlockPos pos) {
        return this.getLevel().m_204166_(pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setParticleManager(@Nonnull ParticleManager particleManager) {
        super.setParticleManager(particleManager);
        Level level = this.getLevel();
        if (level instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)level;
            dummyWorld.setParticleManager(particleManager);
        }
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ParticleManager getParticleManager() {
        Level level;
        ParticleManager particleManager = super.getParticleManager();
        if (particleManager == null && (level = this.getLevel()) instanceof DummyWorld) {
            DummyWorld dummyWorld = (DummyWorld)level;
            return dummyWorld.getParticleManager();
        }
        return particleManager;
    }
}

