/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemTransferList
implements IItemTransfer,
ITagSerializable<CompoundTag> {
    public final IItemTransfer[] transfers;
    protected Predicate<ItemStack> filter = item -> true;

    public ItemTransferList(IItemTransfer ... transfers) {
        this.transfers = transfers;
    }

    public ItemTransferList(List<IItemTransfer> transfers) {
        this.transfers = (IItemTransfer[])transfers.toArray(IItemTransfer[]::new);
    }

    @Override
    public int getSlots() {
        return Arrays.stream(this.transfers).mapToInt(IItemTransfer::getSlots).sum();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.getStackInSlot(slot - index);
            }
            index += transfer.getSlots();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                transfer.setStackInSlot(slot - index, stack);
                return;
            }
            index += transfer.getSlots();
        }
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
        if (!this.filter.test(stack)) {
            return stack;
        }
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.insertItem(slot - index, stack, simulate, notifyChanges);
            }
            index += transfer.getSlots();
        }
        return stack;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.extractItem(slot - index, amount, simulate, notifyChanges);
            }
            index += transfer.getSlots();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getSlotLimit(int slot) {
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.getSlotLimit(slot - index);
            }
            index += transfer.getSlots();
        }
        return 0;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (!this.filter.test(stack)) {
            return false;
        }
        int index = 0;
        for (IItemTransfer transfer : this.transfers) {
            if (slot - index < transfer.getSlots()) {
                return transfer.isItemValid(slot - index, stack);
            }
            index += transfer.getSlots();
        }
        return false;
    }

    @Override
    public final void onContentsChanged() {
        for (IItemTransfer transfer : this.transfers) {
            transfer.onContentsChanged();
        }
    }

    @Override
    @NotNull
    public Object createSnapshot() {
        return Arrays.stream(this.transfers).map(IItemTransfer::createSnapshot).toArray(Object[]::new);
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        Object[] array;
        if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.transfers.length) {
            for (int i = 0; i < array.length; ++i) {
                this.transfers[i].restoreFromSnapshot(array[i]);
            }
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (IItemTransfer transfer : this.transfers) {
            if (transfer instanceof ITagSerializable) {
                ITagSerializable serializable = (ITagSerializable)((Object)transfer);
                list.add(serializable.serializeNBT());
                continue;
            }
            LDLib.LOGGER.warn("[ItemTransferList] internal container doesn't support serialization");
        }
        tag.m_128365_("slots", (Tag)list);
        tag.m_128344_("type", list.m_7264_());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("slots", (int)nbt.m_128445_("type"));
        for (int i = 0; i < list.size(); ++i) {
            IItemTransfer iItemTransfer = this.transfers[i];
            if (iItemTransfer instanceof ITagSerializable) {
                ITagSerializable serializable = (ITagSerializable)((Object)iItemTransfer);
                serializable.deserializeNBT(list.get(i));
                continue;
            }
            LDLib.LOGGER.warn("[ItemTransferList] internal container doesn't support serialization");
        }
    }

    public void setFilter(Predicate<ItemStack> filter) {
        this.filter = filter;
    }
}

