/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor;

import com.lowdragmc.lowdraglib.gui.widget.codeeditor.Cursor;

public class Selection {
    private Cursor start;
    private Cursor end;
    private boolean isSelecting = false;

    public Selection(Cursor start, Cursor end) {
        this.start = start;
        this.end = end;
    }

    public void updateEnd(Cursor newEnd) {
        this.end = newEnd;
    }

    public boolean hasSelection() {
        return this.start != null && this.end != null && !this.start.equals(this.end);
    }

    public int[] getSelectionRange() {
        int endColumn;
        int startLine = Math.min(this.start.line(), this.end.line());
        int endLine = Math.max(this.start.line(), this.end.line());
        int startColumn = this.start.line() == startLine ? this.start.column() : this.end.column();
        int n = endColumn = this.end.line() == endLine ? this.end.column() : this.start.column();
        if (startLine == endLine) {
            startColumn = Math.min(this.start.column(), this.end.column());
            endColumn = Math.max(this.start.column(), this.end.column());
        }
        return new int[]{startLine, startColumn, endLine, endColumn};
    }

    public void clear() {
        this.start = new Cursor(this.end.line(), this.end.column());
    }

    public Cursor getStart() {
        return this.start;
    }

    public Cursor getEnd() {
        return this.end;
    }

    public boolean isSelecting() {
        return this.isSelecting;
    }

    public void setSelecting(boolean isSelecting) {
        this.isSelecting = isSelecting;
    }
}

