/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.modular;

import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerMenuAccessor;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.WidgetUIAccess;
import com.lowdragmc.lowdraglib.gui.util.PerTickIntCounter;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.c2s.CPacketUIClientAction;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ModularUIContainer
extends AbstractContainerMenu
implements WidgetUIAccess {
    public static final MenuType<ModularUIContainer> MENUTYPE = new MenuType((i, inventory) -> new ModularUIContainer(i), FeatureFlags.f_244332_);
    private final ModularUI modularUI;
    private final PerTickIntCounter transferredPerTick = new PerTickIntCounter(0);

    public ModularUIContainer(ModularUI modularUI, int windowID) {
        super(MENUTYPE, windowID);
        this.modularUI = modularUI;
        this.modularUI.setModularUIContainer(this);
        modularUI.mainGroup.setUiAccess(this);
    }

    private ModularUIContainer(int windowID) {
        super(null, windowID);
        this.modularUI = null;
    }

    @Nonnull
    public Slot m_38897_(@Nonnull Slot slotHandle) {
        OptionalInt emptySlotIndex = this.f_38839_.stream().filter(it -> it instanceof EmptySlotPlaceholder).mapToInt(slot -> slot.f_40219_).findFirst();
        if (emptySlotIndex.isPresent()) {
            slotHandle.f_40219_ = emptySlotIndex.getAsInt();
            this.f_38839_.set(slotHandle.f_40219_, (Object)slotHandle);
            ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().set(slotHandle.f_40219_, (Object)ItemStack.f_41583_);
            ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().set(slotHandle.f_40219_, (Object)ItemStack.f_41583_);
        } else {
            slotHandle.f_40219_ = this.f_38839_.size();
            this.f_38839_.add((Object)slotHandle);
            ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().add((Object)ItemStack.f_41583_);
            ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().add((Object)ItemStack.f_41583_);
        }
        return slotHandle;
    }

    public void removeSlot(Slot slotHandle) {
        EmptySlotPlaceholder emptySlotPlaceholder = new EmptySlotPlaceholder();
        emptySlotPlaceholder.f_40219_ = slotHandle.f_40219_;
        this.f_38839_.set(slotHandle.f_40219_, (Object)emptySlotPlaceholder);
        ((AbstractContainerMenuAccessor)((Object)this)).getLastSlots().set(slotHandle.f_40219_, (Object)ItemStack.f_41583_);
        ((AbstractContainerMenuAccessor)((Object)this)).getRemoteSlots().set(slotHandle.f_40219_, (Object)ItemStack.f_41583_);
    }

    public ModularUI getModularUI() {
        return this.modularUI;
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.modularUI.triggerCloseListeners();
    }

    public void m_38893_(@Nonnull ContainerListener pListener) {
        super.m_38893_(pListener);
        this.modularUI.mainGroup.detectAndSendChanges();
    }

    public void m_38946_() {
        Player player;
        super.m_38946_();
        if (this.modularUI.holder.isInvalid() && (player = this.modularUI.entityPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_6915_();
        }
        this.modularUI.mainGroup.detectAndSendChanges();
        this.modularUI.addTick();
    }

    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (slotId >= 0 && slotId < this.f_38839_.size()) {
            Slot slot = this.m_38853_(slotId);
            ItemStack result = this.modularUI.getSlotMap().get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == null) {
                super.m_150399_(slotId, dragType, clickTypeIn, player);
            }
        }
        if (slotId == -999) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    private List<SlotWidget> getShiftClickSlots(ItemStack itemStack, boolean fromContainer) {
        return this.modularUI.getSlotMap().values().stream().filter(it -> it.canMergeSlot(itemStack)).filter(it -> it.isPlayerContainer == fromContainer).sorted(Comparator.comparing(s -> (fromContainer ? -1 : 1) * s.getHandler().f_40219_)).collect(Collectors.toList());
    }

    @Override
    public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
        List<Slot> slots = this.getShiftClickSlots(itemStack, fromContainer).stream().map(SlotWidget::getHandler).collect(Collectors.toList());
        return ModularUIContainer.mergeItemStack(itemStack, slots, simulate);
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots, boolean simulate) {
        if (itemStack.m_41619_()) {
            return false;
        }
        boolean merged = false;
        for (Slot slot : slots) {
            ItemStack stackInSlot;
            if (!slot.m_5857_(itemStack) || !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)(stackInSlot = slot.m_7993_())) || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stackInSlot)) continue;
            int slotMaxStackSize = Math.min(stackInSlot.m_41741_(), slot.m_5866_(stackInSlot));
            int amountToInsert = Math.min(itemStack.m_41613_(), slotMaxStackSize - stackInSlot.m_41613_());
            if (amountToInsert == 0) continue;
            if (!simulate) {
                stackInSlot.m_41769_(amountToInsert);
            }
            itemStack.m_41774_(amountToInsert);
            slot.m_6654_();
            merged = true;
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        for (Slot slot : slots) {
            int amountToInsert;
            if (!slot.m_5857_(itemStack) || slot.m_6657_() || (amountToInsert = Math.min(itemStack.m_41613_(), slot.m_5866_(itemStack))) == 0) continue;
            ItemStack stackInSlot = itemStack.m_41620_(amountToInsert);
            if (!simulate) {
                slot.m_5852_(stackInSlot);
            }
            merged = true;
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return merged;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        boolean fromContainer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_8010_(player)) {
            return ItemStack.f_41583_;
        }
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack stackToMerge = stackInSlot.m_41777_();
        boolean bl = fromContainer = !this.modularUI.getSlotMap().get((Object)slot).isPlayerContainer;
        if (!this.attemptMergeStack(stackToMerge, fromContainer, true)) {
            return ItemStack.f_41583_;
        }
        int itemsMerged = stackToMerge.m_41619_() || this.modularUI.getSlotMap().get(slot).canMergeSlot(stackToMerge) ? stackInSlot.m_41613_() - stackToMerge.m_41613_() : stackInSlot.m_41613_();
        int itemsToExtract = itemsMerged;
        if ((itemsMerged += this.transferredPerTick.get(player.m_9236_())) > stackInSlot.m_41741_()) {
            return ItemStack.f_41583_;
        }
        this.transferredPerTick.increment(player.m_9236_(), itemsToExtract);
        ItemStack extractedStack = stackInSlot.m_41620_(itemsToExtract);
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        ItemStack resultStack = extractedStack.m_41777_();
        if (!this.attemptMergeStack(extractedStack, fromContainer, false)) {
            resultStack = ItemStack.f_41583_;
        }
        if (!extractedStack.m_41619_()) {
            player.m_7197_(extractedStack, false, false);
            resultStack = ItemStack.f_41583_;
        }
        return resultStack;
    }

    public boolean m_5882_(@Nonnull ItemStack stack, @Nonnull Slot slotIn) {
        return this.modularUI.getSlotMap().get(slotIn).canMergeSlot(stack);
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<FriendlyByteBuf> payloadWriter) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.m_130130_(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof AbstractClientPlayer) {
            LDLNetworking.NETWORK.sendToServer(new CPacketUIClientAction(this.f_38840_, packetBuffer));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<FriendlyByteBuf> payloadWriter) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.m_130130_(updateId);
        payloadWriter.accept(packetBuffer);
        if (this.modularUI.entityPlayer instanceof ServerPlayer) {
            SPacketUIWidgetUpdate widgetUpdate = new SPacketUIWidgetUpdate(this.f_38840_, packetBuffer);
            LDLNetworking.NETWORK.sendToPlayer(widgetUpdate, (ServerPlayer)this.modularUI.entityPlayer);
        }
    }

    public void handleClientAction(CPacketUIClientAction packet) {
        if (packet.windowId == this.f_38840_) {
            int updateId = packet.updateData.m_130242_();
            this.modularUI.mainGroup.handleClientAction(updateId, packet.updateData);
        }
    }

    private static class EmptySlotPlaceholder
    extends Slot {
        private static final Container EMPTY_INVENTORY = new SimpleContainer(0);

        public EmptySlotPlaceholder() {
            super(EMPTY_INVENTORY, 0, -100000, -100000);
        }

        @Nonnull
        public ItemStack m_7993_() {
            return ItemStack.f_41583_;
        }

        public void m_5852_(@Nonnull ItemStack stack) {
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        public boolean m_8010_(@Nonnull Player playerIn) {
            return false;
        }

        public boolean m_6659_() {
            return false;
        }
    }
}

