/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.inventory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fuzs.enchantinginfuser.EnchantingInfuser;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.config.ServerConfig;
import fuzs.enchantinginfuser.network.S2CCompatibleEnchantsMessage;
import fuzs.enchantinginfuser.util.ChiseledBookshelfHelper;
import fuzs.enchantinginfuser.util.EnchantmentUtil;
import fuzs.enchantinginfuser.world.level.block.InfuserBlock;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class InfuserMenu
extends AbstractContainerMenu
implements ContainerListener {
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Container enchantSlots;
    private final ContainerLevelAccess levelAccess;
    private final Player player;
    public final ServerConfig.InfuserConfig config;
    private final DataSlot enchantingPower = DataSlot.m_39401_();
    private final DataSlot enchantingCost = DataSlot.m_39401_();
    private final DataSlot repairCost = DataSlot.m_39401_();
    private Map<Enchantment, Integer> enchantments;
    private Map<Enchantment, Integer> originalEnchantments;
    private int enchantingBaseCost;
    private boolean enchantmentsChanged;

    public static InfuserMenu create(InfuserBlock.InfuserType type, int id, Inventory inventory) {
        return new InfuserMenu(type.menuType(), id, inventory, type.config());
    }

    private InfuserMenu(MenuType<?> menuType, int id, Inventory playerInventory, ServerConfig.InfuserConfig config) {
        this(menuType, id, playerInventory, (Container)new SimpleContainer(1), ContainerLevelAccess.f_39287_, config);
    }

    public static InfuserMenu create(InfuserBlock.InfuserType type, int id, Inventory inventory, Container container, ContainerLevelAccess levelAccess) {
        return new InfuserMenu(type.menuType(), id, inventory, container, levelAccess, type.config());
    }

    private InfuserMenu(MenuType<?> menuType, int id, final Inventory inventory, Container container, ContainerLevelAccess levelAccess, ServerConfig.InfuserConfig config) {
        super(menuType, id);
        InfuserMenu.m_38869_((Container)container, (int)1);
        this.enchantSlots = container;
        this.levelAccess = levelAccess;
        this.player = inventory.f_35978_;
        this.config = config;
        this.m_38897_(new Slot(container, 0, 8, config.allowRepairing.isActive() ? 23 : 34){

            public int m_6641_() {
                return 1;
            }
        });
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.m_38897_(new Slot((Container)inventory, 39 - k, 8 + 188 * (k / 2), 103 + k % 2 * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return CommonAbstractions.INSTANCE.canEquip(stack, equipmentslot, (Entity)inventory.f_35978_);
                }

                public boolean m_8010_(Player player) {
                    ItemStack itemstack = this.m_7993_();
                    return (itemstack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemstack)) && super.m_8010_(player);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inventory, j1 + (l + 1) * 9, 30 + j1 * 18, 103 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inventory, i1, 30 + i1 * 18, 161));
        }
        this.m_38897_(new Slot((Container)inventory, 40, 8, 161){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.m_38895_(this.enchantingPower);
        this.m_38895_(this.enchantingCost);
        this.m_38895_(this.repairCost);
        this.m_38893_(this);
        this.levelAccess.m_39292_((level, pos) -> this.enchantingPower.m_6422_(this.getAvailablePower((Level)level, (BlockPos)pos)));
    }

    public boolean m_6875_(Player player) {
        return this.enchantSlots.m_6542_(player);
    }

    public void m_6199_(Container container) {
        if (container == this.enchantSlots) {
            this.enchantingCost.m_6422_(0);
            this.repairCost.m_6422_(0);
            ItemStack itemstack = container.m_8020_(0);
            if (!itemstack.m_41619_() && this.mayEnchantStack(itemstack)) {
                this.levelAccess.m_39292_((level, pos) -> {
                    List<Enchantment> availableEnchantments = EnchantmentUtil.getAvailableEnchantments(itemstack, this.config.types.allowAnvilEnchantments, this.config.types.allowTreasureEnchantments, this.config.types.allowUndiscoverableEnchantments, this.config.types.allowUntradeableEnchantments, this.config.types.allowCursesEnchantments);
                    this.setAndSyncEnchantments(EnchantmentUtil.copyEnchantmentsToMap(itemstack, availableEnchantments));
                    this.enchantingPower.m_6422_(this.getAvailablePower((Level)level, (BlockPos)pos));
                    this.repairCost.m_6422_(this.calculateRepairCost());
                });
            } else {
                this.setAndSyncEnchantments(Map.of());
            }
        }
    }

    private boolean mayEnchantStack(ItemStack itemStack) {
        if (this.config.allowBooks) {
            if (itemStack.m_41720_() instanceof BookItem) {
                return true;
            }
            if (itemStack.m_41720_() instanceof EnchantedBookItem) {
                return this.config.allowModifyingEnchantments != ServerConfig.ModifiableItems.UNENCHANTED;
            }
        } else if (itemStack.m_41720_() instanceof BookItem || itemStack.m_41720_() instanceof EnchantedBookItem) {
            return false;
        }
        return this.config.allowModifyingEnchantments.predicate.test(itemStack);
    }

    public void m_7934_(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.levelAccess.m_39292_((level, pos) -> {
                if (i == 0) {
                    this.m_6199_(this.enchantSlots);
                }
            });
        }
    }

    public void m_142153_(AbstractContainerMenu abstractContainerMenu, int i, int j) {
    }

    private int getAvailablePower(Level level, BlockPos pos) {
        float enchantingPower = 0.0f;
        int allChiseledBookshelfBooks = 0;
        float maxPowerScale = 1.0f;
        for (BlockPos offset : EnchantmentTableBlock.f_207902_) {
            if (!InfuserBlock.m_207909_(level, pos, offset)) continue;
            BlockState state = level.m_8055_(pos.m_121955_((Vec3i)offset));
            int chiseledBookshelfBooks = ChiseledBookshelfHelper.findValidBooks(level, pos, offset);
            if (chiseledBookshelfBooks > 0) {
                allChiseledBookshelfBooks += chiseledBookshelfBooks;
            } else {
                enchantingPower += EnchantingInfuserAPI.getEnchantStatsProvider().getEnchantPowerBonus(state, level, pos.m_121955_((Vec3i)offset));
            }
            maxPowerScale = Math.max(maxPowerScale, EnchantingInfuserAPI.getEnchantStatsProvider().getMaximumEnchantPowerScale(state, level, pos.m_121955_((Vec3i)offset)));
        }
        return (int)Math.min(Math.max(0.0f, enchantingPower + (float)(allChiseledBookshelfBooks / 3)), (float)this.config.maximumBookshelves * maxPowerScale);
    }

    public int clickEnchantmentLevelButton(Player player, Enchantment enchantment, boolean increase) {
        boolean incompatible = this.enchantments.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).filter(e -> e != enchantment).anyMatch(e -> !EnchantingInfuserAPI.getEnchantStatsProvider().isCompatibleWith((Enchantment)e, enchantment));
        if (incompatible) {
            EnchantingInfuser.LOGGER.warn("trying to add incompatible enchantment");
            return -1;
        }
        int enchantmentLevel = this.enchantments.get(enchantment) + (increase ? 1 : -1);
        if (enchantmentLevel != Mth.m_14045_((int)enchantmentLevel, (int)0, (int)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment))) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond bounds");
            return -1;
        }
        if (enchantmentLevel > (Integer)this.getMaxLevel(enchantment).getSecond()) {
            EnchantingInfuser.LOGGER.warn("trying change enchantment level beyond max allowed level");
            return -1;
        }
        this.enchantments.put(enchantment, enchantmentLevel);
        this.enchantingCost.m_6422_(this.calculateEnchantCost());
        return enchantmentLevel;
    }

    public boolean m_6366_(Player player, int id) {
        return switch (id) {
            case 0 -> this.clickEnchantButton(player);
            case 1 -> this.clickRepairButton(player);
            default -> false;
        };
    }

    private boolean clickEnchantButton(Player player) {
        ItemStack itemstack = this.enchantSlots.m_8020_(0);
        int cost = this.calculateEnchantCost();
        if (itemstack.m_41619_() || !this.enchantmentsChanged || player.f_36078_ < cost && !player.m_150110_().f_35937_) {
            return false;
        }
        this.levelAccess.m_39292_((level, pos) -> {
            ItemStack itemstack2 = itemstack;
            if (cost < 0) {
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)level), (Vec3)Vec3.m_82512_((Vec3i)pos), (int)this.calculateExperienceDelta(this.enchantments, this.originalEnchantments, level.f_46441_));
            } else if (!player.m_150110_().f_35937_) {
                player.m_6749_(-cost);
            }
            itemstack2 = EnchantmentUtil.setNewEnchantments(itemstack2, this.enchantments, this.config.increaseAnvilRepairCost && this.enchantingBaseCost != 0);
            this.enchantSlots.m_6836_(0, itemstack2);
            player.m_36220_(Stats.f_12964_);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10575_.m_27668_((ServerPlayer)player, itemstack2, cost);
            }
            this.enchantSlots.m_6596_();
            this.m_6199_(this.enchantSlots);
            level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        });
        return true;
    }

    private boolean clickRepairButton(Player player) {
        if (!this.config.allowRepairing.isActive()) {
            return false;
        }
        ItemStack itemstack = this.enchantSlots.m_8020_(0);
        if (!this.config.allowRepairing.isAllowedToRepair(itemstack)) {
            return false;
        }
        double repairStep = (double)itemstack.m_41776_() * this.config.repair.repairPercentageStep;
        int repairCost = (int)Math.ceil(Math.ceil((double)itemstack.m_41773_() / repairStep) * this.config.repair.repairStepMultiplier);
        if (player.f_36078_ >= repairCost || player.m_150110_().f_35937_) {
            this.levelAccess.m_39292_((level, pos) -> {
                if (!player.m_150110_().f_35937_) {
                    player.m_6749_(-repairCost);
                }
                ItemStack itemstack2 = itemstack.m_41777_();
                itemstack2.m_41721_(0);
                if (this.config.increaseAnvilRepairCost) {
                    itemstack2.m_41742_(AnvilMenu.m_39025_((int)itemstack.m_41610_()));
                }
                this.enchantSlots.m_6836_(0, itemstack2);
                level.m_46796_(1030, pos, 0);
            });
        }
        return true;
    }

    public int calculateRepairCost() {
        ItemStack itemstack = this.enchantSlots.m_8020_(0);
        if (!this.config.allowRepairing.isAllowedToRepair(itemstack)) {
            return 0;
        }
        double repairStep = (double)itemstack.m_41776_() * this.config.repair.repairPercentageStep;
        return (int)Math.ceil(Math.ceil((double)itemstack.m_41773_() / repairStep) * this.config.repair.repairStepMultiplier);
    }

    public Pair<OptionalInt, Integer> getMaxLevel(Enchantment enchantment) {
        int maxPower;
        int currentPower = this.getCurrentPower();
        Pair<OptionalInt, Integer> maxLevelSpecial = this.getSpecialMaxLevel(enchantment, currentPower, maxPower = this.getMaxPower());
        if (maxLevelSpecial != null) {
            return maxLevelSpecial;
        }
        int minPowerByRarity = this.getMinPowerByRarity(enchantment, maxPower);
        if (currentPower < minPowerByRarity) {
            return Pair.of((Object)OptionalInt.of(minPowerByRarity), (Object)0);
        }
        int totalLevels = EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment) - EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment);
        double levelRange = (double)maxPower * this.config.power.rarityRange;
        double levelPercentile = totalLevels > 0 ? levelRange / (double)totalLevels : 0.0;
        for (int i = 0; i <= totalLevels; ++i) {
            int nextPower = Math.min(maxPower, (int)Math.ceil((double)minPowerByRarity + (double)i * levelPercentile));
            if (currentPower >= nextPower) continue;
            return Pair.of((Object)OptionalInt.of(nextPower), (Object)(EnchantingInfuserAPI.getEnchantStatsProvider().getMinLevel(enchantment) + i - 1));
        }
        return Pair.of((Object)OptionalInt.of(maxPower), (Object)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment));
    }

    private Pair<OptionalInt, Integer> getSpecialMaxLevel(Enchantment enchantment, int currentPower, int maxPower) {
        double multiplier = -1.0;
        if (EnchantingInfuserAPI.getEnchantStatsProvider().isCurse(enchantment)) {
            multiplier = this.config.power.curseMultiplier;
        } else if (!EnchantingInfuserAPI.getEnchantStatsProvider().isDiscoverable(enchantment)) {
            multiplier = this.config.power.undiscoverableMultiplier;
        } else if (!EnchantingInfuserAPI.getEnchantStatsProvider().isTradeable(enchantment)) {
            multiplier = this.config.power.untradeableMultiplier;
        } else if (EnchantingInfuserAPI.getEnchantStatsProvider().isTreasureOnly(enchantment)) {
            multiplier = this.config.power.treasureMultiplier;
        }
        if (multiplier != -1.0) {
            int nextPower = (int)Math.round((double)maxPower * multiplier);
            return currentPower < nextPower ? Pair.of((Object)OptionalInt.of(nextPower), (Object)0) : Pair.of((Object)OptionalInt.empty(), (Object)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment));
        }
        return null;
    }

    private int getMinPowerByRarity(Enchantment enchantment, int maxPower) {
        double d = maxPower;
        return (int)Math.round(d * (switch (EnchantingInfuserAPI.getEnchantStatsProvider().getRarity(enchantment)) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> this.config.power.commonMultiplier;
            case Enchantment.Rarity.UNCOMMON -> this.config.power.uncommonMultiplier;
            case Enchantment.Rarity.RARE -> this.config.power.rareMultiplier;
            case Enchantment.Rarity.VERY_RARE -> this.config.power.veryRareMultiplier;
        }));
    }

    private int calculateEnchantCost() {
        this.markChanged();
        int cost = this.getScaledCosts(this.enchantments) - this.enchantingBaseCost;
        if (cost == 0 && this.enchantmentsChanged) {
            ++cost;
        }
        return cost;
    }

    private int calculateExperienceDelta(Map<Enchantment, Integer> enchantments, Map<Enchantment, Integer> originalEnchantments, RandomSource random) {
        if (enchantments.size() != originalEnchantments.size()) {
            throw new IllegalStateException("Enchantment map size mismatch!");
        }
        int experience = 0;
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            int currentLevel;
            int originalLevel;
            Enchantment enchantment = entry.getKey();
            if (!originalEnchantments.containsKey(enchantment) || (originalLevel = originalEnchantments.get(enchantment).intValue()) <= (currentLevel = entry.getValue().intValue())) continue;
            int originalMinCost = EnchantingInfuserAPI.getEnchantStatsProvider().getMinCost(enchantment, originalLevel);
            int currentMinCost = EnchantingInfuserAPI.getEnchantStatsProvider().getMinCost(enchantment, currentLevel);
            experience += Math.max(0, originalMinCost) - Math.max(0, currentMinCost);
        }
        if (experience > 0) {
            experience = (int)Math.ceil((double)experience / 2.0);
            return experience + random.m_188503_(experience);
        }
        return 0;
    }

    private void markChanged() {
        this.enchantmentsChanged = !this.enchantments.equals(this.originalEnchantments);
    }

    private int getScaledCosts(Map<Enchantment, Integer> enchantmentsToLevel) {
        double totalCosts = this.getTotalCosts(enchantmentsToLevel);
        int maxCost = (int)((float)this.config.costs.maximumCost * EnchantingInfuserAPI.getEnchantStatsProvider().getMaximumCostMultiplier());
        Item item = this.enchantSlots.m_8020_(0).m_41720_();
        if (totalCosts > (double)maxCost && !(item instanceof BookItem) && !(item instanceof EnchantedBookItem)) {
            double ratio = (double)maxCost / totalCosts;
            int minCosts = enchantmentsToLevel.values().stream().mapToInt(Integer::intValue).sum();
            return Math.max((int)Math.round((double)this.getAllCosts(enchantmentsToLevel) * ratio), minCosts);
        }
        return this.getAllCosts(enchantmentsToLevel);
    }

    private int getTotalCosts(Map<Enchantment, Integer> enchantmentsToLevel) {
        HashMap map = Maps.newHashMap();
        for (Enchantment enchantment : enchantmentsToLevel.keySet()) {
            boolean scaleCosts;
            boolean bl = scaleCosts = !this.config.costs.scaleCostsByVanillaOnly;
            if (!scaleCosts) {
                String namespace = BuiltInRegistries.f_256876_.m_7981_((Object)enchantment).m_135827_();
                for (String scalingNamespace : EnchantingInfuserAPI.getEnchantStatsProvider().getScalingNamespaces()) {
                    if (!namespace.equals(scalingNamespace)) continue;
                    scaleCosts = true;
                    break;
                }
            }
            if (!scaleCosts) continue;
            Pair pair2 = Pair.of((Object)EnchantingInfuserAPI.getEnchantStatsProvider().getRarity(enchantment), (Object)EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment));
            Optional<Map.Entry> any = map.entrySet().stream().filter(e -> !EnchantingInfuserAPI.getEnchantStatsProvider().isCompatibleWith((Enchantment)e.getKey(), enchantment)).findAny();
            if (any.isPresent()) {
                Map.Entry enchantmentData = any.get();
                Pair pair1 = (Pair)enchantmentData.getValue();
                map.put((Enchantment)enchantmentData.getKey(), this.compareEnchantmentData((Pair<Enchantment.Rarity, Integer>)pair1, (Pair<Enchantment.Rarity, Integer>)pair2));
                continue;
            }
            map.put(enchantment, pair2);
        }
        return map.values().stream().mapToInt(e -> this.getRarityCost((Enchantment.Rarity)e.getFirst()) * (Integer)e.getSecond()).sum();
    }

    private Pair<Enchantment.Rarity, Integer> compareEnchantmentData(Pair<Enchantment.Rarity, Integer> pair1, Pair<Enchantment.Rarity, Integer> pair2) {
        int cost1 = this.getRarityCost((Enchantment.Rarity)pair1.getFirst()) * (Integer)pair1.getSecond();
        int cost2 = this.getRarityCost((Enchantment.Rarity)pair2.getFirst()) * (Integer)pair2.getSecond();
        return cost2 > cost1 ? pair2 : pair1;
    }

    private int getAllCosts(Map<Enchantment, Integer> enchantmentsToLevel) {
        return enchantmentsToLevel.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).mapToInt(entry -> this.getAdjustedRarityCost((Enchantment)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    private int getAdjustedRarityCost(Enchantment enchantment) {
        int cost = this.getRarityCost(EnchantingInfuserAPI.getEnchantStatsProvider().getRarity(enchantment));
        if (!(!this.config.costs.doubleUniques || !EnchantingInfuserAPI.getEnchantStatsProvider().isTreasureOnly(enchantment) && EnchantingInfuserAPI.getEnchantStatsProvider().isDiscoverable(enchantment) && EnchantingInfuserAPI.getEnchantStatsProvider().isTradeable(enchantment) || EnchantingInfuserAPI.getEnchantStatsProvider().isCurse(enchantment))) {
            cost *= 2;
        }
        return cost;
    }

    private int getRarityCost(Enchantment.Rarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> this.config.costs.commonCostMultiplier;
            case Enchantment.Rarity.UNCOMMON -> this.config.costs.uncommonCostMultiplier;
            case Enchantment.Rarity.RARE -> this.config.costs.rareCostMultiplier;
            case Enchantment.Rarity.VERY_RARE -> this.config.costs.veryRareCostMultiplier;
        };
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
            if (pIndex == 0) {
                if (equipmentslot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(4 - equipmentslot.m_20749_())).m_6657_()) {
                    int i = 4 - equipmentslot.m_20749_();
                    if (!this.m_38903_(itemstack1, i, i + 1, false)) {
                        slot.m_142406_(pPlayer, itemstack1);
                        return ItemStack.f_41583_;
                    }
                } else if (equipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(41)).m_6657_() && !this.m_38903_(itemstack1, 41, 42, false)) {
                    slot.m_142406_(pPlayer, itemstack1);
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, 5, 41, true)) {
                    slot.m_142406_(pPlayer, itemstack1);
                    return ItemStack.f_41583_;
                }
            } else {
                if (((Slot)this.f_38839_.get(0)).m_6657_()) {
                    return ItemStack.f_41583_;
                }
                ItemStack itemstack2 = itemstack1.m_41777_();
                itemstack2.m_41764_(1);
                itemstack1.m_41774_(1);
                ((Slot)this.f_38839_.get(0)).m_5852_(itemstack2);
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public int getCurrentPower() {
        return Math.min(this.enchantingPower.m_6501_(), this.getMaxPower());
    }

    public int getMaxPower() {
        int maximumEnchantPower = EnchantingInfuserAPI.getEnchantStatsProvider().getMaximumEnchantPower();
        if (maximumEnchantPower != -1) {
            return maximumEnchantPower;
        }
        return this.config.maximumBookshelves;
    }

    public ItemStack getEnchantableStack() {
        return this.enchantSlots.m_8020_(0);
    }

    public int getEnchantCost() {
        return this.enchantingCost.m_6501_();
    }

    public int getRepairCost() {
        return this.repairCost.m_6501_();
    }

    public boolean canEnchant(Player player) {
        if (!this.enchantSlots.m_8020_(0).m_41619_() && this.enchantmentsChanged) {
            return player.f_36078_ >= this.getEnchantCost() || player.m_150110_().f_35937_;
        }
        return false;
    }

    public boolean canRepair(Player player) {
        if (this.config.allowRepairing.isAllowedToRepair(this.enchantSlots.m_8020_(0))) {
            return player.f_36078_ >= this.getRepairCost() || player.m_150110_().f_35937_;
        }
        return false;
    }

    public Map<Enchantment, Integer> getValidEnchantments() {
        return ImmutableMap.copyOf(this.enchantments);
    }

    public List<Map.Entry<Enchantment, Integer>> getSortedEntries() {
        return this.enchantments.entrySet().stream().sorted(Comparator.comparingInt(e -> EnchantingInfuserAPI.getEnchantStatsProvider().getRarity((Enchantment)e.getKey()).ordinal()).thenComparing(e -> Component.m_237115_((String)((Enchantment)e.getKey()).m_44704_()).getString())).collect(Collectors.toList());
    }

    public void setAndSyncEnchantments(Map<Enchantment, Integer> enchantmentsToLevel) {
        this.enchantments = enchantmentsToLevel;
        this.originalEnchantments = ImmutableMap.copyOf(enchantmentsToLevel);
        this.enchantingBaseCost = this.getScaledCosts(enchantmentsToLevel);
        this.markChanged();
        this.levelAccess.m_39292_((level, blockPos) -> EnchantingInfuser.NETWORK.sendTo((MessageV2)new S2CCompatibleEnchantsMessage(this.f_38840_, enchantmentsToLevel), (ServerPlayer)this.player));
    }
}

