/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.client.minecolonies;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.views.View;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.citizen.AbstractWindowCitizen;
import com.minecolonies.core.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.core.network.messages.server.colony.citizen.AdjustSkillCitizenMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import steve_gall.minecolonies_tweaks.core.client.gui.ViewOverrideExtension;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

@Mixin(value={MainWindowCitizen.class}, remap=false)
public abstract class MainWindowCitizenMixin
extends AbstractWindowCitizen
implements ViewOverrideExtension {
    @Unique
    private static final String SKILL_ALL_PLUS = "skill_all_up";
    @Unique
    private static final String SKILL_ALL_MINUS = "skill_all_down";
    @Unique
    private static final String SKILL_ALL_BTS = "skill_all_bts";
    @Shadow(remap=false)
    private ICitizenDataView citizen;
    @Shadow(remap=false)
    private int tick;

    public MainWindowCitizenMixin(ICitizenDataView citizen, String ui) {
        super(citizen, ui);
    }

    @Inject(method={"onButtonClicked"}, remap=false, at={@At(value="HEAD")}, cancellable=false)
    private void onButtonClicked(Button button, CallbackInfo ci) {
        block3: {
            block2: {
                if (!button.getID().contains(SKILL_ALL_PLUS)) break block2;
                for (Skill skill : Skill.values()) {
                    Network.getNetwork().sendToServer((IMessage)new AdjustSkillCitizenMessage((IColony)this.colony, this.citizen, this.getSkillQuantity(1), skill));
                }
                break block3;
            }
            if (!button.getID().contains(SKILL_ALL_MINUS)) break block3;
            for (Skill skill : Skill.values()) {
                Network.getNetwork().sendToServer((IMessage)new AdjustSkillCitizenMessage((IColony)this.colony, this.citizen, this.getSkillQuantity(-1), skill));
            }
        }
    }

    @WrapOperation(method={"onButtonClicked"}, remap=false, at={@At(value="NEW", target="com/minecolonies/core/network/messages/server/colony/citizen/AdjustSkillCitizenMessage")})
    private AdjustSkillCitizenMessage onButtonClicked(IColony colony, @NotNull ICitizenDataView citizenDataView, int quantity, Skill skill, Operation<AdjustSkillCitizenMessage> operation) {
        return (AdjustSkillCitizenMessage)operation.call(new Object[]{colony, citizenDataView, this.getSkillQuantity(quantity), skill});
    }

    @Unique
    private int getSkillQuantity(int quantity) {
        if (Screen.m_96637_()) {
            quantity *= 2;
        }
        if (Screen.m_96638_()) {
            quantity *= 5;
        }
        return quantity;
    }

    @Inject(method={"onUpdate"}, remap=false, at={@At(value="HEAD")}, cancellable=false)
    private void onUpdateTail(CallbackInfo ci) {
        if (this.tick == 0) {
            Minecraft mc = Minecraft.m_91087_();
            this.window.findPaneByID(SKILL_ALL_BTS).setVisible(mc.f_91074_.m_7500_());
        }
    }

    @Override
    public void minecolonies_tweaks$onParse(View view, PaneParams params) {
        Loader.createFromXMLFile((ResourceLocation)MineColoniesTweaks.rl("gui/citizen/main.xml"), (View)this);
    }
}

