/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearchTree;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.resolvers.CustomizableRequestableResolver;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;
import steve_gall.minecolonies_tweaks.core.common.building.module.ResearchCostResolverBuildingModule;
import steve_gall.minecolonies_tweaks.core.common.init.MCTweaksBuildingModules;
import steve_gall.minecolonies_tweaks.core.common.research.LocalResearchTreeExtension;
import steve_gall.minecolonies_tweaks.core.common.research.ResearchCost;

public class ResearchCostResolver
extends CustomizableRequestableResolver<ResearchCost> {
    public static ResearchCostResolver deserialize(ILocation location, IToken<?> token, CompoundTag compound) {
        return new ResearchCostResolver(location, token);
    }

    public static void serialize(ResearchCostResolver resolver, CompoundTag compound) {
    }

    public static boolean hasResolver(IBuilding building) {
        if (building.hasModule(MCTweaksBuildingModules.RESEARCH_COST_RESOLVER)) {
            ResearchCostResolverBuildingModule module = (ResearchCostResolverBuildingModule)building.getModule(MCTweaksBuildingModules.RESEARCH_COST_RESOLVER);
            return module.hasResolver();
        }
        return false;
    }

    public static boolean hasResolver(IBuildingView buildingView) {
        if (buildingView.hasModuleView(MCTweaksBuildingModules.RESEARCH_COST_RESOLVER)) {
            ResearchCostResolverBuildingModule.View module = (ResearchCostResolverBuildingModule.View)buildingView.getModuleView(MCTweaksBuildingModules.RESEARCH_COST_RESOLVER);
            return module.hasResolver();
        }
        return false;
    }

    public ResearchCostResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, @NotNull IRequester requester, @NotNull IRequestableObject request) {
        return requester.getLocation().equals(this.getLocation()) && request instanceof ResearchCost;
    }

    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull ResearchCost request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull ResearchCost request) {
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequester requester, @NotNull ResearchCost request) {
        ArrayList list = new ArrayList();
        for (ItemStorage stack : request.getItems()) {
            list.add(manager.createRequest((IRequester)this, (IRequestable)new Stack(stack)));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequester requester, @NotNull ResearchCost request) {
        IColony colony;
        ServerPlayer player;
        UUID uuid = request.getRequester();
        if (uuid != null && (player = (colony = manager.getColony()).getWorld().m_7654_().m_6846_().m_11259_(uuid)) != null) {
            LocalResearchTreeExtension extension;
            IGlobalResearchTree globalTree = IGlobalResearchTree.getInstance();
            IGlobalResearchBranch branch = globalTree.getBranchData(request.getBranchId());
            IGlobalResearch research = branch != null ? globalTree.getResearch(request.getBranchId(), request.getResearchId()) : null;
            MutableComponent branchName = research != null ? MutableComponent.m_237204_((ComponentContents)branch.getName()) : Component.m_237113_((String)request.getBranchId().toString());
            MutableComponent researchName = research != null ? MutableComponent.m_237204_((ComponentContents)research.getName()) : Component.m_237113_((String)request.getResearchId().toString());
            player.m_213846_((Component)Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.delivery_completed", (Object[])new Object[]{branchName, researchName}).m_130940_(ChatFormatting.GRAY));
            ILocalResearchTree localTree = colony.getResearchManager().getResearchTree();
            try {
                if (localTree instanceof LocalResearchTreeExtension) {
                    extension = (LocalResearchTreeExtension)localTree;
                    IBuilding building = colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation());
                    extension.minecolonies_tweaks$setBuilding(building);
                }
                localTree.attemptBeginResearch((Player)player, colony, research);
            }
            finally {
                if (localTree instanceof LocalResearchTreeExtension) {
                    extension = (LocalResearchTreeExtension)localTree;
                    extension.minecolonies_tweaks$setBuilding(null);
                }
            }
        }
    }

    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        IRequester requester;
        MutableComponent displayName;
        CustomizableRequestable custom;
        IRequestable iRequestable = request.getRequest();
        if (iRequestable instanceof CustomizableRequestable && (custom = (CustomizableRequestable)iRequestable).getObject() instanceof ResearchCost && (displayName = BuildingUtils.getDisplayName(requester = manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()))) != null) {
            return displayName;
        }
        return super.getRequesterDisplayName(manager, request);
    }
}

