/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.init;

import com.minecolonies.core.items.ItemResourceScroll;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import steve_gall.minecolonies_tweaks.core.common.item.ItemInventoryScroll;
import steve_gall.minecolonies_tweaks.core.common.item.ItemResourceScrollBook;
import steve_gall.minecolonies_tweaks.core.common.item.ItemUniversityScroll;

public class MCTweaksItems {
    public static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"minecolonies_tweaks");
    public static final Map<DyeColor, RegistryObject<ItemResourceScroll>> COLOR_RESOURCE_SCROLLS;
    public static final RegistryObject<ItemResourceScrollBook> RESOURCESCROLL_BOOK;
    public static final RegistryObject<ItemInventoryScroll> INVENTORYSCROLL;
    public static final Map<DyeColor, RegistryObject<ItemInventoryScroll>> COLOR_INVENTORY_SCROLLS;
    public static final RegistryObject<ItemUniversityScroll> UNIVERSITYSCROLL;

    private MCTweaksItems() {
    }

    static {
        RESOURCESCROLL_BOOK = REGISTER.register("resourcescroll_book", () -> new ItemResourceScrollBook(new Item.Properties(), 27));
        INVENTORYSCROLL = REGISTER.register("inventoryscroll", () -> new ItemInventoryScroll(new Item.Properties()));
        UNIVERSITYSCROLL = REGISTER.register("universityscroll", () -> new ItemUniversityScroll(new Item.Properties()));
        HashMap<DyeColor, RegistryObject> colorResourceScrolls = new HashMap<DyeColor, RegistryObject>();
        COLOR_RESOURCE_SCROLLS = Collections.unmodifiableMap(colorResourceScrolls);
        HashMap<DyeColor, RegistryObject> colorWarehouseScrolls = new HashMap<DyeColor, RegistryObject>();
        COLOR_INVENTORY_SCROLLS = Collections.unmodifiableMap(colorWarehouseScrolls);
        for (DyeColor color : DyeColor.values()) {
            RegistryObject resourceScroll = REGISTER.register("resourcescroll_" + color.m_41065_().toLowerCase(), () -> new ItemResourceScroll(new Item.Properties()));
            colorResourceScrolls.put(color, resourceScroll);
            RegistryObject warehouseScroll = REGISTER.register("inventoryscroll_" + color.m_41065_().toLowerCase(), () -> new ItemInventoryScroll(new Item.Properties()));
            colorWarehouseScrolls.put(color, warehouseScroll);
        }
    }
}

