/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import steve_gall.minecolonies_tweaks.core.common.config.ConfigConstants;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.AbstractEntityAICraftingAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.AbstractEntityAIStructureAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIWorkFarmerAccessor;
import steve_gall.minecolonies_tweaks.mixin.common.minecolonies.EntityAIWorkSifterAccessor;

public class JobConfig {
    public final ForgeConfigSpec.IntValue blockMiningDelay;
    public final ForgeConfigSpec.IntValue blockBuildingDelay;
    public final ForgeConfigSpec.IntValue menuPerLevel;
    public final ForgeConfigSpec.BooleanValue disableLeisure;
    public final ForgeConfigSpec.IntValue craftingProgressMultiplier;
    public final ForgeConfigSpec.IntValue craftingHittingTime;
    public final ForgeConfigSpec.IntValue craftingDecideDelay;
    public final ForgeConfigSpec.IntValue sifterProgressMultiplier;
    public final ForgeConfigSpec.BooleanValue dyerDisableBleaching;
    public final ForgeConfigSpec.IntValue farmerWorkDelay;
    public final ForgeConfigSpec.DoubleValue farmerSkillDivider;
    public final ForgeConfigSpec.IntValue farmerActionsDoneUntilDumping;
    public final ForgeConfigSpec.BooleanValue farmerPlantAfterHoe;
    public final ForgeConfigSpec.BooleanValue farmerPlantAfterHarvest;
    public final ForgeConfigSpec.BooleanValue structureLeavesFree;
    public final ForgeConfigSpec.IntValue warehouseCouriersPerLevel;
    public final ForgeConfigSpec.IntValue maximumStockKindsPerLevel;

    public JobConfig(ForgeConfigSpec.Builder builder) {
        this.blockMiningDelay = builder.defineInRange("blockMiningDelay", 500, 0, Integer.MAX_VALUE);
        this.blockBuildingDelay = builder.defineInRange("blockBuildingDelay", AbstractEntityAIStructureAccessor.getBuildBlockDelay(), 0, Integer.MAX_VALUE);
        builder.comment("for restaurant, netherworker");
        this.menuPerLevel = builder.defineInRange("menuPerLevel", 5, 0, Integer.MAX_VALUE);
        builder.comment("Disables the citizen's leisure.");
        this.disableLeisure = builder.define("disableLeisure", true);
        builder.push("crafing");
        builder.comment("craftingTicks = progressMultiplier / craftSkillLevel * hittingTime");
        this.craftingProgressMultiplier = builder.defineInRange("progressMultiplier", AbstractEntityAICraftingAccessor.getProgressMultiplier(), 0, Integer.MAX_VALUE);
        this.craftingHittingTime = builder.defineInRange("hittingTime", AbstractEntityAICraftingAccessor.getHittingTime(), 0, Integer.MAX_VALUE);
        builder.comment(new String[]{"The delay ticks for go to work again after Citizen returned at hut", "This was 0 in 1.19.2"});
        builder.comment(ConfigConstants.VANILLA_IS(400));
        this.craftingDecideDelay = builder.defineInRange("decideDelay", 0, 0, 400);
        builder.pop();
        builder.push("sifter");
        builder.comment("siftingTicks = progressMultiplier - strengthLevel");
        this.sifterProgressMultiplier = builder.defineInRange("progressMultiplier", EntityAIWorkSifterAccessor.getMaxLevel(), 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("dyer");
        builder.comment("disables wool bleaching to avoid wool loop crafting. To take effect it requires using the command \"/mc colony requestsystem-reset-all\"");
        builder.comment(ConfigConstants.VANILLA_IS_FALSE);
        this.dyerDisableBleaching = builder.define("dyerDisableBleaching", true);
        builder.pop();
        builder.push("farmer");
        builder.comment("finalDelay = workDelay - (skillDivider * staminaLevel)");
        this.farmerWorkDelay = builder.defineInRange("workDelay", EntityAIWorkFarmerAccessor.getStandardDelay(), 0, Integer.MAX_VALUE);
        this.farmerSkillDivider = builder.defineInRange("skillDivider", 2.0, 0.0, 2.147483647E9);
        builder.comment("if harvested count reached to this, farmer will go to dump");
        this.farmerActionsDoneUntilDumping = builder.defineInRange("actionsDoneUntilDumping", 256, EntityAIWorkFarmerAccessor.getMaxBlocksMined(), Integer.MAX_VALUE);
        builder.comment("whether plant seed after hoeing dirt");
        builder.comment(ConfigConstants.VANILLA_IS_FALSE);
        this.farmerPlantAfterHoe = builder.define("plantAfterHoe", true);
        builder.comment("whether plant seed after harvest crop");
        builder.comment(ConfigConstants.VANILLA_IS_FALSE);
        this.farmerPlantAfterHarvest = builder.define("plantAfterHarvest", true);
        builder.pop();
        builder.push("structure");
        builder.comment("If this is off, Builders will requests 'Leaves' on needed it when build.");
        this.structureLeavesFree = builder.define("leavesFree", true);
        builder.pop();
        builder.push("warehouse");
        this.warehouseCouriersPerLevel = builder.defineInRange("couriersPerLevel", 2, 1, 20);
        builder.pop();
        builder.push("maximumStock");
        builder.comment("This will be affected by research effect 'effects/minimumstockmultiplier'");
        this.maximumStockKindsPerLevel = builder.defineInRange("kindsPerLevel", 5, 0, 100);
        builder.pop();
    }
}

