/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.part;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.modcompat.commoncapabilities.BlockCapabilitiesHelpers;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.part.PartTypeInterfaceCraftingBase;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.jetbrains.annotations.Nullable;

public class PartTypeInterfaceCraftingAttuned
extends PartTypeInterfaceCraftingBase<PartTypeInterfaceCraftingAttuned, State> {
    public PartTypeInterfaceCraftingAttuned(String name) {
        super(name);
    }

    public int getConsumptionRate(State state) {
        return state.getCraftingJobHandler().getProcessingCraftingJobs().size() * GeneralConfig.interfaceCraftingAttunedBaseConsumption;
    }

    @Override
    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public MutableComponent getDisplayName() {
                return Component.m_237115_((String)PartTypeInterfaceCraftingAttuned.this.getTranslationKey());
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerPartInterfaceCraftingSettings(id, playerInventory, (Container)new SimpleContainer(0), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (IPartType)data.getMiddle());
            }
        });
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        super.writeExtraGuiDataSettings(packetBuffer, pos, player);
    }

    public Optional<MenuProvider> getContainerProviderSettings(PartPos pos) {
        return Optional.empty();
    }

    protected State constructDefaultState() {
        return new State();
    }

    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus();
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        IgnoredBlockStatus.Status status = IgnoredBlockStatus.Status.INACTIVE;
        if (state != null) {
            status = state.hasValidTarget() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.ERROR;
        }
        return status;
    }

    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return (BlockState)super.getBlockState(partContainer, side).m_61124_((Property)IgnoredBlockStatus.STATUS, (Comparable)status);
    }

    public void loadTooltip(State state, List<Component> lines) {
        super.loadTooltip((IPartState)state, lines);
        if (!state.hasValidTarget()) {
            lines.add((Component)Component.m_237115_((String)"parttype.integratedcrafting.interface_crafting_attuned.unsupported").m_130940_(ChatFormatting.RED));
        }
    }

    public boolean shouldTriggerBlockRenderUpdate(@javax.annotation.Nullable State oldPartState, @javax.annotation.Nullable State newPartState) {
        return super.shouldTriggerBlockRenderUpdate((IPartState)oldPartState, (IPartState)newPartState) || this.getStatus(oldPartState) != this.getStatus(newPartState);
    }

    public void onBlockNeighborChange(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, BlockGetter world, Block neighbourBlock, BlockPos neighbourBlockPos) {
        boolean isNeighbourTarget = neighbourBlockPos.equals((Object)target.getTarget().getPos().getBlockPos());
        boolean hadValidTarget = false;
        if (isNeighbourTarget) {
            hadValidTarget = state.hasValidTarget();
            this.removeTargetFromNetwork(network, target.getTarget(), state);
        }
        super.onBlockNeighborChange(network, partNetwork, target, (IPartState)state, world, neighbourBlock, neighbourBlockPos);
        if (isNeighbourTarget) {
            this.addTargetToNetwork(network, target, state, false);
            state.isDirtyAndReset();
            if (hadValidTarget != state.hasValidTarget()) {
                state.markDirty();
                BlockHelpers.markForUpdate((Level)target.getCenter().getPos().getLevel(true), (BlockPos)target.getCenter().getPos().getBlockPos());
            }
        }
    }

    public static class State
    extends PartTypeInterfaceCraftingBase.State<PartTypeInterfaceCraftingAttuned, State> {
        protected boolean hasValidTarget = false;
        private Collection<IRecipeDefinition> recipes;

        protected LazyOptional<IRecipeHandler> getTargetRecipeHandler() {
            PartPos target = this.getTarget().getTarget();
            return BlockCapabilitiesHelpers.getTileOrBlockCapability((DimPos)target.getPos(), (Direction)target.getSide(), (Capability)Capabilities.RECIPE_HANDLER);
        }

        @Override
        public void setNetworks(@Nullable INetwork network, @Nullable ICraftingNetwork craftingNetwork, @Nullable IPartNetwork partNetwork, int channel, @Nullable ValueDeseralizationContext valueDeseralizationContext, boolean initialize) {
            super.setNetworks(network, craftingNetwork, partNetwork, channel, valueDeseralizationContext, initialize);
            this.hasValidTarget = this.getTargetRecipeHandler().isPresent();
            this.recipes = this.getTargetRecipeHandler().map(IRecipeHandler::getRecipes).orElse(Collections.emptyList());
            this.markDirty();
        }

        public boolean hasValidTarget() {
            return this.hasValidTarget;
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            super.writeToNBT(tag);
            tag.m_128379_("hasValidTarget", this.hasValidTarget);
        }

        @Override
        public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.readFromNBT(valueDeseralizationContext, tag);
            this.hasValidTarget = tag.m_128471_("hasValidTarget");
        }

        @Override
        public Collection<IRecipeDefinition> getRecipes() {
            return this.recipes;
        }
    }
}

