/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.entity;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.ItemUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class TileEntityUtils
implements Module {
    public final List<String> BLOCK_NAMES = StringUtils.newArrayList();
    public final List<String> ITEM_NAMES = StringUtils.newArrayList();
    private final List<String> BLOCK_CLASSES = StringUtils.newArrayList();
    private final List<String> ITEM_CLASSES = StringUtils.newArrayList();
    private final List<String> TILE_ENTITY_CLASSES = StringUtils.newArrayList();
    public List<String> TILE_ENTITY_NAMES = StringUtils.newArrayList();
    public Map<String, ItemStack> TILE_ENTITY_RESOURCES = StringUtils.newHashMap();
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedMainHand = false;
    private boolean hasInitializedOffHand = false;
    private boolean hasInitializedHelmet = false;
    private boolean hasInitializedChest = false;
    private boolean hasInitializedLegs = false;
    private boolean hasInitializedBoots = false;
    private ItemStack CURRENT_MAIN_HAND_ITEM;
    private ItemStack CURRENT_OFFHAND_ITEM;
    private ItemStack CURRENT_HELMET;
    private ItemStack CURRENT_CHEST;
    private ItemStack CURRENT_LEGS;
    private ItemStack CURRENT_BOOTS;
    private String CURRENT_MAIN_HAND_ITEM_NAME;
    private String CURRENT_OFFHAND_ITEM_NAME;
    private String CURRENT_HELMET_NAME;
    private String CURRENT_CHEST_NAME;
    private String CURRENT_LEGS_NAME;
    private String CURRENT_BOOTS_NAME;

    @Override
    public void clearFieldData() {
        this.BLOCK_NAMES.clear();
        this.BLOCK_CLASSES.clear();
        this.ITEM_NAMES.clear();
        this.ITEM_CLASSES.clear();
        this.TILE_ENTITY_NAMES.clear();
        this.TILE_ENTITY_CLASSES.clear();
        this.TILE_ENTITY_RESOURCES.clear();
    }

    @Override
    public void clearAttributes() {
        this.CURRENT_MAIN_HAND_ITEM = ItemUtils.EMPTY_STACK;
        this.CURRENT_OFFHAND_ITEM = ItemUtils.EMPTY_STACK;
        this.CURRENT_MAIN_HAND_ITEM_NAME = null;
        this.CURRENT_OFFHAND_ITEM_NAME = null;
        this.CURRENT_HELMET = ItemUtils.EMPTY_STACK;
        this.CURRENT_CHEST = ItemUtils.EMPTY_STACK;
        this.CURRENT_LEGS = ItemUtils.EMPTY_STACK;
        this.CURRENT_BOOTS = ItemUtils.EMPTY_STACK;
        this.CURRENT_HELMET_NAME = null;
        this.CURRENT_CHEST_NAME = null;
        this.CURRENT_LEGS_NAME = null;
        this.CURRENT_BOOTS_NAME = null;
        CraftPresence.CLIENT.removeArguments("item", "data.item");
        this.hasInitialized = false;
        this.hasInitializedMainHand = false;
        this.hasInitializedOffHand = false;
        this.hasInitializedHelmet = false;
        this.hasInitializedChest = false;
        this.hasInitializedLegs = false;
        this.hasInitializedBoots = false;
    }

    @Override
    public void updateData() {
        boolean hasBootsChanged;
        ItemStack NEW_CURRENT_MAIN_HAND_ITEM = CraftPresence.player.m_21205_();
        ItemStack NEW_CURRENT_OFFHAND_ITEM = CraftPresence.player.m_21206_();
        ItemStack NEW_CURRENT_HELMET = (ItemStack)CraftPresence.player.m_150109_().f_35975_.get(3);
        ItemStack NEW_CURRENT_CHEST = (ItemStack)CraftPresence.player.m_150109_().f_35975_.get(2);
        ItemStack NEW_CURRENT_LEGS = (ItemStack)CraftPresence.player.m_150109_().f_35975_.get(1);
        ItemStack NEW_CURRENT_BOOTS = (ItemStack)CraftPresence.player.m_150109_().f_35975_.get(0);
        boolean hasMainHandChanged = NEW_CURRENT_MAIN_HAND_ITEM != this.CURRENT_MAIN_HAND_ITEM;
        boolean hasOffHandChanged = NEW_CURRENT_OFFHAND_ITEM != this.CURRENT_OFFHAND_ITEM;
        boolean hasHelmetChanged = NEW_CURRENT_HELMET != this.CURRENT_HELMET;
        boolean hasChestChanged = NEW_CURRENT_CHEST != this.CURRENT_CHEST;
        boolean hasLegsChanged = NEW_CURRENT_LEGS != this.CURRENT_LEGS;
        boolean bl = hasBootsChanged = NEW_CURRENT_BOOTS != this.CURRENT_BOOTS;
        if (hasMainHandChanged) {
            this.CURRENT_MAIN_HAND_ITEM = NEW_CURRENT_MAIN_HAND_ITEM;
            this.CURRENT_MAIN_HAND_ITEM_NAME = ItemUtils.getItemName((Object)this.CURRENT_MAIN_HAND_ITEM);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_MAIN_HAND_ITEM)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.main_hand.time");
            }
        }
        if (hasOffHandChanged) {
            this.CURRENT_OFFHAND_ITEM = NEW_CURRENT_OFFHAND_ITEM;
            this.CURRENT_OFFHAND_ITEM_NAME = ItemUtils.getItemName((Object)this.CURRENT_OFFHAND_ITEM);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_OFFHAND_ITEM)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.off_hand.time");
            }
        }
        if (hasHelmetChanged) {
            this.CURRENT_HELMET = NEW_CURRENT_HELMET;
            this.CURRENT_HELMET_NAME = ItemUtils.getItemName((Object)this.CURRENT_HELMET);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_HELMET)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.helmet.time");
            }
        }
        if (hasChestChanged) {
            this.CURRENT_CHEST = NEW_CURRENT_CHEST;
            this.CURRENT_CHEST_NAME = ItemUtils.getItemName((Object)this.CURRENT_CHEST);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_CHEST)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.chestplate.time");
            }
        }
        if (hasLegsChanged) {
            this.CURRENT_LEGS = NEW_CURRENT_LEGS;
            this.CURRENT_LEGS_NAME = ItemUtils.getItemName((Object)this.CURRENT_LEGS);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_LEGS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.leggings.time");
            }
        }
        if (hasBootsChanged) {
            this.CURRENT_BOOTS = NEW_CURRENT_BOOTS;
            this.CURRENT_BOOTS_NAME = ItemUtils.getItemName((Object)this.CURRENT_BOOTS);
            if (!ItemUtils.isItemEmpty((Object)this.CURRENT_BOOTS)) {
                CraftPresence.CLIENT.syncTimestamp("data.item.boots.time");
            }
        }
        if (hasMainHandChanged || hasOffHandChanged || hasHelmetChanged || hasChestChanged || hasLegsChanged || hasBootsChanged) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("item.message.default", () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault("default", ""));
        this.syncArgument("item.message.holding", () -> String.format("[%s, %s]", StringUtils.getOrDefault((String)this.CURRENT_MAIN_HAND_ITEM_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_OFFHAND_ITEM_NAME, (String)"N/A")), true);
        this.syncArgument("item.message.equipped", () -> String.format("[%s, %s, %s, %s]", StringUtils.getOrDefault((String)this.CURRENT_HELMET_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_CHEST_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_LEGS_NAME, (String)"N/A"), StringUtils.getOrDefault((String)this.CURRENT_BOOTS_NAME, (String)"N/A")), true);
    }

    @Override
    public void updatePresence() {
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_MAIN_HAND_ITEM)) {
            if (!this.hasInitializedMainHand) {
                this.syncArgument("data.item.main_hand.instance", () -> this.CURRENT_MAIN_HAND_ITEM != null, () -> this.CURRENT_MAIN_HAND_ITEM, true);
                this.syncArgument("data.item.main_hand.class", () -> this.CURRENT_MAIN_HAND_ITEM != null, () -> this.CURRENT_MAIN_HAND_ITEM.getClass(), true);
                this.syncArgument("item.main_hand.name", () -> this.CURRENT_MAIN_HAND_ITEM != null, () -> this.CURRENT_MAIN_HAND_ITEM_NAME, true);
                this.syncArgument("item.main_hand.message", () -> this.CURRENT_MAIN_HAND_ITEM != null, () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_MAIN_HAND_ITEM_NAME, this.CURRENT_MAIN_HAND_ITEM_NAME));
                this.hasInitializedMainHand = true;
            }
        } else if (this.hasInitializedMainHand) {
            CraftPresence.CLIENT.removeArguments("item.main_hand", "data.item.main_hand");
            this.hasInitializedMainHand = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_OFFHAND_ITEM)) {
            if (!this.hasInitializedOffHand) {
                this.syncArgument("data.item.off_hand.instance", () -> this.CURRENT_OFFHAND_ITEM != null, () -> this.CURRENT_OFFHAND_ITEM, true);
                this.syncArgument("data.item.off_hand.class", () -> this.CURRENT_OFFHAND_ITEM != null, () -> this.CURRENT_OFFHAND_ITEM.getClass(), true);
                this.syncArgument("item.off_hand.name", () -> this.CURRENT_OFFHAND_ITEM != null, () -> this.CURRENT_OFFHAND_ITEM_NAME, true);
                this.syncArgument("item.off_hand.message", () -> this.CURRENT_OFFHAND_ITEM != null, () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_OFFHAND_ITEM_NAME, this.CURRENT_OFFHAND_ITEM_NAME));
                this.hasInitializedOffHand = true;
            }
        } else if (this.hasInitializedOffHand) {
            CraftPresence.CLIENT.removeArguments("item.off_hand", "data.item.off_hand");
            this.hasInitializedOffHand = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_HELMET)) {
            if (!this.hasInitializedHelmet) {
                this.syncArgument("data.item.helmet.instance", () -> this.CURRENT_HELMET != null, () -> this.CURRENT_HELMET, true);
                this.syncArgument("data.item.helmet.class", () -> this.CURRENT_HELMET != null, () -> this.CURRENT_HELMET.getClass(), true);
                this.syncArgument("item.helmet.name", () -> this.CURRENT_HELMET != null, () -> this.CURRENT_HELMET_NAME, true);
                this.syncArgument("item.helmet.message", () -> this.CURRENT_HELMET != null, () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_HELMET_NAME, this.CURRENT_HELMET_NAME));
                this.hasInitializedHelmet = true;
            }
        } else if (this.hasInitializedHelmet) {
            CraftPresence.CLIENT.removeArguments("item.helmet", "data.item.helmet");
            this.hasInitializedHelmet = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_CHEST)) {
            if (!this.hasInitializedChest) {
                this.syncArgument("data.item.chestplate.instance", () -> this.CURRENT_CHEST != null, () -> this.CURRENT_CHEST, true);
                this.syncArgument("data.item.chestplate.class", () -> this.CURRENT_CHEST != null, () -> this.CURRENT_CHEST.getClass(), true);
                this.syncArgument("item.chestplate.name", () -> this.CURRENT_CHEST != null, () -> this.CURRENT_CHEST_NAME, true);
                this.syncArgument("item.chestplate.message", () -> this.CURRENT_CHEST != null, () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_CHEST_NAME, this.CURRENT_CHEST_NAME));
                this.hasInitializedChest = true;
            }
        } else if (this.hasInitializedChest) {
            CraftPresence.CLIENT.removeArguments("item.chestplate", "data.item.chestplate");
            this.hasInitializedChest = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_LEGS)) {
            if (!this.hasInitializedLegs) {
                this.syncArgument("data.item.leggings.instance", () -> this.CURRENT_LEGS != null, () -> this.CURRENT_LEGS, true);
                this.syncArgument("data.item.leggings.class", () -> this.CURRENT_LEGS != null, () -> this.CURRENT_LEGS.getClass(), true);
                this.syncArgument("item.leggings.name", () -> this.CURRENT_LEGS != null, () -> this.CURRENT_LEGS_NAME, true);
                this.syncArgument("item.leggings.message", () -> this.CURRENT_LEGS != null, () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_LEGS_NAME, this.CURRENT_LEGS_NAME));
                this.hasInitializedLegs = true;
            }
        } else if (this.hasInitializedLegs) {
            CraftPresence.CLIENT.removeArguments("item.leggings", "data.item.leggings");
            this.hasInitializedLegs = false;
        }
        if (!ItemUtils.isItemEmpty((Object)this.CURRENT_BOOTS)) {
            if (!this.hasInitializedBoots) {
                this.syncArgument("data.item.boots.instance", () -> this.CURRENT_BOOTS != null, () -> this.CURRENT_BOOTS, true);
                this.syncArgument("data.item.boots.class", () -> this.CURRENT_BOOTS != null, () -> this.CURRENT_BOOTS.getClass(), true);
                this.syncArgument("item.boots.name", () -> this.CURRENT_BOOTS != null, () -> this.CURRENT_BOOTS_NAME, true);
                this.syncArgument("item.boots.message", () -> this.CURRENT_BOOTS != null, () -> CraftPresence.CONFIG.advancedSettings.itemMessages.getOrDefault(this.CURRENT_BOOTS_NAME, this.CURRENT_BOOTS_NAME));
                this.hasInitializedBoots = true;
            }
        } else if (this.hasInitializedBoots) {
            CraftPresence.CLIENT.removeArguments("item.boots", "data.item.boots");
            this.hasInitializedBoots = false;
        }
    }

    @Override
    public void getInternalData() {
        ItemStack stack;
        List defaultBlocks = StringUtils.newArrayList((Iterator)BuiltInRegistries.f_256975_.iterator());
        List defaultItems = StringUtils.newArrayList((Iterator)BuiltInRegistries.f_257033_.iterator());
        for (Block block : defaultBlocks) {
            if (ItemUtils.isItemEmpty((Object)block)) continue;
            stack = ItemUtils.getStackFrom((Object)block);
            String blockName = ItemUtils.getItemName((Object)stack);
            if (!this.BLOCK_NAMES.contains(blockName)) {
                this.BLOCK_NAMES.add(blockName);
            }
            if (!this.BLOCK_CLASSES.contains(block.getClass().getName())) {
                this.BLOCK_CLASSES.add(block.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(blockName)) continue;
            this.TILE_ENTITY_RESOURCES.put(blockName, stack);
        }
        for (Item item : defaultItems) {
            if (ItemUtils.isItemEmpty((Object)item)) continue;
            stack = ItemUtils.getStackFrom((Object)item);
            String itemName = ItemUtils.getItemName((Object)stack);
            if (!this.ITEM_NAMES.contains(itemName)) {
                this.ITEM_NAMES.add(itemName);
            }
            if (!this.ITEM_CLASSES.contains(item.getClass().getName())) {
                this.ITEM_CLASSES.add(item.getClass().getName());
            }
            if (this.TILE_ENTITY_RESOURCES.containsKey(itemName)) continue;
            this.TILE_ENTITY_RESOURCES.put(itemName, stack);
        }
        this.verifyEntities();
    }

    @Override
    public void getConfigData() {
        for (String itemEntry : CraftPresence.CONFIG.advancedSettings.itemMessages.keySet()) {
            if (StringUtils.isNullOrEmpty((String)itemEntry) || this.TILE_ENTITY_NAMES.contains(itemEntry)) continue;
            this.TILE_ENTITY_NAMES.add(itemEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.advancedSettings.enablePerItem : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public void verifyEntities() {
        for (String item : StringUtils.newArrayList(this.ITEM_NAMES)) {
            if (!ItemUtils.isRawTE((String)item)) continue;
            this.ITEM_NAMES.remove(item);
            if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item)) continue;
            this.ITEM_NAMES.add(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]));
        }
        for (String item : StringUtils.newArrayList(this.BLOCK_NAMES)) {
            if (!ItemUtils.isRawTE((String)item)) continue;
            this.BLOCK_NAMES.remove(item);
            if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item)) continue;
            this.BLOCK_NAMES.add(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]));
        }
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.BLOCK_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_NAMES, this.ITEM_NAMES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.BLOCK_CLASSES);
        StringUtils.addEntriesNotPresent(this.TILE_ENTITY_CLASSES, this.ITEM_CLASSES);
    }
}

