/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.common.item;

import cofh.core.common.config.CoreClientConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.common.item.FishingRodItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.common.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FluxFishingRodItem
extends FishingRodItemCoFH
implements IMultiModeFluxItem {
    protected double reelSpeed = 0.2;
    protected int reelEnergyUseInterval = 8;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxFishingRodItem(int enchantability, int luckModifier, int speedModifier, Item.Properties builder, int energy, int xfer) {
        super(builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.setParams(enchantability, luckModifier, speedModifier);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity, seed) -> {
            if (!(entity instanceof Player)) return 0.0f;
            Player player = (Player)entity;
            if (player.f_36083_ == null) return 0.0f;
            return 1.0f;
        });
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.f_36083_ != null) {
            if (this.isEmpowered(stack) && player.f_36083_.m_37170_() != null) {
                if (player.m_6144_()) {
                    player.f_36083_.m_146870_();
                    return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
                }
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            player.f_36083_.m_37156_(stack);
            this.useEnergy(stack, false, player.f_36077_.f_35937_);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        if (!this.hasEnergy(stack, false)) return InteractionResultHolder.m_19100_((Object)stack);
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        if (!world.f_46443_) {
            int luck = EnchantmentHelper.m_44904_((ItemStack)stack) + this.luckModifier;
            int speed = EnchantmentHelper.m_44916_((ItemStack)stack) + this.speedModifier;
            world.m_7967_((Entity)new FishingHook(player, world, luck, speed));
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
    }

    public void m_5929_(Level world, LivingEntity living, ItemStack stack, int useDuration) {
        if (living instanceof Player) {
            Player player = (Player)living;
            if (player.f_36083_ != null && player.f_36083_.m_37170_() != null && this.isEmpowered(stack)) {
                if (living.m_6144_()) {
                    player.f_36083_.m_146870_();
                } else if (this.useEnergy(stack, true, useDuration % this.reelEnergyUseInterval != 0 || player.f_36077_.f_35937_)) {
                    this.reelIn(stack, player.f_36083_);
                    return;
                }
            }
        }
        living.m_21253_();
    }

    public void reelIn(ItemStack stack, FishingHook bobber) {
        Entity owner = bobber.m_19749_();
        if (!bobber.f_19853_.f_46443_ && owner != null) {
            LivingEntity living;
            Entity target = bobber.m_37170_();
            if (target == null) {
                bobber.m_146870_();
                return;
            }
            if (target instanceof LivingEntity && !(living = (LivingEntity)target).m_6094_()) {
                return;
            }
            Vec3 vel = target.m_20184_();
            Vec3 disp = owner.m_20182_().m_82549_(owner.m_20154_()).m_82546_(bobber.m_20182_());
            double dist = disp.m_82553_();
            Vec3 dir = disp.m_82490_(1.0 / dist);
            target.m_20256_(vel.m_82549_(dir.m_82490_(MathHelper.clamp((double)(dist - vel.m_82526_(dir)), (double)(-this.reelSpeed), (double)this.reelSpeed))));
            target.f_19812_ = true;
            if (disp.m_7098_() > 0.0) {
                bobber.m_37170_().f_19789_ = 0.0f;
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 72000;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            this.useEnergy(stack, false, player.f_36077_.f_35937_);
            if (this.isEmpowered(stack) && player.f_36083_ != null) {
                player.f_36083_.m_146870_();
            }
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((Level)worldIn) && state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    @Override
    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142522_(stack);
    }

    @Override
    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142159_(stack);
    }

    @Override
    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.m_142158_(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

