/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.control;

import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantStack;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.data.ReactantStackData;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.AbstractVerticalIconMultiValueGaugeBar;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.MultiValueGaugeBar;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IntData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;

public class ReactantBar
extends AbstractVerticalIconMultiValueGaugeBar<ReactantType> {
    public ReactantBar(ModContainerScreen<? extends ModContainer> gui, String name, IntData bindableCapacity, ReactantStackData bindableFuelData, ReactantStackData bindableWasteData, IntData bindableFuelRodsCount) {
        super(gui, name, 0.0, (NonNullSupplier)CommonIcons.FuelIcon, (Enum)ReactantType.Waste, (Enum)ReactantType.Fuel, (Enum[])new ReactantType[0]);
        this.setDesiredDimension(18, 84);
        this.bindMaxValue(bindableCapacity);
        ((MultiValueGaugeBar)this._bar).setBarSprite((Enum)ReactantType.Fuel, CachedSprites.REACTOR_FUEL_COLUMN_FLOWING);
        ((MultiValueGaugeBar)this._bar).setBarSprite((Enum)ReactantType.Waste, CachedSprites.REACTOR_FUEL_COLUMN_FLOWING);
        ((MultiValueGaugeBar)this._bar).bindValue((Enum)ReactantType.Fuel, bindableFuelData.amount());
        ((MultiValueGaugeBar)this._bar).bindValue((Enum)ReactantType.Waste, bindableWasteData.amount());
        bindableFuelData.bind(stack -> this.setSpriteTint((ReactantStack)stack, ReactantType.Fuel));
        bindableWasteData.bind(stack -> this.setSpriteTint((ReactantStack)stack, ReactantType.Waste));
        this.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.fuelbar.tooltip.title").addTranslatableAsValue("gui.bigreactors.reactor.controller.fuelbar.tooltip.value1").addTranslatableAsValue("gui.bigreactors.reactor.controller.fuelbar.tooltip.value2").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.fuelbar.tooltip.value3").addTranslatable("gui.bigreactors.reactor.controller.fuelbar.tooltip.value4").addTranslatable("gui.bigreactors.reactor.controller.fuelbar.tooltip.value5").addTranslatable("gui.bigreactors.reactor.controller.fuelbar.tooltip.value6").addTranslatable("gui.bigreactors.reactor.controller.fuelbar.tooltip.value7").addBindableObjectAsValue((IBindableData)bindableFuelData, (IBindableData)bindableWasteData, (fuel, waste) -> this.formatFillRatio()).addBindableObjectAsValue((IBindableData)bindableFuelData, (IBindableData)bindableWasteData, (fuel, waste) -> ReactantBar.formatWastePercentage(fuel.getAmount(), waste.getAmount())).addBindableObjectAsValue(bindableFuelData.amount(), ReactantBar::formatReactantAmount).addBindableObjectAsValue(bindableWasteData.amount(), ReactantBar::formatReactantAmount).addBindableObjectAsValue((IBindableData)bindableFuelData, (IBindableData)bindableWasteData, (fuel, waste) -> ReactantBar.formatReactantAmount(fuel.getAmount() + waste.getAmount())).addBindableObjectAsValue((IBindableData)bindableFuelRodsCount, ReactantBar::formatFuelRodsCount).addBindableObjectAsValue((IBindableData)bindableCapacity, ReactantBar::formatMaxCapacity));
    }

    private static MutableComponent formatReactantAmount(int amount) {
        if (amount <= 0) {
            return CommonMultiblockScreen.EMPTY_VALUE;
        }
        return TextHelper.literal((String)CodeHelper.formatAsMillibuckets((float)amount), ClientBaseHelper::formatAsValue);
    }

    private static MutableComponent formatFuelRodsCount(int count) {
        return TextHelper.literal((String)"%d", text -> text.m_130944_(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.BOLD}), (Object[])new Object[]{count});
    }

    private static MutableComponent formatMaxCapacity(int capacity) {
        return TextHelper.literal((String)CodeHelper.formatAsMillibuckets((float)capacity), text -> text.m_130944_(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.BOLD}), (Object[])new Object[]{capacity});
    }

    private MutableComponent formatFillRatio() {
        return TextHelper.literal((String)"%.2f%%", ClientBaseHelper::formatAsValue, (Object[])new Object[]{((MultiValueGaugeBar)this._bar).getFillRatio() * 100.0});
    }

    private static MutableComponent formatWastePercentage(int fuelAmount, int wasteAmount) {
        int totalAmount = fuelAmount + wasteAmount;
        if (0 == totalAmount) {
            return TextHelper.literal((String)"0%", ClientBaseHelper::formatAsValue);
        }
        return TextHelper.literal((String)"%.2f%%", ClientBaseHelper::formatAsValue, (Object[])new Object[]{Float.valueOf((float)wasteAmount / (float)totalAmount * 100.0f)});
    }

    private void setSpriteTint(ReactantStack stack, ReactantType type) {
        ((MultiValueGaugeBar)this._bar).setBarSpriteTint((Enum)type, stack.getReactant().map(Reactant::getColour).orElse(Colour.WHITE));
    }
}

