/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorControlRodContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControlRodEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.NumberInput;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.TextInput;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.NonNullSupplier;

public class ReactorControlRodScreen
extends CommonMultiblockScreen<MultiblockReactor, ReactorControlRodEntity, ReactorControlRodContainer> {
    private final IControl _nameSection;
    private final IControl _insertionSection;

    public ReactorControlRodScreen(ReactorControlRodContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, ReactorControlRodScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorControlRodEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
        this.ignoreCloseOnInventoryKey(true);
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.REACTOR.buildWithSuffix("part-controlrod"), 1);
        TextInput name = new TextInput((ModContainerScreen)this, "name");
        name.bindText((IBindableData)container.NAME, $ -> $);
        name.setDesiredDimension(DesiredDimension.Height, 16);
        Button nameSet = new Button((ModContainerScreen)this, "nameSet", (Component)TextHelper.translatable((String)"gui.bigreactors.reactor.controlrod.name.set"));
        nameSet.setDesiredDimension(40, 16);
        nameSet.setTooltips(new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controlrod.name.set.tooltip.line1")});
        nameSet.Clicked.subscribe((button, mousebutton) -> this.sendSetName(name.getText()));
        this._nameSection = this.labeledControlSection("name", this.getContentWidth(), "gui.bigreactors.reactor.controlrod.name.label", CommonIcons.LabelEdit, new IControl[]{name, nameSet});
        NumberInput.IntNumberInput insertion = new NumberInput.IntNumberInput((ModContainerScreen)this, "insertion", 0, 100, 0);
        container.INSERTION_RATIO.bind(arg_0 -> ((NumberInput.IntNumberInput)insertion).setValue(arg_0));
        insertion.setStep(1, 10);
        insertion.setDisplaySuffix("%");
        insertion.setHorizontalAlignment(HorizontalAlignment.Right);
        insertion.setDesiredDimension(42, 14);
        insertion.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controlrod.insertion.input.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controlrod.insertion.input.tooltip.body"));
        Button rodSet = new Button((ModContainerScreen)this, "rodSet", (Component)TextHelper.translatable((String)"gui.bigreactors.reactor.controlrod.insertion.set"));
        rodSet.setDesiredDimension(67, 16);
        rodSet.setTooltips(new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controlrod.insertion.set.tooltip.body")});
        rodSet.Clicked.subscribe((button, mousebutton) -> this.sendSetInsertion(insertion.getAsInt(), false));
        Button rodSetAll = new Button((ModContainerScreen)this, "rodSetAll", (Component)Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.setall"));
        rodSetAll.setDesiredDimension(67, 16);
        rodSetAll.setTooltips(new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controlrod.insertion.setall.tooltip.body")});
        rodSetAll.Clicked.subscribe((button, mousebutton) -> this.sendSetInsertion(insertion.getAsInt(), true));
        this._insertionSection = this.labeledControlSection("insertion", this.getContentWidth(), "gui.bigreactors.reactor.controlrod.insertion.label", CommonIcons.ButtonSensorInputSetControlRod, new IControl[]{insertion, rodSet, rodSetAll});
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(ReactorControlRodContainer container) {
        return this.createReactorStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setControlsSpacing(7)).setHorizontalMargin(3)).setVerticalAlignment(VerticalAlignment.Center));
        this.addControl(this._nameSection);
        this.addControl((IControl)CommonPanels.horizontalSeparator((ModContainerScreen)this, (int)this.getContentWidth()));
        this.addControl(this._insertionSection);
    }

    private void sendSetInsertion(int insertion, boolean setAll) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("v", Mth.m_14045_((int)insertion, (int)0, (int)100));
        data.m_128379_("all", setAll);
        this.sendCommandToServer(ReactorControlRodEntity.COMMAND_SET_INSERTION, data);
    }

    private void sendSetName(String name) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("name", name);
        this.sendCommandToServer(ReactorControlRodEntity.COMMAND_SET_NAME, data);
    }

    private IControl labeledControlSection(String name, int width, String labelKey, NonNullSupplier<ISprite> icon, IControl ... controls) {
        Panel panel = new Panel((ModContainerScreen)this, name);
        panel.setDesiredDimension(width, 40);
        panel.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setControlsSpacing(7)).setHorizontalMargin(0)).setVerticalMargin(0));
        Label label = new Label((ModContainerScreen)this, "lbl", (Component)TextHelper.translatable((String)labelKey));
        label.setHorizontalAlignment(HorizontalAlignment.Left);
        label.setDesiredDimension(DesiredDimension.Width, width);
        panel.addControl((IControl)label);
        Panel innerPanel = new Panel((ModContainerScreen)this, "pnl");
        innerPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setVerticalAlignment(VerticalAlignment.Center)).setControlsSpacing(2)).setHorizontalMargin(0));
        innerPanel.setDesiredDimension(width, 18);
        innerPanel.addControl((IControl)CommonPanels.icon((ModContainerScreen)this, icon));
        innerPanel.addControl(controls);
        panel.addControl((IControl)innerPanel);
        return panel;
    }
}

