/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.structure;

import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class TreePoolElement
extends StructurePoolElement {
    public static final Codec<TreePoolElement> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Species.CODEC.fieldOf("species").forGetter(TreePoolElement::getSpecies), (App)BlockPos.f_121852_.optionalFieldOf("offset", (Object)BlockPos.f_121853_).forGetter(TreePoolElement::getOffset), (App)TreePoolElement.m_210538_()).apply((Applicative)instance, TreePoolElement::new));
    private final Species species;
    private final BlockPos offset;
    private final CompoundTag defaultJigsawNBT;

    public TreePoolElement(Species species, StructureTemplatePool.Projection projection) {
        this(species, BlockPos.f_121853_, projection);
    }

    public TreePoolElement(Species species, BlockPos offset, StructureTemplatePool.Projection projection) {
        super(projection);
        this.species = species;
        this.offset = offset;
        this.defaultJigsawNBT = this.fillDefaultJigsawNBT();
    }

    public static Function<StructureTemplatePool.Projection, TreePoolElement> create(Species species) {
        return projection -> new TreePoolElement(species, (StructureTemplatePool.Projection)projection);
    }

    public static Function<StructureTemplatePool.Projection, TreePoolElement> create(Species species, BlockPos offset) {
        return projection -> new TreePoolElement(species, offset, (StructureTemplatePool.Projection)projection);
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", "minecraft:bottom");
        tag.m_128359_("final_state", "minecraft:air");
        tag.m_128359_("pool", "minecraft:empty");
        tag.m_128359_("target", "minecraft:empty");
        tag.m_128359_("joint", JigsawBlockEntity.JointType.ROLLABLE.m_7912_());
        return tag;
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager structureManager, BlockPos pos, Rotation rotation, RandomSource random) {
        return Lists.newArrayList((Object[])new StructureTemplate.StructureBlockInfo[]{new StructureTemplate.StructureBlockInfo(pos, (BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.DOWN, (Direction)Direction.SOUTH)), this.defaultJigsawNBT)});
    }

    public BoundingBox m_214015_(StructureTemplateManager structureManager, BlockPos pos, Rotation rotation) {
        return new BoundingBox(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Vec3i m_213577_(StructureTemplateManager pStructureManager, Rotation pRotation) {
        return Vec3i.f_123288_;
    }

    public boolean m_213695_(StructureTemplateManager structureManager, WorldGenLevel level, StructureManager structureFeatureManager, ChunkGenerator chunkGenerator, BlockPos pos, BlockPos p_210488_, Rotation rotation, BoundingBox box, RandomSource random, boolean keepJigsaws) {
        this.species.plantSapling((LevelAccessor)level, pos, true);
        return true;
    }

    private int getOffsetX(Rotation rotation) {
        return this.offset.m_123341_() * (rotation.m_55948_().m_56526_(Direction.Axis.X) ? -1 : 1);
    }

    private int getOffsetY(Rotation rotation) {
        return this.offset.m_123342_();
    }

    private int getOffsetZ(Rotation rotation) {
        return this.offset.m_123343_() * (rotation.m_55948_().m_56526_(Direction.Axis.Z) ? -1 : 1);
    }

    public StructurePoolElementType<?> m_207234_() {
        return (StructurePoolElementType)DTRegistries.TREE_STRUCTURE_POOL_ELEMENT_TYPE.get();
    }

    public Species getSpecies() {
        return this.species;
    }

    private BlockPos getOffset() {
        return this.offset;
    }
}

