/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.Tags;

public final class OverworldGroundFinder
implements GroundFinder {
    @Override
    public List<BlockPos> findGround(LevelAccessor level, BlockPos start, @Nullable Heightmap.Types heightmap) {
        LinkedList<BlockPos> surfaceGround = new LinkedList<BlockPos>(SURFACE.findGround(level, start, heightmap));
        BlockPos surfaceBlock = surfaceGround.get(0);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(start.m_123341_(), 0, start.m_123343_());
        boolean caveBiomeFound = false;
        while (CoordUtils.inRange((BlockPos)pos, level.m_141937_(), surfaceBlock.m_123342_())) {
            if (level.m_204166_((BlockPos)pos).m_203656_(Tags.Biomes.IS_UNDERGROUND)) {
                caveBiomeFound = true;
                break;
            }
            pos.m_122184_(0, -10, 0);
        }
        if (caveBiomeFound) {
            List<BlockPos> subterraneanGround = SUBTERRANEAN.findGround(level, start, heightmap);
            surfaceGround.addAll(subterraneanGround);
            return new LinkedList<BlockPos>(surfaceGround);
        }
        return surfaceGround;
    }
}

