/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.systems.poissondisc.UniversalPoissonDiscProvider;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.RandomXOR;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public static final UniversalPoissonDiscProvider DISC_PROVIDER = new UniversalPoissonDiscProvider();
    protected static final RandomXOR RANDOM = new RandomXOR();
    private static Block[] concreteBlocks;

    public static void setup() {
        concreteBlocks = (Block[])Arrays.stream(DyeColor.values()).map(color -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_41065_() + "_concrete"))).toArray(Block[]::new);
    }

    public DynamicTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        LevelContext levelContext = LevelContext.create((LevelAccessor)context.m_159774_());
        if (BiomeDatabases.isBlacklisted(levelContext.dimensionName())) {
            return false;
        }
        BiomeDatabase biomeDatabase = BiomeDatabases.getDimensionalOrDefault(levelContext.dimensionName());
        ChunkPos chunkPos = new ChunkPos(context.m_159777_());
        DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).forEach(disc -> this.generateTrees(levelContext, biomeDatabase, (PoissonDisc)disc, context.m_159777_(), SafeChunkBounds.ANY_WG));
        return true;
    }

    public static boolean isFoliage(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, state -> state.m_204336_(DTBlockTags.FOLIAGE));
    }

    protected void generateTrees(LevelContext levelContext, BiomeDatabase biomeDatabase, PoissonDisc disc, BlockPos originPos, SafeChunkBounds safeBounds) {
        BlockPos basePos = new BlockPos(disc.x, 0, disc.z);
        Holder biome = levelContext.accessor().m_204166_(basePos);
        Heightmap.Types heightmap = Heightmap.Types.valueOf((String)biomeDatabase.getHeightmap((Holder<Biome>)biome).toUpperCase());
        for (BlockPos groundPos : GroundFinder.getGroundFinder(levelContext.level()).findGround(levelContext.accessor(), basePos, heightmap)) {
            BiomeDatabase.Entry entry = biomeDatabase.getEntry((Holder<Biome>)levelContext.accessor().m_204166_(groundPos));
            this.generateTree(levelContext, entry, disc, originPos, groundPos, safeBounds);
        }
    }

    private BlockPos OffsetPosIfOnFoliage(LevelAccessor level, BlockPos groundPos) {
        if (this.isNonReplaceableFoliage(level, groundPos)) {
            if (this.isNonReplaceableFoliage(level, groundPos.m_7495_())) {
                return groundPos.m_6625_(2);
            }
            return groundPos.m_7495_();
        }
        return groundPos;
    }

    private boolean isNonReplaceableFoliage(LevelAccessor pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        return !state.m_60795_() && DynamicTreeFeature.validTreePos((LevelSimulatedReader)pLevel, pPos);
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_278411_) || state.m_204336_(DTBlockTags.FOLIAGE));
    }

    protected GeneratorResult generateTree(LevelContext levelContext, BiomeDatabase.EntryReader biomeEntry, PoissonDisc circle, BlockPos originPos, BlockPos groundPos, SafeChunkBounds safeBounds) {
        if (groundPos == BlockPos.f_121853_) {
            return GeneratorResult.NO_GROUND;
        }
        groundPos = this.OffsetPosIfOnFoliage(levelContext.accessor(), groundPos);
        if (levelContext.accessor().m_8055_(groundPos).m_60734_() instanceof RootyBlock) {
            return GeneratorResult.ALREADY_GENERATED;
        }
        RANDOM.setXOR(groundPos);
        BlockState dirtState = levelContext.accessor().m_8055_(groundPos);
        GeneratorResult result = GeneratorResult.GENERATED;
        BiomePropertySelectors.SpeciesSelector speciesSelector = this.getSpeciesSelector(biomeEntry);
        BiomePropertySelectors.SpeciesSelection speciesSelection = speciesSelector.getSpecies(groundPos, dirtState, (RandomSource)RANDOM);
        if (!biomeEntry.isBlacklisted() && speciesSelection.isHandled()) {
            Species species = speciesSelection.getSpecies();
            if (species.isValid()) {
                if (species.isAcceptableSoilForWorldgen(levelContext.accessor(), groundPos, dirtState)) {
                    if (this.getChanceSelector(biomeEntry).getChance((RandomSource)RANDOM, species, circle.radius) == BiomePropertySelectors.Chance.OK) {
                        Holder biome = levelContext.level().m_204166_(groundPos);
                        if (!species.generate(new GenerationContext(levelContext, species, originPos, groundPos.m_122032_(), (Holder<Biome>)biome, CoordUtils.getRandomDir((RandomSource)RANDOM), circle.radius, safeBounds))) {
                            result = GeneratorResult.FAIL_GENERATION;
                        }
                    } else {
                        result = GeneratorResult.FAIL_CHANCE;
                    }
                } else {
                    result = GeneratorResult.FAIL_SOIL;
                }
            } else {
                result = GeneratorResult.NO_TREE;
            }
        } else {
            result = GeneratorResult.UNHANDLED_BIOME;
        }
        if (((Boolean)DTConfigs.WORLD_GEN_DEBUG.get()).booleanValue()) {
            this.generateConcreteCircle(levelContext.accessor(), circle, groundPos.m_123342_(), result, safeBounds);
        }
        return result;
    }

    protected BiomePropertySelectors.SpeciesSelector getSpeciesSelector(BiomeDatabase.EntryReader biomeEntry) {
        return biomeEntry.getSpeciesSelector();
    }

    protected BiomePropertySelectors.ChanceSelector getChanceSelector(BiomeDatabase.EntryReader biomeEntry) {
        return biomeEntry.getChanceSelector();
    }

    private void generateConcreteCircle(LevelAccessor level, PoissonDisc circle, int h, GeneratorResult resultType, SafeChunkBounds safeBounds) {
        this.generateConcreteCircle(level, circle, h, resultType, safeBounds, 0);
    }

    private void generateConcreteCircle(LevelAccessor level, PoissonDisc circle, int h, GeneratorResult resultType, SafeChunkBounds safeBounds, int flags) {
        for (int ix = -circle.radius; ix <= circle.radius; ++ix) {
            for (int iz = -circle.radius; iz <= circle.radius; ++iz) {
                if (!circle.isEdge(circle.x + ix, circle.z + iz)) continue;
                safeBounds.setBlockState(level, new BlockPos(circle.x + ix, h, circle.z + iz), concreteBlocks[(circle.x ^ circle.z) & 0xF].m_49966_(), flags, true);
            }
        }
        if (resultType != GeneratorResult.GENERATED) {
            BlockPos pos = new BlockPos(circle.x, h, circle.z);
            safeBounds.setBlockState(level, pos, resultType.getColoredBlock(), true);
            safeBounds.setBlockState(level, pos.m_7494_(), resultType.getColoredBlock(), true);
        }
    }

    public static enum GeneratorResult {
        GENERATED(DyeColor.WHITE),
        NO_TREE(DyeColor.BLACK),
        UNHANDLED_BIOME(DyeColor.YELLOW),
        FAIL_SOIL(DyeColor.BROWN),
        FAIL_CHANCE(DyeColor.BLUE),
        FAIL_GENERATION(DyeColor.RED),
        NO_GROUND(DyeColor.PURPLE),
        ALREADY_GENERATED(DyeColor.GRAY);

        private final DyeColor color;

        private GeneratorResult(DyeColor color) {
            this.color = color;
        }

        public DyeColor getColor() {
            return this.color;
        }

        public BlockState getColoredBlock() {
            return concreteBlocks[this.color.m_41060_()].m_49966_();
        }
    }
}

