/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substance;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.entity.LingeringEffectorEntity;
import com.ferreusveritas.dynamictrees.systems.substance.FertilizeSubstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class GrowthSubstance
implements SubstanceEffect {
    private final int pulses;
    private final int ticksPerPulse;
    private final int ticksPerParticlePulse = 8;
    private final boolean fillFertility;
    private int pulseCount;

    public GrowthSubstance() {
        this(Integer.MAX_VALUE, 24);
    }

    public GrowthSubstance(int pulses, int ticksPerPulse) {
        this(pulses, ticksPerPulse, true);
    }

    public GrowthSubstance(int pulses, int ticksPerPulse, boolean fillFertility) {
        this.pulses = pulses;
        this.ticksPerPulse = ticksPerPulse;
        this.fillFertility = fillFertility;
    }

    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        if (LingeringEffectorEntity.treeHasEffectorForEffect((LevelAccessor)level, rootPos, this)) {
            return false;
        }
        if (this.fillFertility) {
            new FertilizeSubstance().setAmount(15).setDisplayParticles(false).apply(level, rootPos);
        }
        TreeHelper.treeParticles(level, rootPos, ParticleTypes.f_123806_, 8);
        return true;
    }

    @Override
    public boolean update(Level level, BlockPos rootPos, int deltaTicks, int fertility) {
        if (fertility <= 0 || this.pulseCount >= this.pulses) {
            return false;
        }
        if (level.f_46443_) {
            if (deltaTicks % this.ticksPerParticlePulse == 0) {
                TreeHelper.rootParticles(level, rootPos, Direction.UP, ParticleTypes.f_123806_, 1);
            }
        } else if (deltaTicks % this.ticksPerPulse == 0) {
            TreeHelper.growPulse(level, rootPos);
            ++this.pulseCount;
        }
        return true;
    }

    @Override
    public String getName() {
        return "growth";
    }

    @Override
    public boolean isLingering() {
        return true;
    }
}

