/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.poissondisc;

import com.ferreusveritas.dynamictrees.api.worldgen.PoissonDiscProvider;
import com.ferreusveritas.dynamictrees.event.PoissonDiscProviderCreateEvent;
import com.ferreusveritas.dynamictrees.systems.poissondisc.LevelPoissonDiscProvider;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.worldgen.BiomeRadiusCoordinator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class UniversalPoissonDiscProvider {
    private final Map<ResourceLocation, PoissonDiscProvider> providerMap = new ConcurrentHashMap<ResourceLocation, PoissonDiscProvider>();

    protected PoissonDiscProvider createCircleProvider(LevelContext levelContext) {
        BiomeRadiusCoordinator radiusCoordinator = new BiomeRadiusCoordinator(levelContext.dimensionName(), levelContext.accessor());
        PoissonDiscProviderCreateEvent poissonDiscProviderCreateEvent = new PoissonDiscProviderCreateEvent(levelContext.accessor(), new LevelPoissonDiscProvider(radiusCoordinator).setSeed(levelContext.seed()));
        MinecraftForge.EVENT_BUS.post((Event)poissonDiscProviderCreateEvent);
        return poissonDiscProviderCreateEvent.getPoissonDiscProvider();
    }

    public PoissonDiscProvider getProvider(LevelContext levelContext) {
        return this.providerMap.computeIfAbsent(levelContext.dimensionName(), k -> this.createCircleProvider(levelContext));
    }

    public List<PoissonDisc> getPoissonDiscs(LevelContext levelContext, ChunkPos chunkPos) {
        PoissonDiscProvider provider = this.getProvider(levelContext);
        return provider.getPoissonDiscs(chunkPos.f_45578_, 0, chunkPos.f_45579_);
    }

    public void unloadWorld(ServerLevel level) {
        this.providerMap.remove(level.m_46472_().m_135782_());
    }

    public void setChunkPoissonData(LevelContext levelContext, ChunkPos chunkPos, byte[] circleData) {
        this.getProvider(levelContext).setChunkPoissonData(chunkPos.f_45578_, 0, chunkPos.f_45579_, circleData);
    }

    public byte[] getChunkPoissonData(LevelContext levelContext, ChunkPos chunkPos) {
        return this.getProvider(levelContext).getChunkPoissonData(chunkPos.f_45578_, 0, chunkPos.f_45579_);
    }

    public void unloadChunkPoissonData(LevelContext levelContext, ChunkPos chunkPos) {
        this.getProvider(levelContext).unloadChunkPoissonData(chunkPos.f_45578_, 0, chunkPos.f_45579_);
    }
}

