/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TransformNode
implements NodeInspector {
    private final Species fromSpecies;
    private final Species toSpecies;
    private static final int TEST_LEAVES_RADIUS = 3;

    public TransformNode(Species fromTree, Species toTree) {
        this.fromSpecies = fromTree;
        this.toSpecies = toTree;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        int radius;
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null && this.fromSpecies.getFamily() == branch.getFamily() && (radius = branch.getRadius(state)) > 0) {
            BranchBlock newBranchBlock = this.toSpecies.getFamily().getBranch().orElse(null);
            if (this.fromSpecies.getFamily().getStrippedBranch().orElse(null) == branch) {
                newBranchBlock = this.toSpecies.getFamily().getStrippedBranch().get();
            }
            newBranchBlock.setRadius(level, pos, radius, null);
            if (radius == 1) {
                this.transformSurroundingLeaves(level, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(LevelAccessor world, BlockPos twigPos) {
        if (world.m_5776_()) {
            return;
        }
        SimpleVoxmap leafCluster = this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster();
        int xBound = leafCluster.getLenX();
        int yBound = leafCluster.getLenY();
        int zBound = leafCluster.getLenZ();
        BlockPos.m_121990_((BlockPos)twigPos.m_7918_(-xBound, -yBound, -zBound), (BlockPos)twigPos.m_7918_(xBound, yBound, zBound)).forEach(testPos -> {
            if (this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster().getVoxel(twigPos, (BlockPos)testPos) == 0) {
                return;
            }
            BlockState state = world.m_8055_(testPos);
            if (this.fromSpecies.getFamily().isCompatibleGenericLeaves(this.fromSpecies, state, world, (BlockPos)testPos)) {
                int hydro = state.m_60734_() instanceof DynamicLeavesBlock ? (Integer)state.m_61143_((Property)DynamicLeavesBlock.f_54418_) : 2;
                world.m_7731_(testPos, this.toSpecies.getLeavesProperties().getDynamicLeavesState(hydro), 3);
            }
        });
    }
}

