/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FreezerNode
implements NodeInspector {
    private final Species species;
    private static final int freezeRadius = 3;

    public FreezerNode(Species species) {
        this.species = species;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        int radius;
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null && (radius = branch.getRadius(state)) == 1) {
            this.freezeSurroundingLeaves(level, branch, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void freezeSurroundingLeaves(LevelAccessor world, BranchBlock branch, BlockPos twigPos) {
        if (world.m_5776_()) {
            return;
        }
        Family tree = branch.getFamily();
        BlockPos.m_121990_((BlockPos)twigPos.m_7918_(-3, -3, -3), (BlockPos)twigPos.m_7918_(3, 3, 3)).forEach(leavesPos -> {
            if (!tree.isCompatibleGenericLeaves(this.species, world.m_8055_(leavesPos), world, (BlockPos)leavesPos)) {
                return;
            }
            BlockState state = world.m_8055_(leavesPos);
            DynamicLeavesBlock leaves = TreeHelper.getLeaves(state);
            if (leaves == null) {
                return;
            }
            world.m_7731_(leavesPos, (BlockState)leaves.getProperties(state).getPrimitiveLeaves().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 2);
        });
    }
}

